/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.shield.rest.action.role;

import org.elasticsearch.action.ActionListener;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.ElasticsearchClient;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.BytesRestResponse;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.action.support.RestBuilderListener;
import org.elasticsearch.shield.action.role.GetRolesResponse;
import org.elasticsearch.shield.authz.RoleDescriptor;
import org.elasticsearch.shield.client.ShieldClient;

public class RestGetRolesAction
extends BaseRestHandler {
    @Inject
    public RestGetRolesAction(Settings settings, RestController controller, Client client) {
        super(settings, controller, client);
        controller.registerHandler(RestRequest.Method.GET, "/_shield/role/", (RestHandler)this);
        controller.registerHandler(RestRequest.Method.GET, "/_shield/role/{name}", (RestHandler)this);
    }

    protected void handleRequest(RestRequest request, RestChannel channel, Client client) throws Exception {
        final String[] roles = request.paramAsStringArray("name", Strings.EMPTY_ARRAY);
        new ShieldClient((ElasticsearchClient)client).prepareGetRoles(roles).execute((ActionListener)new RestBuilderListener<GetRolesResponse>(channel){

            public RestResponse buildResponse(GetRolesResponse response, XContentBuilder builder) throws Exception {
                builder.startObject();
                for (RoleDescriptor role : response.roles()) {
                    builder.field(role.getName(), (ToXContent)role);
                }
                builder.endObject();
                if (roles.length != 0 && response.roles().length == 0) {
                    return new BytesRestResponse(RestStatus.NOT_FOUND, builder);
                }
                return new BytesRestResponse(RestStatus.OK, builder);
            }
        });
    }
}

