/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.shield.license;

import org.elasticsearch.common.Strings;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.license.core.License;
import org.elasticsearch.license.plugin.core.AbstractLicenseeComponent;
import org.elasticsearch.license.plugin.core.Licensee;
import org.elasticsearch.license.plugin.core.LicenseeRegistry;
import org.elasticsearch.shield.license.ShieldLicenseState;

public class ShieldLicensee
extends AbstractLicenseeComponent<ShieldLicensee>
implements Licensee {
    private final ShieldLicenseState shieldLicenseState;

    @Inject
    public ShieldLicensee(Settings settings, LicenseeRegistry clientService, ShieldLicenseState shieldLicenseState) {
        super(settings, "shield", clientService);
        this.shieldLicenseState = shieldLicenseState;
    }

    public void onChange(Licensee.Status status) {
        super.onChange(status);
        this.shieldLicenseState.updateStatus(status);
    }

    public String[] expirationMessages() {
        return new String[]{"Cluster health, cluster stats and indices stats operations are blocked", "All data operations (read and write) continue to work"};
    }

    public String[] acknowledgmentMessages(License currentLicense, License newLicense) {
        switch (newLicense.operationMode()) {
            case BASIC: {
                if (currentLicense == null) break;
                switch (currentLicense.operationMode()) {
                    case TRIAL: 
                    case GOLD: 
                    case PLATINUM: {
                        return new String[]{"The following Shield functionality will be disabled: authentication, authorization, ip filtering, auditing, SSL will be disabled on node restart. Please restart your node after applying the license."};
                    }
                }
                break;
            }
            case GOLD: {
                if (currentLicense == null) break;
                switch (currentLicense.operationMode()) {
                    case TRIAL: 
                    case PLATINUM: 
                    case BASIC: {
                        return new String[]{"Field and document level access control will be disabled", "Custom realms will be ignored"};
                    }
                }
            }
        }
        return Strings.EMPTY_ARRAY;
    }
}

