/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.shield.license;

import org.elasticsearch.license.core.License;
import org.elasticsearch.license.plugin.core.LicenseState;
import org.elasticsearch.license.plugin.core.Licensee;

public class ShieldLicenseState {
    protected volatile Licensee.Status status = Licensee.Status.ENABLED;

    public boolean securityEnabled() {
        return this.status.getMode() != License.OperationMode.BASIC;
    }

    public boolean statsAndHealthEnabled() {
        return this.status.getLicenseState() != LicenseState.DISABLED;
    }

    public boolean documentAndFieldLevelSecurityEnabled() {
        Licensee.Status status = this.status;
        return status.getMode() == License.OperationMode.PLATINUM || status.getMode() == License.OperationMode.TRIAL;
    }

    public boolean customRealmsEnabled() {
        Licensee.Status status = this.status;
        return status.getMode() == License.OperationMode.PLATINUM || status.getMode() == License.OperationMode.TRIAL;
    }

    void updateStatus(Licensee.Status status) {
        this.status = status;
    }
}

