/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.shield.authz.store;

import com.google.common.base.Charsets;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.component.AbstractLifecycleComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentGenerator;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.json.JsonXContent;
import org.elasticsearch.common.xcontent.yaml.YamlXContent;
import org.elasticsearch.env.Environment;
import org.elasticsearch.shield.ShieldPlugin;
import org.elasticsearch.shield.authc.support.RefreshListener;
import org.elasticsearch.shield.authz.Permission;
import org.elasticsearch.shield.authz.Privilege;
import org.elasticsearch.shield.authz.RoleDescriptor;
import org.elasticsearch.shield.authz.accesscontrol.AccessControlShardModule;
import org.elasticsearch.shield.authz.store.RolesStore;
import org.elasticsearch.shield.support.NoOpLogger;
import org.elasticsearch.shield.support.Validation;
import org.elasticsearch.watcher.FileChangesListener;
import org.elasticsearch.watcher.FileWatcher;
import org.elasticsearch.watcher.ResourceWatcher;
import org.elasticsearch.watcher.ResourceWatcherService;
import org.yaml.snakeyaml.error.YAMLException;

public class FileRolesStore
extends AbstractLifecycleComponent<RolesStore>
implements RolesStore {
    private static final Pattern COMMA_DELIM = Pattern.compile("\\s*,\\s*");
    private static final Pattern IN_SEGMENT_LINE = Pattern.compile("^\\s+.+");
    private static final Pattern SKIP_LINE = Pattern.compile("(^#.*|^\\s*)");
    private final Path file;
    private final RefreshListener listener;
    private final ImmutableSet<Permission.Global.Role> reservedRoles;
    private final ResourceWatcherService watcherService;
    private volatile ImmutableMap<String, Permission.Global.Role> permissions;

    @Inject
    public FileRolesStore(Settings settings, Environment env, ResourceWatcherService watcherService, Set<Permission.Global.Role> reservedRoles) {
        this(settings, env, watcherService, reservedRoles, RefreshListener.NOOP);
    }

    public FileRolesStore(Settings settings, Environment env, ResourceWatcherService watcherService, Set<Permission.Global.Role> reservedRoles, RefreshListener listener) {
        super(settings);
        this.file = FileRolesStore.resolveFile(settings, env);
        this.listener = listener;
        this.watcherService = watcherService;
        this.reservedRoles = ImmutableSet.copyOf(reservedRoles);
        this.permissions = ImmutableMap.of();
    }

    protected void doStart() throws ElasticsearchException {
        FileWatcher watcher = new FileWatcher(this.file.getParent());
        watcher.addListener((Object)new FileListener());
        try {
            this.watcherService.add((ResourceWatcher)watcher, ResourceWatcherService.Frequency.HIGH);
        }
        catch (IOException e) {
            throw new ElasticsearchException("failed to setup roles file watcher", (Throwable)e, new Object[0]);
        }
        this.permissions = FileRolesStore.parseFile(this.file, this.reservedRoles, this.logger, this.settings, this.deprecationLogger);
    }

    protected void doStop() throws ElasticsearchException {
    }

    protected void doClose() throws ElasticsearchException {
    }

    @Override
    public Permission.Global.Role role(String role) {
        return (Permission.Global.Role)this.permissions.get((Object)role);
    }

    public static Path resolveFile(Settings settings, Environment env) {
        String location = settings.get("shield.authz.store.files.roles");
        if (location == null) {
            return ShieldPlugin.resolveConfigFile(env, "roles.yml");
        }
        return env.binFile().getParent().resolve(location);
    }

    public static ImmutableSet<String> parseFileForRoleNames(Path path, ESLogger logger) {
        ImmutableMap<String, Permission.Global.Role> roleMap = FileRolesStore.parseFile(path, Collections.emptySet(), logger, false, Settings.EMPTY, new DeprecationLogger(logger));
        if (roleMap == null) {
            return ImmutableSet.builder().build();
        }
        return roleMap.keySet();
    }

    public static ImmutableMap<String, Permission.Global.Role> parseFile(Path path, Set<Permission.Global.Role> reservedRoles, ESLogger logger, Settings settings, DeprecationLogger deprecationLogger) {
        return FileRolesStore.parseFile(path, reservedRoles, logger, true, settings, deprecationLogger);
    }

    public static ImmutableMap<String, Permission.Global.Role> parseFile(Path path, Set<Permission.Global.Role> reservedRoles, ESLogger logger, boolean resolvePermission, Settings settings, DeprecationLogger deprecationLogger) {
        if (logger == null) {
            logger = NoOpLogger.INSTANCE;
        }
        HashMap<String, Permission.Global.Role> roles = new HashMap<String, Permission.Global.Role>();
        logger.trace("attempting to read roles file located at [{}]", new Object[]{path.toAbsolutePath()});
        if (Files.exists(path, new LinkOption[0])) {
            try {
                List<String> roleSegments = FileRolesStore.roleSegments(path);
                for (String segment : roleSegments) {
                    Permission.Global.Role role = FileRolesStore.parseRole(segment, path, logger, resolvePermission, settings, deprecationLogger);
                    if (role == null) continue;
                    if ("__es_system_role".equals(role.name())) {
                        logger.warn("role [{}] is reserved. the relevant role definition in the mapping file will be ignored", new Object[]{role.name()});
                        continue;
                    }
                    roles.put(role.name(), role);
                }
            }
            catch (IOException ioe) {
                logger.error("failed to read roles file [{}]. skipping all roles...", (Throwable)ioe, new Object[]{path.toAbsolutePath()});
            }
        }
        for (Permission.Global.Role reservedRole : reservedRoles) {
            if (roles.containsKey(reservedRole.name())) {
                logger.warn("role [{}] is reserved to the system. the relevant role definition in the mapping file will be ignored", new Object[]{reservedRole.name()});
            }
            roles.put(reservedRole.name(), reservedRole);
        }
        return ImmutableMap.copyOf(roles);
    }

    public static ImmutableMap<String, RoleDescriptor> parseRoleDescriptors(Path path, ESLogger logger, Settings settings, DeprecationLogger deprecationLogger) {
        if (logger == null) {
            logger = NoOpLogger.INSTANCE;
        }
        HashMap<String, RoleDescriptor> roles = new HashMap<String, RoleDescriptor>();
        logger.trace("attempting to read roles file located at [{}]", new Object[]{path.toAbsolutePath()});
        if (Files.exists(path, new LinkOption[0])) {
            try {
                List<String> roleSegments = FileRolesStore.roleSegments(path);
                for (String segment : roleSegments) {
                    RoleDescriptor rd = FileRolesStore.parseRoleDescriptor(segment, path, logger, true, settings, deprecationLogger);
                    if (rd == null) continue;
                    if ("__es_system_role".equals(rd.getName())) {
                        logger.warn("role [{}] is reserved. the relevant role definition in the mapping file will be ignored", new Object[]{rd.getName()});
                        continue;
                    }
                    roles.put(rd.getName(), rd);
                }
            }
            catch (IOException ioe) {
                logger.error("failed to read roles file [{}]. skipping all roles...", (Throwable)ioe, new Object[]{path.toAbsolutePath()});
            }
        }
        return ImmutableMap.copyOf(roles);
    }

    @Nullable
    private static Permission.Global.Role parseRole(String segment, Path path, ESLogger logger, boolean resolvePermissions, Settings settings, DeprecationLogger deprecationLogger) {
        RoleDescriptor rd = FileRolesStore.parseRoleDescriptor(segment, path, logger, resolvePermissions, settings, deprecationLogger);
        if (rd == null) {
            return null;
        }
        Permission.Global.Role.Builder roleBuilder = Permission.Global.Role.builder(rd.getName());
        if (!resolvePermissions) {
            return roleBuilder.build();
        }
        if (rd.getClusterPrivileges().length > 0) {
            try {
                roleBuilder.cluster(Privilege.Cluster.get(new Privilege.Name(rd.getClusterPrivileges())));
            }
            catch (IllegalArgumentException e) {
                logger.error("invalid role definition [{}] in roles file [{}]. could not resolve cluster privileges [{}]. skipping role...", new Object[]{rd.getName(), path.toAbsolutePath(), new Privilege.Name(rd.getClusterPrivileges())});
                return null;
            }
        }
        if (rd.getRunAs() != null && rd.getRunAs().length > 0) {
            try {
                roleBuilder.runAs(new Privilege.General(new Privilege.Name(rd.getRunAs()), rd.getRunAs()));
            }
            catch (IllegalArgumentException e) {
                logger.error("invalid role definition [{}] in roles file [{}]. could not resolve run_as privileges [{}]. skipping role...", new Object[]{rd.getName(), path.toAbsolutePath(), new Privilege.Name(rd.getRunAs())});
                return null;
            }
        }
        for (RoleDescriptor.IndicesPrivileges idxPriv : rd.getIndicesPrivileges()) {
            String[] indices = idxPriv.getIndices();
            String[] privileges = idxPriv.getPrivileges();
            BytesReference query = idxPriv.getQuery();
            String[] fields = idxPriv.getFields();
            if (privileges == null || privileges.length == 0) continue;
            if ((query != null || fields != null && fields.length > 0) && !AccessControlShardModule.enabled(settings)) {
                logger.error("invalid role definition [{}] in roles file [{}]. document and field level security is not enabled. set [{}] to [true] in the configuration file. skipping role...", new Object[]{rd.getName(), path.toAbsolutePath(), "shield.dls_fls.enabled"});
                return null;
            }
            try {
                if (query != null || fields != null) {
                    roleBuilder.add(fields == null ? null : Arrays.asList(fields), query, Privilege.Index.get(new Privilege.Name(privileges)), indices);
                    continue;
                }
                roleBuilder.add(Privilege.Index.get(new Privilege.Name(privileges)), indices);
            }
            catch (IllegalArgumentException e) {
                logger.error("invalid role definition [{}] in roles file [{}]. could not resolve indices privileges [{}]. skipping role...", new Object[]{rd.getName(), path.toAbsolutePath(), new Privilege.Name(privileges)});
                return null;
            }
        }
        return roleBuilder.build();
    }

    @Nullable
    private static RoleDescriptor parseRoleDescriptor(String segment, Path path, ESLogger logger, boolean resolvePermissions, Settings settings, DeprecationLogger deprecationLogger) {
        block50: {
            String roleName = null;
            try {
                String[] clusterPrivileges = null;
                String[] runAsUsers = null;
                ArrayList<RoleDescriptor.IndicesPrivileges> indexPrivileges = new ArrayList<RoleDescriptor.IndicesPrivileges>();
                XContentParser parser = YamlXContent.yamlXContent.createParser(segment);
                XContentParser.Token token = parser.nextToken();
                if (token != XContentParser.Token.START_OBJECT || (token = parser.nextToken()) != XContentParser.Token.FIELD_NAME) break block50;
                roleName = parser.currentName();
                Validation.Error validationError = Validation.Roles.validateRoleName(roleName);
                if (validationError != null) {
                    logger.error("invalid role definition [{}] in roles file [{}]. invalid role name - {}. skipping role... ", new Object[]{roleName, path.toAbsolutePath(), validationError});
                    return null;
                }
                if (!resolvePermissions) {
                    return new RoleDescriptor(roleName, null, null, null);
                }
                token = parser.nextToken();
                if (token == XContentParser.Token.START_OBJECT) {
                    String currentFieldName = null;
                    while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                        HashSet<String> names;
                        String namesStr;
                        if (token == XContentParser.Token.FIELD_NAME) {
                            currentFieldName = parser.currentName();
                            continue;
                        }
                        if ("cluster".equals(currentFieldName)) {
                            if (token == XContentParser.Token.VALUE_STRING || token == XContentParser.Token.VALUE_NULL) {
                                deprecationLogger.deprecated("role definition [{}] in roles file [{}] uses the comma separated format for specifying cluster privileges. support for this format will be removed in the future  in favor of the array format", new Object[]{roleName, path.toAbsolutePath()});
                                namesStr = parser.textOrNull();
                                if (!Strings.hasText((String)namesStr)) continue;
                                clusterPrivileges = COMMA_DELIM.split(namesStr);
                                continue;
                            }
                            if (token == XContentParser.Token.START_ARRAY) {
                                names = new HashSet<String>();
                                while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                                    if (token != XContentParser.Token.VALUE_STRING) continue;
                                    names.add(parser.text());
                                }
                                if (names.isEmpty()) continue;
                                clusterPrivileges = names.toArray(new String[names.size()]);
                                continue;
                            }
                            logger.error("invalid role definition [{}] in roles file [{}]. [cluster] field value can either be a string or a list of strings, but [{}] was found instead. skipping role...", new Object[]{roleName, path.toAbsolutePath(), token});
                            return null;
                        }
                        if ("indices".equals(currentFieldName)) {
                            if (token == XContentParser.Token.START_OBJECT) {
                                String[] indices = null;
                                String query = null;
                                String[] privileges = null;
                                String[] fields = null;
                                deprecationLogger.deprecated("role definition [{}] in roles file [{}] uses the deprecated form for defining indices permissions. please refer to the documentation or the updated roles file for the new format", new Object[]{roleName, path.toAbsolutePath()});
                                while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                                    if (token == XContentParser.Token.FIELD_NAME) {
                                        String namesStr2;
                                        currentFieldName = parser.currentName();
                                        if (!Strings.hasLength((String)currentFieldName)) continue;
                                        indices = COMMA_DELIM.split(currentFieldName);
                                        token = parser.nextToken();
                                        if (token == XContentParser.Token.VALUE_STRING) {
                                            namesStr2 = parser.text().trim();
                                            if (Strings.hasLength((String)namesStr2)) {
                                                privileges = COMMA_DELIM.split(parser.text());
                                            }
                                        } else if (token != XContentParser.Token.VALUE_NULL) {
                                            HashSet<String> names2;
                                            if (token == XContentParser.Token.START_ARRAY) {
                                                names2 = new HashSet<String>();
                                                while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                                                    if (token == XContentParser.Token.VALUE_STRING) {
                                                        names2.add(parser.text());
                                                        continue;
                                                    }
                                                    logger.error("invalid role definition [{}] in roles file [{}]. could not parse [{}] as index privilege. privilege names must be strings. skipping role...", new Object[]{roleName, path.toAbsolutePath(), token});
                                                    return null;
                                                }
                                                privileges = names2.toArray(new String[names2.size()]);
                                            } else if (token == XContentParser.Token.START_OBJECT) {
                                                while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                                                    if (token == XContentParser.Token.FIELD_NAME) {
                                                        currentFieldName = parser.currentName();
                                                        continue;
                                                    }
                                                    if ("fields".equals(currentFieldName)) {
                                                        if (token == XContentParser.Token.START_ARRAY) {
                                                            HashSet<String> fieldNames = new HashSet<String>();
                                                            while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                                                                if (token == XContentParser.Token.VALUE_STRING) {
                                                                    fieldNames.add(parser.text());
                                                                    continue;
                                                                }
                                                                logger.error("invalid role definition [{}] in roles file [{}]. could not parse [{}] as field name. field names must be strings. skipping role...", new Object[]{roleName, path.toAbsolutePath(), token});
                                                                return null;
                                                            }
                                                            if (fieldNames.isEmpty()) continue;
                                                            fields = fieldNames.toArray(new String[fieldNames.size()]);
                                                            continue;
                                                        }
                                                        if (!token.isValue() && token != XContentParser.Token.VALUE_NULL) continue;
                                                        String field = parser.textOrNull();
                                                        if (!Strings.hasText((String)field)) {
                                                            fields = Strings.EMPTY_ARRAY;
                                                            continue;
                                                        }
                                                        fields = COMMA_DELIM.split(field);
                                                        continue;
                                                    }
                                                    if ("query".equals(currentFieldName)) {
                                                        if (token == XContentParser.Token.START_OBJECT) {
                                                            XContentBuilder builder = JsonXContent.contentBuilder();
                                                            XContentHelper.copyCurrentStructure((XContentGenerator)builder.generator(), (XContentParser)parser);
                                                            query = builder.string();
                                                            continue;
                                                        }
                                                        if (token != XContentParser.Token.VALUE_STRING) continue;
                                                        query = parser.textOrNull();
                                                        continue;
                                                    }
                                                    if (!"privileges".equals(currentFieldName)) continue;
                                                    if (token == XContentParser.Token.VALUE_STRING) {
                                                        namesStr2 = parser.text().trim();
                                                        if (!Strings.hasLength((String)namesStr2)) continue;
                                                        privileges = COMMA_DELIM.split(namesStr2);
                                                        continue;
                                                    }
                                                    if (token != XContentParser.Token.START_ARRAY) continue;
                                                    names2 = new HashSet();
                                                    while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                                                        if (token == XContentParser.Token.VALUE_STRING) {
                                                            String priv = parser.text();
                                                            names2.add(priv);
                                                            continue;
                                                        }
                                                        logger.error("invalid role definition [{}] in roles file [{}]. could not parse [{}] as index privilege. privilege names must be strings. skipping role...", new Object[]{roleName, path.toAbsolutePath(), token});
                                                        return null;
                                                    }
                                                    privileges = names2.toArray(new String[names2.size()]);
                                                }
                                            } else if (token == XContentParser.Token.FIELD_NAME) {
                                                currentFieldName = parser.currentName();
                                            } else {
                                                logger.error("invalid role definition [{}] in roles file [{}]. could not parse [{}] as index privileges. privilege lists must either be a comma delimited string or an array of strings. skipping role...", new Object[]{roleName, path.toAbsolutePath(), token});
                                                return null;
                                            }
                                        }
                                    }
                                    LenientIndicesPrivileges ip = new LenientIndicesPrivileges(indices, privileges, fields, query);
                                    indexPrivileges.add(ip);
                                }
                                continue;
                            }
                            if (token == XContentParser.Token.START_ARRAY) {
                                try {
                                    RoleDescriptor.IndicesPrivileges[] indicesPrivileges;
                                    for (RoleDescriptor.IndicesPrivileges priv : indicesPrivileges = RoleDescriptor.parseIndices(roleName, parser)) {
                                        indexPrivileges.add(priv);
                                    }
                                    continue;
                                }
                                catch (Exception e) {
                                    if (e instanceof ElasticsearchParseException) {
                                        logger.error(e.getMessage() + ". skipping role...", new Object[0]);
                                    } else {
                                        logger.error("invalid role definition [{}] in roles file [{}]. skipping role...", (Throwable)e, new Object[]{roleName, path.toAbsolutePath()});
                                    }
                                    return null;
                                }
                            }
                            logger.error("invalid role definition [{}] in roles file [{}]. [indices] field value must be an array of indices-privileges mappings defined as a string in the form <comma-separated list of index name patterns>::<comma-separated list of privileges> , but [{}] was found instead. skipping role...", new Object[]{roleName, path.toAbsolutePath(), token});
                            return null;
                        }
                        if ("run_as".equals(currentFieldName)) {
                            if (token == XContentParser.Token.VALUE_STRING) {
                                namesStr = parser.text().trim();
                                if (!Strings.hasLength((String)namesStr)) continue;
                                runAsUsers = COMMA_DELIM.split(namesStr);
                                continue;
                            }
                            if (token == XContentParser.Token.START_ARRAY) {
                                names = new HashSet();
                                while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                                    if (token != XContentParser.Token.VALUE_STRING) continue;
                                    names.add(parser.text());
                                }
                                if (names.isEmpty()) continue;
                                runAsUsers = names.toArray(new String[names.size()]);
                                continue;
                            }
                            logger.error("invalid role definition [{}] in roles file [{}]. [run_as] field value can either be a string or a list of strings, but [{}] was found instead. skipping role...", new Object[]{roleName, path.toAbsolutePath(), token});
                            return null;
                        }
                        logger.warn("unknown field [{}] found in role definition [{}] in roles file [{}]", new Object[]{currentFieldName, roleName, path.toAbsolutePath()});
                    }
                    return new RoleDescriptor(roleName, clusterPrivileges, indexPrivileges.toArray(new RoleDescriptor.IndicesPrivileges[indexPrivileges.size()]), runAsUsers);
                }
                logger.error("invalid role definition [{}] in roles file [{}]. skipping role...", new Object[]{roleName, path.toAbsolutePath()});
            }
            catch (IOException | YAMLException e) {
                if (roleName != null) {
                    logger.error("invalid role definition [{}] in roles file [{}]. skipping role...", e, new Object[]{roleName, path});
                }
                logger.error("invalid role definition in roles file [{}]. skipping role...", e, new Object[]{path});
            }
        }
        return null;
    }

    private static List<String> roleSegments(Path path) throws IOException {
        ArrayList<String> segments = new ArrayList<String>();
        StringBuilder builder = null;
        for (String line : Files.readAllLines(path, Charsets.UTF_8)) {
            if (SKIP_LINE.matcher(line).matches()) continue;
            if (IN_SEGMENT_LINE.matcher(line).matches()) {
                if (builder == null) continue;
                builder.append(line).append("\n");
                continue;
            }
            if (builder != null) {
                segments.add(builder.toString());
            }
            builder = new StringBuilder(line).append("\n");
        }
        if (builder != null) {
            segments.add(builder.toString());
        }
        return segments;
    }

    public static class LenientIndicesPrivileges
    extends RoleDescriptor.IndicesPrivileges {
        private String[] indices;
        private String[] privileges;
        private String[] fields;
        private BytesReference query;

        public LenientIndicesPrivileges(String[] indices, String[] privileges, String[] fields, String query) {
            this.indices = indices;
            this.privileges = privileges;
            this.fields = fields;
            this.query = query == null ? null : new BytesArray(query);
        }

        @Override
        public String[] getIndices() {
            return this.indices;
        }

        @Override
        @Nullable
        public String[] getPrivileges() {
            return this.privileges;
        }

        @Override
        @Nullable
        public String[] getFields() {
            return this.fields;
        }

        @Override
        @Nullable
        public BytesReference getQuery() {
            return this.query;
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder("LenientIndicesPrivileges[");
            sb.append("indices=[").append(Strings.arrayToCommaDelimitedString((Object[])this.indices));
            sb.append("], privileges=[").append(Strings.arrayToCommaDelimitedString((Object[])this.privileges));
            sb.append("], fields=[").append(Strings.arrayToCommaDelimitedString((Object[])this.fields));
            if (this.query != null) {
                sb.append("], query=").append(this.query.toUtf8());
            }
            sb.append("]");
            return sb.toString();
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            throw new UnsupportedOperationException("should never be serialized");
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            throw new UnsupportedOperationException("should never be serialized");
        }
    }

    private class FileListener
    extends FileChangesListener {
        private FileListener() {
        }

        public void onFileCreated(Path file) {
            this.onFileChanged(file);
        }

        public void onFileDeleted(Path file) {
            this.onFileChanged(file);
        }

        public void onFileChanged(Path file) {
            if (file.equals(FileRolesStore.this.file)) {
                try {
                    FileRolesStore.this.permissions = FileRolesStore.parseFile(file, (Set<Permission.Global.Role>)FileRolesStore.this.reservedRoles, FileRolesStore.this.logger, FileRolesStore.this.settings, FileRolesStore.this.deprecationLogger);
                    FileRolesStore.this.logger.info("updated roles (roles file [{}] changed)", new Object[]{file.toAbsolutePath()});
                }
                catch (Throwable t) {
                    FileRolesStore.this.logger.error("could not reload roles file [{}]. Current roles remain unmodified", t, new Object[]{file.toAbsolutePath()});
                    return;
                }
                FileRolesStore.this.listener.onRefresh();
            }
        }
    }
}

