/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.shield.authz.store;

import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.shield.authz.Permission;
import org.elasticsearch.shield.authz.esnative.ESNativeRolesStore;
import org.elasticsearch.shield.authz.store.FileRolesStore;
import org.elasticsearch.shield.authz.store.RolesStore;

public class CompositeRolesStore
implements RolesStore {
    private final FileRolesStore fileRolesStore;
    private final ESNativeRolesStore nativeRolesStore;

    @Inject
    public CompositeRolesStore(FileRolesStore fileRolesStore, ESNativeRolesStore nativeRolesStore) {
        this.fileRolesStore = fileRolesStore;
        this.nativeRolesStore = nativeRolesStore;
    }

    @Override
    public Permission.Global.Role role(String role) {
        Permission.Global.Role fileRole = this.fileRolesStore.role(role);
        if (fileRole != null) {
            return fileRole;
        }
        return this.nativeRolesStore.role(role);
    }
}

