/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.shield.authz;

import com.google.common.base.Predicate;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.UncheckedExecutionException;
import dk.brics.automaton.Automaton;
import dk.brics.automaton.BasicOperations;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.elasticsearch.common.Strings;
import org.elasticsearch.shield.support.AutomatonPredicate;
import org.elasticsearch.shield.support.Automatons;

public abstract class Privilege<P extends Privilege<P>> {
    static final String SUB_ACTION_SUFFIX_PATTERN = "*";
    public static final System SYSTEM = new System();
    public static final General HEALTH_AND_STATS = new General("health_and_stats", "cluster:monitor/health*", "cluster:monitor/stats*", "indices:monitor/stats*", "cluster:monitor/nodes/stats*");
    protected final Name name;

    private Privilege(Name name) {
        this.name = name;
    }

    public Name name() {
        return this.name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Privilege privilege = (Privilege)o;
        return !(this.name != null ? !this.name.equals(privilege.name) : privilege.name != null);
    }

    public int hashCode() {
        return this.name != null ? this.name.hashCode() : 0;
    }

    public abstract Predicate<String> predicate();

    public abstract boolean implies(P var1);

    public boolean isAlias(P other) {
        return this.implies(other) && other.implies((Privilege)this);
    }

    static String actionToPattern(String text) {
        return text + SUB_ACTION_SUFFIX_PATTERN;
    }

    public static class Name {
        public static final Name NONE = new Name("none");
        public static final Name ALL = new Name("all");
        private final ImmutableSet<String> parts;

        public Name(String name) {
            assert (name != null && !name.contains(",")) : "single string name should not be null or contain commas";
            this.parts = ImmutableSet.of((Object)name);
        }

        public Name(Set<String> parts) {
            assert (!parts.isEmpty()) : "cannot create a Name from an empty list of parts";
            this.parts = ImmutableSet.copyOf(parts);
        }

        public Name(String ... parts) {
            this((Set<String>)ImmutableSet.copyOf((Object[])parts));
        }

        public String toString() {
            return Strings.collectionToCommaDelimitedString(this.parts);
        }

        public Name add(Name other) {
            return new Name((Set<String>)Sets.union(this.parts, other.parts));
        }

        public Name remove(Name other) {
            Sets.SetView parts = Sets.difference(this.parts, other.parts);
            return parts.isEmpty() ? NONE : new Name((Set<String>)parts);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Name name = (Name)o;
            return this.parts.equals(name.parts);
        }

        public int hashCode() {
            return this.parts.hashCode();
        }
    }

    private static abstract class AutomatonPrivilege<P extends AutomatonPrivilege<P>>
    extends Privilege<P> {
        protected final Automaton automaton;

        private AutomatonPrivilege(String name, String ... patterns) {
            super(new Name(name));
            this.automaton = Automatons.patterns(patterns);
        }

        private AutomatonPrivilege(Name name, String ... patterns) {
            super(name);
            this.automaton = Automatons.patterns(patterns);
        }

        private AutomatonPrivilege(Name name, Automaton automaton) {
            super(name);
            this.automaton = automaton;
        }

        @Override
        public Predicate<String> predicate() {
            return new AutomatonPredicate(this.automaton);
        }

        protected P plus(P other) {
            if (other.implies((P)this)) {
                return (P)other;
            }
            if (this.implies((P)other)) {
                return (P)this;
            }
            return this.create(this.name.add(other.name), Automatons.unionAndDeterminize(this.automaton, other.automaton));
        }

        protected P minus(P other) {
            if (other.implies((P)this)) {
                return this.none();
            }
            if (other == this.none() || !this.implies((P)other)) {
                return (P)this;
            }
            return this.create(this.name.remove(other.name), Automatons.minusAndDeterminize(this.automaton, other.automaton));
        }

        @Override
        public boolean implies(P other) {
            return BasicOperations.subsetOf((Automaton)((AutomatonPrivilege)other).automaton, (Automaton)this.automaton);
        }

        public String toString() {
            return this.name.toString();
        }

        protected abstract P create(Name var1, Automaton var2);

        protected abstract P none();
    }

    public static class Cluster
    extends AutomatonPrivilege<Cluster> {
        private static final Automaton MANAGE_SECURITY_AUTOMATON = Automatons.patterns("cluster:admin/shield/*", "cluster:admin/xpack/security/*");
        private static final Automaton MANAGE_SHIELD_AUTOMATON = Automatons.patterns("cluster:admin/shield/*");
        private static final Automaton MONITOR_AUTOMATON = Automatons.patterns("cluster:monitor/*");
        private static final Automaton ALL_CLUSTER_AUTOMATON = Automatons.patterns("cluster:*", "indices:admin/template/*");
        private static final Automaton MANAGE_AUTOMATON = Automatons.minusAndDeterminize(ALL_CLUSTER_AUTOMATON, MANAGE_SECURITY_AUTOMATON);
        private static final Automaton TRANSPORT_CLIENT_AUTOMATON = Automatons.patterns("cluster:monitor/nodes/liveness", "cluster:monitor/state");
        private static final Automaton MANAGE_IDX_TEMPLATE_AUTOMATON = Automatons.patterns("indices:admin/template/*");
        public static final Cluster NONE = new Cluster(Name.NONE, Automatons.EMPTY);
        public static final Cluster ALL = new Cluster(Name.ALL, ALL_CLUSTER_AUTOMATON);
        public static final Cluster MONITOR = new Cluster("monitor", MONITOR_AUTOMATON);
        public static final Cluster MANAGE = new Cluster("manage", MANAGE_AUTOMATON);
        public static final Cluster MANAGE_IDX_TEMPLATES = new Cluster("manage_index_templates", MANAGE_IDX_TEMPLATE_AUTOMATON);
        public static final Cluster TRANSPORT_CLIENT = new Cluster("transport_client", TRANSPORT_CLIENT_AUTOMATON);
        public static final Cluster MANAGE_SECURITY = new Cluster("manage_security", MANAGE_SECURITY_AUTOMATON);
        public static final Cluster MANAGE_SHIELD = new Cluster("manage_shield", MANAGE_SHIELD_AUTOMATON);
        static final Predicate<String> ACTION_MATCHER = ALL.predicate();
        private static final Set<Cluster> values = new CopyOnWriteArraySet<Cluster>();
        private static final LoadingCache<Name, Cluster> cache;

        static Set<Cluster> values() {
            return values;
        }

        private Cluster(String name, String ... patterns) {
            super(name, patterns);
        }

        private Cluster(String name, Automaton automaton) {
            super(new Name(name), automaton);
        }

        private Cluster(Name name, String ... patterns) {
            super(name, patterns);
        }

        private Cluster(Name name, Automaton automaton) {
            super(name, automaton);
        }

        public static void addCustom(String name, String ... actionPatterns) {
            for (String pattern : actionPatterns) {
                if (ACTION_MATCHER.apply((Object)pattern)) continue;
                throw new IllegalArgumentException("cannot register custom cluster privilege [" + name + "]. cluster aciton must follow the 'cluster:*' format");
            }
            Cluster custom = new Cluster(name, actionPatterns);
            if (values.contains(custom)) {
                throw new IllegalArgumentException("cannot register custom cluster privilege [" + name + "] as it already exists.");
            }
            values.add(custom);
        }

        @Override
        protected Cluster create(Name name, Automaton automaton) {
            return new Cluster(name, automaton);
        }

        @Override
        protected Cluster none() {
            return NONE;
        }

        public static Cluster action(String action) {
            String pattern = Cluster.actionToPattern(action);
            return new Cluster(action, pattern);
        }

        public static Cluster get(Name name) {
            try {
                return (Cluster)cache.getUnchecked((Object)name);
            }
            catch (UncheckedExecutionException e) {
                throw (RuntimeException)e.getCause();
            }
        }

        private static Cluster resolve(String name) {
            if (ACTION_MATCHER.apply((Object)(name = name.toLowerCase(Locale.ROOT)))) {
                return Cluster.action(name);
            }
            for (Cluster cluster : values) {
                if (!name.equals(cluster.name.toString())) continue;
                return cluster;
            }
            throw new IllegalArgumentException("unknown cluster privilege [" + name + "]. a privilege must be either " + "one of the predefined fixed cluster privileges [" + Strings.collectionToCommaDelimitedString(values) + "] or a pattern over one of the available cluster actions");
        }

        static {
            values.add(NONE);
            values.add(ALL);
            values.add(MONITOR);
            values.add(MANAGE);
            values.add(MANAGE_SHIELD);
            values.add(MANAGE_SECURITY);
            values.add(TRANSPORT_CLIENT);
            values.add(MANAGE_IDX_TEMPLATES);
            cache = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<Name, Cluster>(){

                public Cluster load(Name name) throws Exception {
                    Cluster cluster = NONE;
                    for (String part : name.parts) {
                        cluster = cluster == NONE ? Cluster.resolve(part) : cluster.plus(Cluster.resolve(part));
                    }
                    return cluster;
                }
            });
        }
    }

    public static class Index
    extends AutomatonPrivilege<Index> {
        private static final Automaton ALL_AUTOMATON = Automatons.patterns("indices:*");
        private static final Automaton READ_AUTOMATON = Automatons.patterns("indices:data/read/*");
        private static final Automaton CREATE_AUTOMATON = Automatons.patterns("indices:data/write/index*");
        private static final Automaton INDEX_AUTOMATON = Automatons.patterns("indices:data/write/index*", "indices:data/write/update*");
        private static final Automaton DELETE_AUTOMATON = Automatons.patterns("indices:data/write/delete*");
        private static final Automaton WRITE_AUTOMATON = Automatons.patterns("indices:data/write/*");
        private static final Automaton MONITOR_AUTOMATON = Automatons.patterns("indices:monitor/*");
        private static final Automaton MANAGE_AUTOMATON = Automatons.unionAndDeterminize(MONITOR_AUTOMATON, Automatons.patterns("indices:admin/*"));
        private static final Automaton CREATE_INDEX_AUTOMATON = Automatons.patterns("indices:admin/create");
        private static final Automaton DELETE_INDEX_AUTOMATON = Automatons.patterns("indices:admin/delete");
        private static final Automaton VIEW_METADATA_AUTOMATON = Automatons.patterns("indices:admin/aliases/get", "indices:admin/aliases/exists", "indices:admin/get", "indices:admin/exists", "indices:admin/mappings/fields/get*", "indices:admin/mappings/get", "indices:admin/shards/search_shards", "indices:admin/types/exists", "indices:admin/validate/query*", "indices:admin/warmers/get", "indices:monitor/settings/get");
        public static final Index NONE = new Index(Name.NONE, Automatons.EMPTY);
        public static final Index ALL = new Index(Name.ALL, ALL_AUTOMATON);
        public static final Index READ = new Index("read", READ_AUTOMATON);
        public static final Index CREATE = new Index("create", CREATE_AUTOMATON);
        public static final Index INDEX = new Index("index", INDEX_AUTOMATON);
        public static final Index DELETE = new Index("delete", DELETE_AUTOMATON);
        public static final Index WRITE = new Index("write", WRITE_AUTOMATON);
        public static final Index MONITOR = new Index("monitor", MONITOR_AUTOMATON);
        public static final Index MANAGE = new Index("manage", MANAGE_AUTOMATON);
        public static final Index DELETE_INDEX = new Index("delete_index", DELETE_INDEX_AUTOMATON);
        public static final Index CREATE_INDEX = new Index("create_index", CREATE_INDEX_AUTOMATON);
        public static final Index VIEW_METADATA = new Index("view_index_metadata", VIEW_METADATA_AUTOMATON);
        public static final Index MANAGE_ALIASES = new Index("manage_aliases", "indices:admin/aliases*");
        public static final Index DATA_ACCESS = new Index("data_access", "indices:data/*");
        public static final Index CRUD = new Index("crud", "indices:data/write/*", "indices:data/read/*");
        public static final Index SEARCH = new Index("search", "indices:data/read/search*", "indices:data/read/msearch*", "indices:data/read/suggest*");
        public static final Index GET = new Index("get", "indices:data/read/get*", "indices:data/read/mget*");
        public static final Index SUGGEST = new Index("suggest", "indices:data/read/suggest*");
        private static final Set<Index> values = new CopyOnWriteArraySet<Index>();
        public static final Predicate<String> ACTION_MATCHER;
        public static final Predicate<String> CREATE_INDEX_MATCHER;
        private static final LoadingCache<Name, Index> cache;

        static Set<Index> values() {
            return values;
        }

        private Index(String name, String ... patterns) {
            super(name, patterns);
        }

        private Index(String name, Automaton automaton) {
            super(new Name(name), automaton);
        }

        private Index(Name name, String ... patterns) {
            super(name, patterns);
        }

        private Index(Name name, Automaton automaton) {
            super(name, automaton);
        }

        public static void addCustom(String name, String ... actionPatterns) {
            for (String pattern : actionPatterns) {
                if (ACTION_MATCHER.apply((Object)pattern)) continue;
                throw new IllegalArgumentException("cannot register custom index privilege [" + name + "]. index action must follow the 'indices:*' format");
            }
            Index custom = new Index(name, actionPatterns);
            if (values.contains(custom)) {
                throw new IllegalArgumentException("cannot register custom index privilege [" + name + "] as it already exists.");
            }
            values.add(custom);
        }

        @Override
        protected Index create(Name name, Automaton automaton) {
            if (name == Name.NONE) {
                return NONE;
            }
            return new Index(name, automaton);
        }

        @Override
        protected Index none() {
            return NONE;
        }

        public static Index action(String action) {
            return new Index(action, Index.actionToPattern(action));
        }

        public static Index get(Name name) {
            try {
                return (Index)cache.getUnchecked((Object)name);
            }
            catch (UncheckedExecutionException e) {
                throw (RuntimeException)e.getCause();
            }
        }

        public static Index union(Index ... indices) {
            Index result = NONE;
            for (Index index : indices) {
                result = result.plus(index);
            }
            return result;
        }

        private static Index resolve(String name) {
            if (ACTION_MATCHER.apply((Object)(name = name.toLowerCase(Locale.ROOT)))) {
                return Index.action(name);
            }
            for (Index index : values) {
                if (!name.toLowerCase(Locale.ROOT).equals(index.name.toString())) continue;
                return index;
            }
            throw new IllegalArgumentException("unknown index privilege [" + name + "]. a privilege must be either " + "one of the predefined fixed indices privileges [" + Strings.collectionToCommaDelimitedString(values) + "] or a pattern over one of the available index actions");
        }

        static {
            values.add(NONE);
            values.add(ALL);
            values.add(MANAGE);
            values.add(CREATE);
            values.add(CREATE_INDEX);
            values.add(DELETE_INDEX);
            values.add(MANAGE_ALIASES);
            values.add(MONITOR);
            values.add(DATA_ACCESS);
            values.add(CRUD);
            values.add(READ);
            values.add(SEARCH);
            values.add(GET);
            values.add(SUGGEST);
            values.add(INDEX);
            values.add(DELETE);
            values.add(WRITE);
            values.add(VIEW_METADATA);
            ACTION_MATCHER = ALL.predicate();
            CREATE_INDEX_MATCHER = CREATE_INDEX.predicate();
            cache = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<Name, Index>(){

                public Index load(Name name) throws Exception {
                    Index index = NONE;
                    for (String part : name.parts) {
                        index = index == NONE ? Index.resolve(part) : index.plus(Index.resolve(part));
                    }
                    return index;
                }
            });
        }
    }

    public static class General
    extends AutomatonPrivilege<General> {
        public static final General NONE = new General(Name.NONE, Automatons.EMPTY);

        public General(String name, String ... patterns) {
            super(name, patterns);
        }

        public General(Name name, String ... patterns) {
            super(name, patterns);
        }

        public General(Name name, Automaton automaton) {
            super(name, automaton);
        }

        @Override
        protected General create(Name name, Automaton automaton) {
            return new General(name, automaton);
        }

        @Override
        protected General none() {
            return NONE;
        }
    }

    public static class System
    extends Privilege<System> {
        protected static final Predicate<String> PREDICATE = new AutomatonPredicate(Automatons.patterns("internal:*", "indices:monitor/*", "cluster:monitor/*", "cluster:admin/reroute", "indices:admin/mapping/put"));

        private System() {
            super(new Name("internal"));
        }

        @Override
        public Predicate<String> predicate() {
            return PREDICATE;
        }

        @Override
        public boolean implies(System other) {
            return true;
        }
    }
}

