/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.shield.authc.ldap;

import com.google.common.primitives.Ints;
import com.unboundid.ldap.sdk.Attribute;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPInterface;
import com.unboundid.ldap.sdk.SearchRequest;
import com.unboundid.ldap.sdk.SearchResultEntry;
import com.unboundid.ldap.sdk.SearchScope;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.shield.authc.ldap.support.LdapSession;
import org.elasticsearch.shield.authc.ldap.support.LdapUtils;

class UserAttributeGroupsResolver
implements LdapSession.GroupsResolver {
    private final String attribute;

    public UserAttributeGroupsResolver(Settings settings) {
        this(settings.get("user_group_attribute", "memberOf"));
    }

    public UserAttributeGroupsResolver(String attribute) {
        this.attribute = attribute;
    }

    @Override
    public List<String> resolve(LDAPInterface connection, String userDn, TimeValue timeout, ESLogger logger) {
        try {
            SearchRequest request = new SearchRequest(userDn, SearchScope.BASE, LdapUtils.OBJECT_CLASS_PRESENCE_FILTER, new String[]{this.attribute});
            request.setTimeLimitSeconds(Ints.checkedCast((long)timeout.seconds()));
            SearchResultEntry result = LdapUtils.searchForEntry(connection, request, logger);
            Attribute attributeReturned = result.getAttribute(this.attribute);
            if (attributeReturned == null) {
                return Collections.emptyList();
            }
            String[] values = attributeReturned.getValues();
            return Arrays.asList(values);
        }
        catch (LDAPException e) {
            throw new ElasticsearchException("could not look up group attributes for DN [{}]", (Throwable)e, new Object[]{userDn});
        }
    }
}

