/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.shield.authc.esnative;

import java.util.List;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.env.Environment;
import org.elasticsearch.shield.User;
import org.elasticsearch.shield.authc.Realm;
import org.elasticsearch.shield.authc.RealmConfig;
import org.elasticsearch.shield.authc.esnative.ESNativeUsersStore;
import org.elasticsearch.shield.authc.support.CachingUsernamePasswordRealm;
import org.elasticsearch.shield.authc.support.UsernamePasswordToken;

public class ESNativeRealm
extends CachingUsernamePasswordRealm {
    public static final String TYPE = "native";
    final ESNativeUsersStore userStore;

    public ESNativeRealm(RealmConfig config, ESNativeUsersStore usersStore) {
        super(TYPE, config);
        this.userStore = usersStore;
        usersStore.addListener(new Listener());
    }

    @Override
    public boolean userLookupSupported() {
        return true;
    }

    @Override
    protected User doLookupUser(String username) {
        return this.userStore.getUser(username);
    }

    @Override
    protected User doAuthenticate(UsernamePasswordToken token) {
        return this.userStore.verifyPassword(token.principal(), token.credentials());
    }

    public static class Factory
    extends Realm.Factory<ESNativeRealm> {
        private final Settings settings;
        private final Environment env;
        private final ESNativeUsersStore userStore;

        @Inject
        public Factory(Settings settings, Environment env, ESNativeUsersStore userStore) {
            super(ESNativeRealm.TYPE, true);
            this.settings = settings;
            this.env = env;
            this.userStore = userStore;
        }

        @Override
        public ESNativeRealm create(RealmConfig config) {
            return new ESNativeRealm(config, this.userStore);
        }

        @Override
        public ESNativeRealm createDefault(String name) {
            RealmConfig config = new RealmConfig(name, Settings.EMPTY, this.settings, this.env);
            return this.create(config);
        }
    }

    class Listener
    implements ESNativeUsersStore.ChangeListener {
        Listener() {
        }

        @Override
        public void onUsersChanged(List<String> usernames) {
            for (String username : usernames) {
                ESNativeRealm.this.expire(username);
            }
        }
    }
}

