/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.shield.authc;

import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.shield.ShieldSettingsFilter;
import org.elasticsearch.shield.User;
import org.elasticsearch.shield.authc.AuthenticationToken;
import org.elasticsearch.shield.authc.RealmConfig;
import org.elasticsearch.transport.TransportMessage;

public abstract class Realm<T extends AuthenticationToken>
implements Comparable<Realm> {
    protected final ESLogger logger;
    protected final String type;
    protected RealmConfig config;

    public Realm(String type, RealmConfig config) {
        this.type = type;
        this.config = config;
        this.logger = config.logger(this.getClass());
    }

    public String type() {
        return this.type;
    }

    public String name() {
        return this.config.name;
    }

    public int order() {
        return this.config.order;
    }

    @Override
    public int compareTo(Realm other) {
        return Integer.compare(this.config.order, other.config.order);
    }

    public abstract boolean supports(AuthenticationToken var1);

    public abstract T token(RestRequest var1);

    public abstract T token(TransportMessage<?> var1);

    public abstract User authenticate(T var1);

    public abstract User lookupUser(String var1);

    public abstract boolean userLookupSupported();

    public String toString() {
        return this.type + "/" + this.config.name;
    }

    public static abstract class Factory<R extends Realm> {
        private final String type;
        private final boolean internal;

        public Factory(String type, boolean internal) {
            this.type = type;
            this.internal = internal;
        }

        public String type() {
            return this.type;
        }

        public boolean internal() {
            return this.internal;
        }

        public void filterOutSensitiveSettings(String realmName, ShieldSettingsFilter filter) {
        }

        public abstract R create(RealmConfig var1);

        public abstract R createDefault(String var1);
    }
}

