/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.shield.action.role;

import java.io.IOException;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.support.master.MasterNodeRequest;
import org.elasticsearch.action.support.nodes.BaseNodeRequest;
import org.elasticsearch.action.support.nodes.BaseNodesRequest;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

public class ClearRolesCacheRequest
extends MasterNodeRequest<ClearRolesCacheRequest> {
    String[] roles;

    public ClearRolesCacheRequest roles(String ... roles) {
        this.roles = roles;
        return this;
    }

    public String[] roles() {
        return this.roles;
    }

    public ActionRequestValidationException validate() {
        return null;
    }

    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.roles = in.readBoolean() ? in.readStringArray() : null;
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        if (this.roles != null) {
            out.writeBoolean(true);
            out.writeStringArray(this.roles);
        } else {
            out.writeBoolean(false);
        }
    }

    public static class Node
    extends BaseNodeRequest {
        private String[] roles;

        public Node() {
        }

        public Node(ClearRolesCacheRequest request, String nodeId) {
            super(new BaseNodesRequest((ActionRequest)request, new String[0]){}, nodeId);
            this.roles = request.roles();
        }

        public String[] roles() {
            return this.roles;
        }

        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            this.roles = in.readBoolean() ? in.readStringArray() : null;
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            if (this.roles != null) {
                out.writeBoolean(true);
                out.writeStringArray(this.roles);
            } else {
                out.writeBoolean(false);
            }
        }
    }
}

