/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.shield.action.interceptor;

import java.io.IOException;
import java.util.Map;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.action.percolate.PercolateRequest;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.index.query.MatchAllQueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.shield.action.interceptor.FieldAndDocumentLevelSecurityRequestInterceptor;
import org.elasticsearch.transport.TransportRequest;

public class PercolateRequestInterceptor
extends FieldAndDocumentLevelSecurityRequestInterceptor<PercolateRequest> {
    @Inject
    public PercolateRequestInterceptor(Settings settings) {
        super(settings);
    }

    @Override
    protected void disableFeatures(PercolateRequest request) {
        BytesReference source = request.source();
        try {
            Tuple result = XContentHelper.convertToMap((BytesReference)source, (boolean)true);
            Map sourceMap = (Map)result.v2();
            if (sourceMap.containsKey("query") || sourceMap.containsKey("filter")) {
                return;
            }
            MatchAllQueryBuilder builder = QueryBuilders.matchAllQuery();
            XContentBuilder xContentBuilder = XContentFactory.contentBuilder((XContentType)((XContentType)result.v1()));
            builder.toXContent(xContentBuilder, ToXContent.EMPTY_PARAMS);
            BytesReference queryBytes = builder.buildAsBytes();
            Map queryMap = XContentFactory.xContent((BytesReference)queryBytes).createParser(queryBytes).map();
            sourceMap.put("query", queryMap);
            xContentBuilder = XContentBuilder.builder((XContent)((XContentType)result.v1()).xContent()).map(sourceMap);
            request.source(xContentBuilder.bytes());
        }
        catch (IOException e) {
            throw new ElasticsearchParseException("failed to parse percolate request", (Throwable)e, new Object[0]);
        }
    }

    @Override
    public boolean supports(TransportRequest request) {
        return request instanceof PercolateRequest;
    }
}

