/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.shield.action.interceptor;

import org.elasticsearch.ElasticsearchSecurityException;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.shield.User;
import org.elasticsearch.shield.action.interceptor.RequestInterceptor;
import org.elasticsearch.shield.authz.accesscontrol.IndicesAccessControl;
import org.elasticsearch.transport.TransportRequest;

public class BulkRequestInterceptor
extends AbstractComponent
implements RequestInterceptor<BulkRequest> {
    @Inject
    public BulkRequestInterceptor(Settings settings) {
        super(settings);
    }

    @Override
    public void intercept(BulkRequest request, User user) {
        IndicesAccessControl indicesAccessControl = (IndicesAccessControl)request.getFromContext((Object)"_indices_permissions");
        for (IndicesRequest indicesRequest : request.subRequests()) {
            for (String index : indicesRequest.indices()) {
                IndicesAccessControl.IndexAccessControl indexAccessControl = indicesAccessControl.getIndexPermissions(index);
                if (indexAccessControl != null) {
                    boolean dls;
                    boolean fls = indexAccessControl.getFields() != null;
                    boolean bl = dls = indexAccessControl.getQueries() != null;
                    if (fls || dls) {
                        this.logger.debug("intercepted request for index [{}] with field level or document level security enabled, disabling features", new Object[]{index});
                        if (indicesRequest instanceof UpdateRequest) {
                            throw new ElasticsearchSecurityException("Can't execute an bulk request with update requests embedded if field or document level security is enabled", RestStatus.BAD_REQUEST, new Object[0]);
                        }
                    }
                }
                this.logger.trace("intercepted request for index [{}] with neither field level or document level security not enabled, doing nothing", new Object[]{index});
            }
        }
    }

    @Override
    public boolean supports(TransportRequest request) {
        return request instanceof BulkRequest;
    }
}

