/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.shield;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.atomic.AtomicBoolean;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.admin.indices.template.put.PutIndexTemplateRequest;
import org.elasticsearch.action.admin.indices.template.put.PutIndexTemplateResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateListener;
import org.elasticsearch.cluster.metadata.IndexTemplateMetaData;
import org.elasticsearch.cluster.routing.IndexRoutingTable;
import org.elasticsearch.common.ContextAndHeaderHolder;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.Provider;
import org.elasticsearch.common.io.Streams;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.AbstractRunnable;
import org.elasticsearch.gateway.GatewayService;
import org.elasticsearch.shield.InternalShieldUser;
import org.elasticsearch.shield.authc.AuthenticationService;
import org.elasticsearch.threadpool.ThreadPool;

public class ShieldTemplateService
extends AbstractComponent
implements ClusterStateListener {
    public static final String SECURITY_INDEX_NAME = ".security";
    public static final String SECURITY_TEMPLATE_NAME = "security-index-template";
    private final ThreadPool threadPool;
    private final Provider<Client> clientProvider;
    private final Provider<AuthenticationService> authProvider;
    private final AtomicBoolean templateCreationPending = new AtomicBoolean(false);

    @Inject
    public ShieldTemplateService(Settings settings, ClusterService clusterService, Provider<Client> clientProvider, ThreadPool threadPool, Provider<AuthenticationService> authProvider) {
        super(settings);
        this.threadPool = threadPool;
        this.clientProvider = clientProvider;
        this.authProvider = authProvider;
        clusterService.add((ClusterStateListener)this);
    }

    private void createShieldTemplate() {
        Client client = (Client)this.clientProvider.get();
        try (InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream("/security-index-template.json");){
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            Streams.copy((InputStream)is, (OutputStream)out);
            byte[] template = out.toByteArray();
            this.logger.info("adding the security index template", new Object[0]);
            PutIndexTemplateRequest putTemplateRequest = (PutIndexTemplateRequest)client.admin().indices().preparePutTemplate(SECURITY_TEMPLATE_NAME).setSource(template).request();
            ((AuthenticationService)this.authProvider.get()).attachUserHeaderIfMissing((ContextAndHeaderHolder)putTemplateRequest, InternalShieldUser.INSTANCE);
            PutIndexTemplateResponse templateResponse = (PutIndexTemplateResponse)client.admin().indices().putTemplate(putTemplateRequest).get();
            if (!templateResponse.isAcknowledged()) {
                throw new ElasticsearchException("adding template for shield admin index was not acknowledged", new Object[0]);
            }
        }
        catch (Exception e) {
            this.logger.error("failed to create shield admin index template [{}]", (Throwable)e, new Object[]{SECURITY_INDEX_NAME});
            throw new IllegalStateException("failed to create shield admin index template [.security]", e);
        }
    }

    public void clusterChanged(ClusterChangedEvent event) {
        if (event.state().blocks().hasGlobalBlock(GatewayService.STATE_NOT_RECOVERED_BLOCK)) {
            this.logger.debug("template service waiting until state has been recovered", new Object[0]);
            return;
        }
        IndexRoutingTable shieldIndexRouting = event.state().routingTable().index(SECURITY_INDEX_NAME);
        if (shieldIndexRouting == null && event.localNodeMaster()) {
            boolean createTemplate;
            ClusterState state = event.state();
            IndexTemplateMetaData templateMeta = (IndexTemplateMetaData)state.metaData().templates().get((Object)SECURITY_TEMPLATE_NAME);
            boolean bl = createTemplate = templateMeta == null;
            if (createTemplate && this.templateCreationPending.compareAndSet(false, true)) {
                this.threadPool.generic().execute((Runnable)new AbstractRunnable(){

                    public void onFailure(Throwable t) {
                        ShieldTemplateService.this.logger.warn("failed to create shield admin template", t, new Object[0]);
                        ShieldTemplateService.this.templateCreationPending.set(false);
                    }

                    protected void doRun() throws Exception {
                        if (createTemplate) {
                            ShieldTemplateService.this.createShieldTemplate();
                        }
                        ShieldTemplateService.this.templateCreationPending.set(false);
                    }
                });
            }
        }
    }
}

