/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.language.java.plugins;

import com.google.common.collect.ImmutableList;
import java.io.File;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.ResolveContext;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.dsl.RepositoryHandler;
import org.gradle.api.artifacts.repositories.ArtifactRepository;
import org.gradle.api.artifacts.result.DependencyResult;
import org.gradle.api.artifacts.result.ResolutionResult;
import org.gradle.api.artifacts.result.ResolvedComponentResult;
import org.gradle.api.artifacts.result.ResolvedDependencyResult;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.internal.artifacts.ArtifactDependencyResolver;
import org.gradle.api.internal.artifacts.GlobalDependencyResolutionRules;
import org.gradle.api.internal.artifacts.ResolverResults;
import org.gradle.api.internal.artifacts.ivyservice.LocalComponentFactory;
import org.gradle.api.internal.artifacts.ivyservice.moduleconverter.CompositeResolveLocalComponentFactory;
import org.gradle.api.internal.artifacts.repositories.ResolutionAwareRepository;
import org.gradle.api.internal.file.AbstractFileCollection;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.jvm.JvmBinarySpec;
import org.gradle.jvm.JvmByteCode;
import org.gradle.language.base.LanguageSourceSet;
import org.gradle.language.base.internal.SourceTransformTaskConfig;
import org.gradle.language.base.internal.registry.LanguageTransform;
import org.gradle.language.base.internal.registry.LanguageTransformContainer;
import org.gradle.language.base.plugins.ComponentModelBasePlugin;
import org.gradle.language.java.JavaSourceSet;
import org.gradle.language.java.internal.DefaultJavaLanguageSourceSet;
import org.gradle.language.java.internal.DefaultJavaLocalComponentFactory;
import org.gradle.language.java.internal.DefaultJavaSourceSetResolveContext;
import org.gradle.language.java.tasks.PlatformJavaCompile;
import org.gradle.language.jvm.plugins.JvmResourcesPlugin;
import org.gradle.model.Mutate;
import org.gradle.model.RuleSource;
import org.gradle.platform.base.BinarySpec;
import org.gradle.platform.base.LanguageType;
import org.gradle.platform.base.LanguageTypeBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaLanguagePlugin
implements Plugin<Project> {
    public void apply(Project project) {
        project.getPluginManager().apply(ComponentModelBasePlugin.class);
        project.getPluginManager().apply(JvmResourcesPlugin.class);
        GradleInternal gradle = (GradleInternal)project.getGradle();
        this.registerLocalComponentFactory(gradle);
    }

    private void registerLocalComponentFactory(GradleInternal gradle) {
        ServiceRegistry services = gradle.getServices();
        CompositeResolveLocalComponentFactory componentFactory = (CompositeResolveLocalComponentFactory)services.get(CompositeResolveLocalComponentFactory.class);
        componentFactory.addFactory((LocalComponentFactory)new DefaultJavaLocalComponentFactory());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DependencyResolvingClasspath
    extends AbstractFileCollection {
        private final Project project;
        private final JavaSourceSet sourceSet;
        private final ArtifactDependencyResolver dependencyResolver;
        private final GlobalDependencyResolutionRules globalDependencyResolutionRules;
        private final RepositoryHandler repositories;

        private DependencyResolvingClasspath(Project project, JavaSourceSet sourceSet, ArtifactDependencyResolver dependencyResolver, RepositoryHandler repositories, GlobalDependencyResolutionRules globalDependencyResolutionRules) {
            this.project = project;
            this.sourceSet = sourceSet;
            this.dependencyResolver = dependencyResolver;
            this.repositories = repositories;
            this.globalDependencyResolutionRules = globalDependencyResolutionRules;
        }

        public String getDisplayName() {
            return "Classpath for " + this.sourceSet.getDisplayName();
        }

        public Set<File> getFiles() {
            LinkedHashSet<File> classpath = new LinkedHashSet<File>();
            classpath.addAll(this.sourceSet.getCompileClasspath().getFiles().getFiles());
            ResolverResults results = new ResolverResults();
            List<ResolutionAwareRepository> resolutionRepositories = this.getResolutionAwareRepositories();
            DefaultJavaSourceSetResolveContext resolveContext = new DefaultJavaSourceSetResolveContext(this.project, (DefaultJavaLanguageSourceSet)this.sourceSet);
            this.dependencyResolver.resolve((ResolveContext)resolveContext, resolutionRepositories, this.globalDependencyResolutionRules, results);
            ResolutionResult resolutionResult = results.getResolutionResult();
            resolutionResult.allDependencies((Action)new Action<DependencyResult>(){

                public void execute(DependencyResult dependencyResult) {
                    if (dependencyResult instanceof ResolvedDependencyResult) {
                        ResolvedDependencyResult resolved = (ResolvedDependencyResult)dependencyResult;
                        ResolvedComponentResult selected = resolved.getSelected();
                        ComponentIdentifier id = selected.getId();
                    }
                }
            });
            return classpath;
        }

        private List<ResolutionAwareRepository> getResolutionAwareRepositories() {
            ImmutableList artifactRepositories = ImmutableList.copyOf((Iterator)this.repositories.iterator());
            LinkedList<ResolutionAwareRepository> resolutionRepositories = new LinkedList<ResolutionAwareRepository>();
            for (ArtifactRepository artifactRepository : artifactRepositories) {
                if (!(artifactRepository instanceof ResolutionAwareRepository)) continue;
                resolutionRepositories.add((ResolutionAwareRepository)artifactRepository);
            }
            return resolutionRepositories;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Java
    implements LanguageTransform<JavaSourceSet, JvmByteCode> {
        private Java() {
        }

        public Class<JavaSourceSet> getSourceSetType() {
            return JavaSourceSet.class;
        }

        public Map<String, Class<?>> getBinaryTools() {
            return Collections.emptyMap();
        }

        public Class<JvmByteCode> getOutputType() {
            return JvmByteCode.class;
        }

        public SourceTransformTaskConfig getTransformTask() {
            return new SourceTransformTaskConfig(){

                public String getTaskPrefix() {
                    return "compile";
                }

                public Class<? extends DefaultTask> getTaskType() {
                    return PlatformJavaCompile.class;
                }

                public void configureTask(Task task, BinarySpec binarySpec, LanguageSourceSet sourceSet) {
                    PlatformJavaCompile compile = (PlatformJavaCompile)task;
                    JavaSourceSet javaSourceSet = (JavaSourceSet)sourceSet;
                    JvmBinarySpec binary = (JvmBinarySpec)binarySpec;
                    GradleInternal gradle = (GradleInternal)task.getProject().getGradle();
                    ArtifactDependencyResolver dependencyResolver = (ArtifactDependencyResolver)gradle.getServices().get(ArtifactDependencyResolver.class);
                    ProjectInternal project = (ProjectInternal)task.getProject();
                    RepositoryHandler repositories = project.getRepositories();
                    GlobalDependencyResolutionRules globalDependencyResolutionRules = (GlobalDependencyResolutionRules)project.getServices().get(GlobalDependencyResolutionRules.class);
                    compile.setDescription(String.format("Compiles %s.", javaSourceSet));
                    compile.setDestinationDir(binary.getClassesDir());
                    compile.setPlatform(binary.getTargetPlatform());
                    compile.setSource(javaSourceSet.getSource());
                    compile.setClasspath((FileCollection)new DependencyResolvingClasspath((Project)project, javaSourceSet, dependencyResolver, repositories, globalDependencyResolutionRules));
                    compile.setTargetCompatibility(binary.getTargetPlatform().getTargetCompatibility().toString());
                    compile.setSourceCompatibility(binary.getTargetPlatform().getTargetCompatibility().toString());
                    compile.setDependencyCacheDir(new File(compile.getProject().getBuildDir(), "jvm-dep-cache"));
                    compile.dependsOn(new Object[]{javaSourceSet});
                    binary.getTasks().getJar().dependsOn(new Object[]{compile});
                }
            };
        }

        public boolean applyToBinary(BinarySpec binary) {
            return binary instanceof JvmBinarySpec;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Rules
    extends RuleSource {
        Rules() {
        }

        @LanguageType
        void registerLanguage(LanguageTypeBuilder<JavaSourceSet> builder) {
            builder.setLanguageName("java");
            builder.defaultImplementation(DefaultJavaLanguageSourceSet.class);
        }

        @Mutate
        void registerLanguageTransform(LanguageTransformContainer languages, ServiceRegistry serviceRegistry) {
            languages.add((Object)new Java());
        }
    }
}

