/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.language.java.internal;

import java.util.Collections;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ComponentSelector;
import org.gradle.api.artifacts.component.LibraryComponentSelector;
import org.gradle.api.internal.artifacts.DefaultModuleVersionIdentifier;
import org.gradle.api.internal.artifacts.ivyservice.LocalComponentFactory;
import org.gradle.api.internal.artifacts.ivyservice.projectmodule.ProjectComponentRegistry;
import org.gradle.api.internal.artifacts.ivyservice.projectmodule.ProjectDependencyResolver;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.internal.component.local.model.DefaultLibraryComponentIdentifier;
import org.gradle.internal.component.local.model.DefaultLocalComponentMetaData;
import org.gradle.internal.component.model.DependencyMetaData;
import org.gradle.internal.resolve.ModuleVersionResolveException;
import org.gradle.internal.resolve.resolver.ComponentMetaDataResolver;
import org.gradle.internal.resolve.resolver.DependencyToComponentIdResolver;
import org.gradle.internal.resolve.result.BuildableComponentIdResolveResult;
import org.gradle.model.ModelMap;
import org.gradle.model.internal.core.ModelPath;
import org.gradle.model.internal.type.ModelType;
import org.gradle.platform.base.ComponentSpecContainer;
import org.gradle.platform.base.LibrarySpec;

public class ProjectLibraryDependencyResolver
extends ProjectDependencyResolver {
    private final ProjectInternal defaultProject;

    public ProjectLibraryDependencyResolver(ProjectInternal project, ProjectComponentRegistry projectComponentRegistry, LocalComponentFactory localComponentFactory, DependencyToComponentIdResolver delegateIdResolver, ComponentMetaDataResolver delegateComponentResolver) {
        super(projectComponentRegistry, localComponentFactory, delegateIdResolver, delegateComponentResolver);
        this.defaultProject = project;
    }

    public void resolve(DependencyMetaData dependency, BuildableComponentIdResolveResult result) {
        if (dependency.getSelector() instanceof LibraryComponentSelector) {
            DefaultLocalComponentMetaData metaData = null;
            LibraryComponentSelector selector = (LibraryComponentSelector)dependency.getSelector();
            ProjectInternal project = this.defaultProject;
            if (selector.getProjectPath() != null) {
                project = project.getRootProject().findProject(selector.getProjectPath());
            }
            if (project != null) {
                ComponentSpecContainer components = (ComponentSpecContainer)project.getModelRegistry().realize(ModelPath.path((String)"components"), ModelType.of(ComponentSpecContainer.class));
                ModelMap libraries = components.withType(LibrarySpec.class);
                String libraryName = selector.getLibraryName();
                if (libraryName == null && libraries.size() == 1) {
                    libraryName = ((LibrarySpec)libraries.values().iterator().next()).getName();
                }
                if (libraryName != null) {
                    String version = project.getVersion().toString();
                    String projectPath = project.getPath();
                    LibrarySpec library = (LibrarySpec)libraries.get(libraryName);
                    if (library != null) {
                        DefaultModuleVersionIdentifier id = new DefaultModuleVersionIdentifier(projectPath, libraryName, version);
                        DefaultLibraryComponentIdentifier component = new DefaultLibraryComponentIdentifier(projectPath, library.getName());
                        metaData = new DefaultLocalComponentMetaData((ModuleVersionIdentifier)id, (ComponentIdentifier)component, "release");
                        metaData.addConfiguration(DefaultLibraryComponentIdentifier.libraryToConfigurationName((String)projectPath, (String)libraryName), "Configuration for " + libraryName, Collections.emptySet(), Collections.singleton(DefaultLibraryComponentIdentifier.libraryToConfigurationName((String)projectPath, (String)libraryName)), true, true);
                    }
                }
            }
            if (metaData != null) {
                result.resolved(metaData.toResolveMetaData());
            } else {
                result.failed(new ModuleVersionResolveException((ComponentSelector)selector, String.format("Cannot resolve dependency %s", selector)));
            }
        } else {
            super.resolve(dependency, result);
        }
    }
}

