/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.tasks.javadoc;

import groovy.lang.Closure;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.inject.Inject;
import org.gradle.api.Incubating;
import org.gradle.api.file.FileCollection;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.ParallelizableTask;
import org.gradle.api.tasks.SourceTask;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.javadoc.internal.JavadocSpec;
import org.gradle.external.javadoc.MinimalJavadocOptions;
import org.gradle.external.javadoc.StandardJavadocDocletOptions;
import org.gradle.jvm.internal.toolchain.JavaToolChainInternal;
import org.gradle.jvm.toolchain.JavaToolChain;
import org.gradle.language.base.internal.compile.CompileSpec;
import org.gradle.language.base.internal.compile.Compiler;
import org.gradle.util.GUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ParallelizableTask
public class Javadoc
extends SourceTask {
    private File destinationDir;
    private boolean failOnError = true;
    private String title;
    private String maxMemory;
    private MinimalJavadocOptions options = new StandardJavadocDocletOptions();
    private FileCollection classpath = this.getProject().files(new Object[0]);
    private String executable;

    @TaskAction
    protected void generate() {
        StandardJavadocDocletOptions docletOptions;
        File destinationDir = this.getDestinationDir();
        if (this.options.getDestinationDirectory() == null) {
            this.options.destinationDirectory(destinationDir);
        }
        this.options.classpath(new ArrayList<File>(this.getClasspath().getFiles()));
        if (!GUtil.isTrue((Object)this.options.getWindowTitle()) && GUtil.isTrue((Object)this.getTitle())) {
            this.options.windowTitle(this.getTitle());
        }
        if (this.options instanceof StandardJavadocDocletOptions && !GUtil.isTrue((Object)(docletOptions = (StandardJavadocDocletOptions)this.options).getDocTitle()) && GUtil.isTrue((Object)this.getTitle())) {
            docletOptions.setDocTitle(this.getTitle());
        }
        if (this.maxMemory != null) {
            List<String> jFlags = this.options.getJFlags();
            Iterator<String> jFlagsIt = jFlags.iterator();
            boolean containsXmx = false;
            while (!containsXmx && jFlagsIt.hasNext()) {
                String jFlag = jFlagsIt.next();
                if (!jFlag.startsWith("-Xmx")) continue;
                containsXmx = true;
            }
            if (!containsXmx) {
                this.options.jFlags("-Xmx" + this.maxMemory);
            }
        }
        ArrayList<String> sourceNames = new ArrayList<String>();
        for (File sourceFile : this.getSource()) {
            sourceNames.add(sourceFile.getAbsolutePath());
        }
        this.options.setSourceNames(sourceNames);
        this.executeExternalJavadoc();
    }

    private void executeExternalJavadoc() {
        JavadocSpec spec = new JavadocSpec();
        spec.setExecutable(this.executable);
        spec.setOptions(this.options);
        spec.setIgnoreFailures(!this.failOnError);
        spec.setWorkingDir(this.getProject().getProjectDir());
        spec.setOptionsFile(this.getOptionsFile());
        Compiler generator = ((JavaToolChainInternal)this.getToolChain()).select(null).newCompiler((CompileSpec)spec);
        generator.execute((CompileSpec)spec);
    }

    @Incubating
    @Inject
    public JavaToolChain getToolChain() {
        throw new UnsupportedOperationException();
    }

    @Incubating
    public void setToolChain(JavaToolChain toolChain) {
        throw new UnsupportedOperationException();
    }

    @OutputDirectory
    public File getDestinationDir() {
        return this.destinationDir;
    }

    public void setDestinationDir(File destinationDir) {
        this.destinationDir = destinationDir;
    }

    public String getMaxMemory() {
        return this.maxMemory;
    }

    public void setMaxMemory(String maxMemory) {
        this.maxMemory = maxMemory;
    }

    @Input
    @Optional
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public boolean isVerbose() {
        return this.options.isVerbose();
    }

    public void setVerbose(boolean verbose) {
        if (verbose) {
            this.options.verbose();
        }
    }

    @InputFiles
    public FileCollection getClasspath() {
        return this.classpath;
    }

    public void setClasspath(FileCollection classpath) {
        this.classpath = classpath;
    }

    @Nested
    public MinimalJavadocOptions getOptions() {
        return this.options;
    }

    public void setOptions(MinimalJavadocOptions options) {
        this.options = options;
    }

    public void options(Closure<?> block) {
        this.getProject().configure((Object)this.getOptions(), block);
    }

    @Input
    public boolean isFailOnError() {
        return this.failOnError;
    }

    public void setFailOnError(boolean failOnError) {
        this.failOnError = failOnError;
    }

    public File getOptionsFile() {
        return new File(this.getTemporaryDir(), "javadoc.options");
    }

    @Input
    @Optional
    public String getExecutable() {
        return this.executable;
    }

    public void setExecutable(String executable) {
        this.executable = executable;
    }
}

