/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.watcher.watch;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.watcher.actions.ActionStatus;
import org.elasticsearch.xpack.core.watcher.actions.ActionWrapper;
import org.elasticsearch.xpack.core.watcher.condition.ExecutableCondition;
import org.elasticsearch.xpack.core.watcher.input.ExecutableInput;
import org.elasticsearch.xpack.core.watcher.transform.ExecutableTransform;
import org.elasticsearch.xpack.core.watcher.trigger.Trigger;
import org.elasticsearch.xpack.core.watcher.watch.WatchField;
import org.elasticsearch.xpack.core.watcher.watch.WatchStatus;
import org.joda.time.DateTime;

public class Watch
implements ToXContentObject {
    public static final String INCLUDE_STATUS_KEY = "include_status";
    public static final String INDEX = ".watches";
    public static final String DOC_TYPE = "doc";
    private final String id;
    private final Trigger trigger;
    private final ExecutableInput input;
    private final ExecutableCondition condition;
    @Nullable
    private final ExecutableTransform transform;
    private final List<ActionWrapper> actions;
    @Nullable
    private final TimeValue throttlePeriod;
    @Nullable
    private final Map<String, Object> metadata;
    private final WatchStatus status;
    private transient long version = -3L;

    public Watch(String id, Trigger trigger, ExecutableInput input, ExecutableCondition condition, @Nullable ExecutableTransform transform, @Nullable TimeValue throttlePeriod, List<ActionWrapper> actions, @Nullable Map<String, Object> metadata, WatchStatus status) {
        this.id = id;
        this.trigger = trigger;
        this.input = input;
        this.condition = condition;
        this.transform = transform;
        this.actions = actions;
        this.throttlePeriod = throttlePeriod;
        this.metadata = metadata;
        this.status = status;
    }

    public String id() {
        return this.id;
    }

    public Trigger trigger() {
        return this.trigger;
    }

    public ExecutableInput input() {
        return this.input;
    }

    public ExecutableCondition condition() {
        return this.condition;
    }

    public ExecutableTransform transform() {
        return this.transform;
    }

    public TimeValue throttlePeriod() {
        return this.throttlePeriod;
    }

    public List<ActionWrapper> actions() {
        return this.actions;
    }

    public Map<String, Object> metadata() {
        return this.metadata;
    }

    public WatchStatus status() {
        return this.status;
    }

    public long version() {
        return this.version;
    }

    public void version(long version) {
        this.version = version;
    }

    public boolean setState(boolean active, DateTime now) {
        return this.status.setActive(active, now);
    }

    public boolean ack(DateTime now, String ... actions) {
        return this.status.onAck(now, actions);
    }

    public boolean acked(String actionId) {
        ActionStatus actionStatus = this.status.actionStatus(actionId);
        return actionStatus.ackStatus().state() == ActionStatus.AckStatus.State.ACKED;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Watch watch = (Watch)o;
        return watch.id.equals(this.id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(WatchField.TRIGGER.getPreferredName()).startObject().field(this.trigger.type(), (ToXContent)this.trigger, params).endObject();
        builder.field(WatchField.INPUT.getPreferredName()).startObject().field(this.input.type(), (ToXContent)this.input, params).endObject();
        builder.field(WatchField.CONDITION.getPreferredName()).startObject().field(this.condition.type(), (ToXContent)this.condition, params).endObject();
        if (this.transform != null) {
            builder.field(WatchField.TRANSFORM.getPreferredName()).startObject().field(this.transform.type(), (ToXContent)this.transform, params).endObject();
        }
        if (this.throttlePeriod != null) {
            builder.timeValueField(WatchField.THROTTLE_PERIOD.getPreferredName(), WatchField.THROTTLE_PERIOD_HUMAN.getPreferredName(), this.throttlePeriod);
        }
        builder.startObject(WatchField.ACTIONS.getPreferredName());
        for (ActionWrapper action : this.actions) {
            builder.field(action.id(), (ToXContent)action, params);
        }
        builder.endObject();
        if (this.metadata != null) {
            builder.field(WatchField.METADATA.getPreferredName(), this.metadata);
        }
        if (params.paramAsBoolean(INCLUDE_STATUS_KEY, false)) {
            builder.field(WatchField.STATUS.getPreferredName(), (ToXContent)this.status, params);
        }
        builder.endObject();
        return builder;
    }
}

