/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ssl;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.SocketException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509ExtendedKeyManager;
import javax.net.ssl.X509ExtendedTrustManager;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.DERUTF8String;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.AuthorityKeyIdentifier;
import org.bouncycastle.asn1.x509.BasicConstraints;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.ExtensionsGenerator;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.asn1.x509.Time;
import org.bouncycastle.cert.CertIOException;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.cert.jcajce.JcaX509ExtensionUtils;
import org.bouncycastle.cert.jcajce.JcaX509v3CertificateBuilder;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openssl.PEMEncryptedKeyPair;
import org.bouncycastle.openssl.PEMKeyPair;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.X509TrustedCertificateBlock;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;
import org.bouncycastle.openssl.jcajce.JcePEMDecryptorProviderBuilder;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.bouncycastle.pkcs.PKCS10CertificationRequest;
import org.bouncycastle.pkcs.jcajce.JcaPKCS10CertificationRequestBuilder;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.SuppressForbidden;
import org.elasticsearch.common.io.PathUtils;
import org.elasticsearch.common.network.InetAddressHelper;
import org.elasticsearch.common.network.NetworkAddress;
import org.elasticsearch.common.settings.SecureString;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.env.Environment;
import org.elasticsearch.xpack.core.ssl.KeyConfig;
import org.elasticsearch.xpack.core.ssl.PEMKeyConfig;
import org.elasticsearch.xpack.core.ssl.SSLConfigurationSettings;
import org.elasticsearch.xpack.core.ssl.StoreKeyConfig;
import org.elasticsearch.xpack.core.ssl.X509KeyPairSettings;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

public class CertUtils {
    static final String CN_OID = "2.5.4.3";
    private static final int SERIAL_BIT_LENGTH = 160;
    static final BouncyCastleProvider BC_PROV = new BouncyCastleProvider();

    private CertUtils() {
    }

    @SuppressForbidden(reason="we don't have the environment to resolve files from when running in a transport client")
    static Path resolvePath(String path, @Nullable Environment environment) {
        if (environment != null) {
            return environment.configFile().resolve(path);
        }
        return PathUtils.get((String)path, (String[])new String[0]).normalize();
    }

    static KeyStore getKeyStoreFromPEM(Path certificatePath, Path keyPath, char[] keyPassword) throws IOException, CertificateException, KeyStoreException, NoSuchAlgorithmException {
        PrivateKey key;
        try (BufferedReader reader = Files.newBufferedReader(keyPath, StandardCharsets.UTF_8);){
            key = CertUtils.readPrivateKey(reader, () -> keyPassword);
        }
        Certificate[] certificates = CertUtils.readCertificates(Collections.singletonList(certificatePath));
        return CertUtils.getKeyStore(certificates, key, keyPassword);
    }

    public static X509ExtendedKeyManager keyManager(Certificate[] certificateChain, PrivateKey privateKey, char[] password) throws NoSuchAlgorithmException, UnrecoverableKeyException, KeyStoreException, IOException, CertificateException {
        KeyStore keyStore = CertUtils.getKeyStore(certificateChain, privateKey, password);
        return CertUtils.keyManager(keyStore, password, KeyManagerFactory.getDefaultAlgorithm());
    }

    private static KeyStore getKeyStore(Certificate[] certificateChain, PrivateKey privateKey, char[] password) throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException {
        KeyStore keyStore = KeyStore.getInstance("jks");
        keyStore.load(null, null);
        keyStore.setKeyEntry("key", privateKey, password, certificateChain);
        return keyStore;
    }

    static X509ExtendedKeyManager keyManager(KeyStore keyStore, char[] password, String algorithm) throws NoSuchAlgorithmException, UnrecoverableKeyException, KeyStoreException {
        KeyManager[] keyManagers;
        KeyManagerFactory kmf = KeyManagerFactory.getInstance(algorithm);
        kmf.init(keyStore, password);
        for (KeyManager keyManager : keyManagers = kmf.getKeyManagers()) {
            if (!(keyManager instanceof X509ExtendedKeyManager)) continue;
            return (X509ExtendedKeyManager)keyManager;
        }
        throw new IllegalStateException("failed to find a X509ExtendedKeyManager");
    }

    public static X509ExtendedKeyManager getKeyManager(X509KeyPairSettings keyPair, Settings settings, @Nullable String trustStoreAlgorithm, Environment environment) {
        KeyConfig keyConfig;
        if (trustStoreAlgorithm == null) {
            trustStoreAlgorithm = TrustManagerFactory.getDefaultAlgorithm();
        }
        if ((keyConfig = CertUtils.createKeyConfig(keyPair, settings, trustStoreAlgorithm)) == null) {
            return null;
        }
        return keyConfig.createKeyManager(environment);
    }

    static KeyConfig createKeyConfig(X509KeyPairSettings keyPair, Settings settings, String trustStoreAlgorithm) {
        String keyPath = ((Optional)keyPair.keyPath.get(settings)).orElse(null);
        String keyStorePath = ((Optional)keyPair.keystorePath.get(settings)).orElse(null);
        if (keyPath != null && keyStorePath != null) {
            throw new IllegalArgumentException("you cannot specify a keystore and key file");
        }
        if (keyPath != null) {
            SecureString keyPassword = (SecureString)keyPair.keyPassword.get(settings);
            String certPath = ((Optional)keyPair.certificatePath.get(settings)).orElse(null);
            if (certPath == null) {
                throw new IllegalArgumentException("you must specify the certificates [" + keyPair.certificatePath.getKey() + "] to use with the key [" + keyPair.keyPath.getKey() + "]");
            }
            return new PEMKeyConfig(keyPath, keyPassword, certPath);
        }
        if (keyStorePath != null) {
            SecureString keyStorePassword = (SecureString)keyPair.keystorePassword.get(settings);
            String keyStoreAlgorithm = (String)keyPair.keystoreAlgorithm.get(settings);
            String keyStoreType = SSLConfigurationSettings.getKeyStoreType(keyPair.keystoreType, settings, keyStorePath);
            SecureString keyStoreKeyPassword = (SecureString)keyPair.keystoreKeyPassword.get(settings);
            if (keyStoreKeyPassword.length() == 0) {
                keyStoreKeyPassword = keyStorePassword;
            }
            return new StoreKeyConfig(keyStorePath, keyStoreType, keyStorePassword, keyStoreKeyPassword, keyStoreAlgorithm, trustStoreAlgorithm);
        }
        return null;
    }

    public static X509ExtendedTrustManager trustManager(Certificate[] certificates) throws NoSuchAlgorithmException, UnrecoverableKeyException, KeyStoreException, IOException, CertificateException {
        KeyStore store = CertUtils.trustStore(certificates);
        return CertUtils.trustManager(store, TrustManagerFactory.getDefaultAlgorithm());
    }

    static KeyStore trustStore(Certificate[] certificates) throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException {
        assert (certificates != null) : "Cannot create trust store with null certificates";
        KeyStore store = KeyStore.getInstance("jks");
        store.load(null, null);
        int counter = 0;
        for (Certificate certificate : certificates) {
            store.setCertificateEntry("cert" + counter, certificate);
            ++counter;
        }
        return store;
    }

    public static X509ExtendedTrustManager trustManager(String trustStorePath, String trustStoreType, char[] trustStorePassword, String trustStoreAlgorithm, @Nullable Environment env) throws NoSuchAlgorithmException, UnrecoverableKeyException, KeyStoreException, IOException, CertificateException {
        KeyStore trustStore = CertUtils.readKeyStore(CertUtils.resolvePath(trustStorePath, env), trustStoreType, trustStorePassword);
        return CertUtils.trustManager(trustStore, trustStoreAlgorithm);
    }

    static KeyStore readKeyStore(Path path, String type, char[] password) throws IOException, KeyStoreException, CertificateException, NoSuchAlgorithmException {
        try (InputStream in = Files.newInputStream(path, new OpenOption[0]);){
            KeyStore store = KeyStore.getInstance(type);
            assert (password != null);
            store.load(in, password);
            KeyStore keyStore = store;
            return keyStore;
        }
    }

    static X509ExtendedTrustManager trustManager(KeyStore keyStore, String algorithm) throws NoSuchAlgorithmException, UnrecoverableKeyException, KeyStoreException, IOException, CertificateException {
        TrustManager[] trustManagers;
        TrustManagerFactory tmf = TrustManagerFactory.getInstance(algorithm);
        tmf.init(keyStore);
        for (TrustManager trustManager : trustManagers = tmf.getTrustManagers()) {
            if (!(trustManager instanceof X509ExtendedTrustManager)) continue;
            return (X509ExtendedTrustManager)trustManager;
        }
        throw new IllegalStateException("failed to find a X509ExtendedTrustManager");
    }

    public static Certificate[] readCertificates(List<String> certPaths, @Nullable Environment environment) throws CertificateException, IOException {
        List<Path> resolvedPaths = certPaths.stream().map(p -> CertUtils.resolvePath(p, environment)).collect(Collectors.toList());
        return CertUtils.readCertificates(resolvedPaths);
    }

    public static Certificate[] readCertificates(List<Path> certPaths) throws CertificateException, IOException {
        ArrayList<Certificate> certificates = new ArrayList<Certificate>(certPaths.size());
        CertificateFactory certFactory = CertificateFactory.getInstance("X.509");
        for (Path path : certPaths) {
            BufferedReader reader = Files.newBufferedReader(path, StandardCharsets.UTF_8);
            Throwable throwable = null;
            try {
                CertUtils.readCertificates(reader, certificates, certFactory);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (reader == null) continue;
                CertUtils.$closeResource(throwable, reader);
            }
        }
        return certificates.toArray(new Certificate[certificates.size()]);
    }

    static void readCertificates(Reader reader, List<Certificate> certificates, CertificateFactory certFactory) throws IOException, CertificateException {
        try (PEMParser pemParser = new PEMParser(reader);){
            Object parsed = pemParser.readObject();
            if (parsed == null) {
                throw new IllegalArgumentException("could not parse pem certificate");
            }
            while (parsed != null) {
                X509CertificateHolder holder;
                if (parsed instanceof X509CertificateHolder) {
                    holder = (X509CertificateHolder)parsed;
                } else if (parsed instanceof X509TrustedCertificateBlock) {
                    X509TrustedCertificateBlock certificateBlock = (X509TrustedCertificateBlock)parsed;
                    holder = certificateBlock.getCertificateHolder();
                } else {
                    String msg = "parsed an unsupported object [" + parsed.getClass().getSimpleName() + "]";
                    if (parsed instanceof PEMEncryptedKeyPair || parsed instanceof PEMKeyPair || parsed instanceof PrivateKeyInfo) {
                        msg = msg + ". Encountered a PEM Key while expecting a PEM certificate.";
                    }
                    throw new IllegalArgumentException(msg);
                }
                certificates.add(certFactory.generateCertificate(new ByteArrayInputStream(holder.getEncoded())));
                parsed = pemParser.readObject();
            }
        }
    }

    public static PrivateKey readPrivateKey(Reader reader, Supplier<char[]> passwordSupplier) throws IOException {
        try (PEMParser parser = new PEMParser(reader);){
            PrivateKeyInfo privateKeyInfo = CertUtils.innerReadPrivateKey(parser, passwordSupplier);
            if (parser.readObject() != null) {
                throw new IllegalStateException("key file contained more that one entry");
            }
            JcaPEMKeyConverter converter = new JcaPEMKeyConverter();
            converter.setProvider((Provider)BC_PROV);
            PrivateKey privateKey = converter.getPrivateKey(privateKeyInfo);
            return privateKey;
        }
    }

    private static PrivateKeyInfo innerReadPrivateKey(PEMParser parser, Supplier<char[]> passwordSupplier) throws IOException {
        PrivateKeyInfo privateKeyInfo;
        Object parsed = parser.readObject();
        if (parsed == null) {
            throw new IllegalStateException("key file did not contain a supported key");
        }
        if (parsed instanceof PEMEncryptedKeyPair) {
            char[] keyPassword = passwordSupplier.get();
            if (keyPassword == null) {
                throw new IllegalArgumentException("cannot read encrypted key without a password");
            }
            PEMEncryptedKeyPair encryptedKeyPair = (PEMEncryptedKeyPair)parsed;
            privateKeyInfo = encryptedKeyPair.decryptKeyPair(new JcePEMDecryptorProviderBuilder().setProvider((Provider)BC_PROV).build(keyPassword)).getPrivateKeyInfo();
        } else if (parsed instanceof PEMKeyPair) {
            privateKeyInfo = ((PEMKeyPair)parsed).getPrivateKeyInfo();
        } else if (parsed instanceof PrivateKeyInfo) {
            privateKeyInfo = (PrivateKeyInfo)parsed;
        } else {
            if (parsed instanceof ASN1ObjectIdentifier) {
                return CertUtils.innerReadPrivateKey(parser, passwordSupplier);
            }
            String msg = "parsed an unsupported object [" + parsed.getClass().getSimpleName() + "]";
            if (parsed instanceof X509CertificateHolder || parsed instanceof X509TrustedCertificateBlock) {
                msg = msg + ". Encountered a PEM Certificate while expecting a PEM Key.";
            }
            throw new IllegalArgumentException(msg);
        }
        return privateKeyInfo;
    }

    static Map<Certificate, Key> readPkcs12KeyPairs(Path path, char[] password, Function<String, char[]> keyPassword, Environment env) throws CertificateException, NoSuchAlgorithmException, KeyStoreException, IOException, UnrecoverableKeyException {
        KeyStore store = CertUtils.readKeyStore(path, "PKCS12", password);
        Enumeration<String> enumeration = store.aliases();
        HashMap<Certificate, Key> map = new HashMap<Certificate, Key>(store.size());
        while (enumeration.hasMoreElements()) {
            String alias = enumeration.nextElement();
            if (!store.isKeyEntry(alias)) continue;
            char[] pass = keyPassword.apply(alias);
            map.put(store.getCertificate(alias), store.getKey(alias, pass));
        }
        return map;
    }

    public static X509Certificate generateCACertificate(X500Principal x500Principal, KeyPair keyPair, int days) throws OperatorCreationException, CertificateException, CertIOException, NoSuchAlgorithmException {
        return CertUtils.generateSignedCertificate(x500Principal, null, keyPair, null, null, true, days);
    }

    public static X509Certificate generateSignedCertificate(X500Principal principal, GeneralNames subjectAltNames, KeyPair keyPair, X509Certificate caCert, PrivateKey caPrivKey, int days) throws OperatorCreationException, CertificateException, CertIOException, NoSuchAlgorithmException {
        return CertUtils.generateSignedCertificate(principal, subjectAltNames, keyPair, caCert, caPrivKey, false, days);
    }

    private static X509Certificate generateSignedCertificate(X500Principal principal, GeneralNames subjectAltNames, KeyPair keyPair, X509Certificate caCert, PrivateKey caPrivKey, boolean isCa, int days) throws NoSuchAlgorithmException, CertificateException, CertIOException, OperatorCreationException {
        AuthorityKeyIdentifier authorityKeyIdentifier;
        X500Name issuer;
        DateTime notBefore = new DateTime(DateTimeZone.UTC);
        if (days < 1) {
            throw new IllegalArgumentException("the certificate must be valid for at least one day");
        }
        DateTime notAfter = notBefore.plusDays(days);
        BigInteger serial = CertUtils.getSerial();
        JcaX509ExtensionUtils extUtils = new JcaX509ExtensionUtils();
        X500Name subject = X500Name.getInstance((Object)principal.getEncoded());
        if (caCert != null) {
            if (caCert.getBasicConstraints() < 0) {
                throw new IllegalArgumentException("ca certificate is not a CA!");
            }
            issuer = X500Name.getInstance((Object)caCert.getIssuerX500Principal().getEncoded());
            authorityKeyIdentifier = extUtils.createAuthorityKeyIdentifier(caCert);
        } else {
            issuer = subject;
            authorityKeyIdentifier = extUtils.createAuthorityKeyIdentifier(keyPair.getPublic(), new X500Principal(issuer.toString()), serial);
        }
        JcaX509v3CertificateBuilder builder = new JcaX509v3CertificateBuilder(issuer, serial, new Time(notBefore.toDate(), Locale.ROOT), new Time(notAfter.toDate(), Locale.ROOT), subject, keyPair.getPublic());
        builder.addExtension(Extension.subjectKeyIdentifier, false, (ASN1Encodable)extUtils.createSubjectKeyIdentifier(keyPair.getPublic()));
        builder.addExtension(Extension.authorityKeyIdentifier, false, (ASN1Encodable)authorityKeyIdentifier);
        if (subjectAltNames != null) {
            builder.addExtension(Extension.subjectAlternativeName, false, (ASN1Encodable)subjectAltNames);
        }
        builder.addExtension(Extension.basicConstraints, isCa, (ASN1Encodable)new BasicConstraints(isCa));
        PrivateKey signingKey = caPrivKey != null ? caPrivKey : keyPair.getPrivate();
        ContentSigner signer = new JcaContentSignerBuilder("SHA256withRSA").build(signingKey);
        X509CertificateHolder certificateHolder = builder.build(signer);
        return new JcaX509CertificateConverter().getCertificate(certificateHolder);
    }

    static PKCS10CertificationRequest generateCSR(KeyPair keyPair, X500Principal principal, GeneralNames sanList) throws IOException, OperatorCreationException {
        Objects.requireNonNull(keyPair, "Key-Pair must not be null");
        Objects.requireNonNull(keyPair.getPublic(), "Public-Key must not be null");
        Objects.requireNonNull(principal, "Principal must not be null");
        JcaPKCS10CertificationRequestBuilder builder = new JcaPKCS10CertificationRequestBuilder(principal, keyPair.getPublic());
        if (sanList != null) {
            ExtensionsGenerator extGen = new ExtensionsGenerator();
            extGen.addExtension(Extension.subjectAlternativeName, false, (ASN1Encodable)sanList);
            builder.addAttribute(PKCSObjectIdentifiers.pkcs_9_at_extensionRequest, (ASN1Encodable)extGen.generate());
        }
        return builder.build(new JcaContentSignerBuilder("SHA256withRSA").setProvider((Provider)BC_PROV).build(keyPair.getPrivate()));
    }

    public static BigInteger getSerial() {
        SecureRandom random = new SecureRandom();
        BigInteger serial = new BigInteger(160, random);
        assert (serial.compareTo(BigInteger.valueOf(0L)) >= 0);
        return serial;
    }

    public static KeyPair generateKeyPair(int keysize) throws NoSuchAlgorithmException {
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("RSA");
        keyPairGenerator.initialize(keysize);
        return keyPairGenerator.generateKeyPair();
    }

    public static GeneralNames getSubjectAlternativeNames(boolean resolveName, Set<InetAddress> addresses) throws SocketException {
        HashSet<GeneralName> generalNameList = new HashSet<GeneralName>();
        for (InetAddress address : addresses) {
            if (address.isAnyLocalAddress()) {
                for (InetAddress inetAddress : InetAddressHelper.getAllAddresses()) {
                    CertUtils.addSubjectAlternativeNames(resolveName, inetAddress, generalNameList);
                }
                continue;
            }
            CertUtils.addSubjectAlternativeNames(resolveName, address, generalNameList);
        }
        return new GeneralNames(generalNameList.toArray(new GeneralName[generalNameList.size()]));
    }

    @SuppressForbidden(reason="need to use getHostName to resolve DNS name and getHostAddress to ensure we resolved the name")
    private static void addSubjectAlternativeNames(boolean resolveName, InetAddress inetAddress, Set<GeneralName> list) {
        String possibleHostName;
        String hostaddress = inetAddress.getHostAddress();
        String ip = NetworkAddress.format((InetAddress)inetAddress);
        list.add(new GeneralName(7, ip));
        if (resolveName && !inetAddress.isLinkLocalAddress() && !(possibleHostName = inetAddress.getHostName()).equals(hostaddress)) {
            list.add(new GeneralName(2, possibleHostName));
        }
    }

    public static GeneralName createCommonName(String cn) {
        ASN1Encodable[] sequence = new ASN1Encodable[]{new ASN1ObjectIdentifier(CN_OID), new DERTaggedObject(true, 0, (ASN1Encodable)new DERUTF8String(cn))};
        return new GeneralName(0, (ASN1Encodable)new DERSequence(sequence));
    }
}

