/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.authz.privilege;

import java.util.Collections;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import org.apache.lucene.util.automaton.Automaton;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.collect.MapBuilder;
import org.elasticsearch.xpack.core.security.authz.privilege.Privilege;
import org.elasticsearch.xpack.core.security.support.Automatons;

public final class ClusterPrivilege
extends Privilege {
    private static final Automaton MANAGE_SECURITY_AUTOMATON = Automatons.patterns("cluster:admin/xpack/security/*");
    private static final Automaton MANAGE_SAML_AUTOMATON = Automatons.patterns("cluster:admin/xpack/security/saml/*", "cluster:admin/xpack/security/token/invalidate", "cluster:admin/xpack/security/token/refresh");
    private static final Automaton MONITOR_AUTOMATON = Automatons.patterns("cluster:monitor/*");
    private static final Automaton MONITOR_ML_AUTOMATON = Automatons.patterns("cluster:monitor/xpack/ml/*");
    private static final Automaton MONITOR_WATCHER_AUTOMATON = Automatons.patterns("cluster:monitor/xpack/watcher/*");
    private static final Automaton ALL_CLUSTER_AUTOMATON = Automatons.patterns("cluster:*", "indices:admin/template/*");
    private static final Automaton MANAGE_AUTOMATON = Automatons.minusAndMinimize(ALL_CLUSTER_AUTOMATON, MANAGE_SECURITY_AUTOMATON);
    private static final Automaton MANAGE_ML_AUTOMATON = Automatons.patterns("cluster:admin/xpack/ml/*", "cluster:monitor/xpack/ml/*");
    private static final Automaton MANAGE_WATCHER_AUTOMATON = Automatons.patterns("cluster:admin/xpack/watcher/*", "cluster:monitor/xpack/watcher/*");
    private static final Automaton TRANSPORT_CLIENT_AUTOMATON = Automatons.patterns("cluster:monitor/nodes/liveness", "cluster:monitor/state");
    private static final Automaton MANAGE_IDX_TEMPLATE_AUTOMATON = Automatons.patterns("indices:admin/template/*");
    private static final Automaton MANAGE_INGEST_PIPELINE_AUTOMATON = Automatons.patterns("cluster:admin/ingest/pipeline/*");
    public static final ClusterPrivilege NONE = new ClusterPrivilege("none", Automatons.EMPTY);
    public static final ClusterPrivilege ALL = new ClusterPrivilege("all", ALL_CLUSTER_AUTOMATON);
    public static final ClusterPrivilege MONITOR = new ClusterPrivilege("monitor", MONITOR_AUTOMATON);
    public static final ClusterPrivilege MONITOR_ML = new ClusterPrivilege("monitor_ml", MONITOR_ML_AUTOMATON);
    public static final ClusterPrivilege MONITOR_WATCHER = new ClusterPrivilege("monitor_watcher", MONITOR_WATCHER_AUTOMATON);
    public static final ClusterPrivilege MANAGE = new ClusterPrivilege("manage", MANAGE_AUTOMATON);
    public static final ClusterPrivilege MANAGE_ML = new ClusterPrivilege("manage_ml", MANAGE_ML_AUTOMATON);
    public static final ClusterPrivilege MANAGE_WATCHER = new ClusterPrivilege("manage_watcher", MANAGE_WATCHER_AUTOMATON);
    public static final ClusterPrivilege MANAGE_IDX_TEMPLATES = new ClusterPrivilege("manage_index_templates", MANAGE_IDX_TEMPLATE_AUTOMATON);
    public static final ClusterPrivilege MANAGE_INGEST_PIPELINES = new ClusterPrivilege("manage_ingest_pipelines", MANAGE_INGEST_PIPELINE_AUTOMATON);
    public static final ClusterPrivilege TRANSPORT_CLIENT = new ClusterPrivilege("transport_client", TRANSPORT_CLIENT_AUTOMATON);
    public static final ClusterPrivilege MANAGE_SECURITY = new ClusterPrivilege("manage_security", MANAGE_SECURITY_AUTOMATON);
    public static final ClusterPrivilege MANAGE_SAML = new ClusterPrivilege("manage_saml", MANAGE_SAML_AUTOMATON);
    public static final ClusterPrivilege MANAGE_PIPELINE = new ClusterPrivilege("manage_pipeline", "cluster:admin/ingest/pipeline/*");
    public static final Predicate<String> ACTION_MATCHER = ALL.predicate();
    private static final Map<String, ClusterPrivilege> VALUES = MapBuilder.newMapBuilder().put((Object)"none", (Object)NONE).put((Object)"all", (Object)ALL).put((Object)"monitor", (Object)MONITOR).put((Object)"monitor_ml", (Object)MONITOR_ML).put((Object)"monitor_watcher", (Object)MONITOR_WATCHER).put((Object)"manage", (Object)MANAGE).put((Object)"manage_ml", (Object)MANAGE_ML).put((Object)"manage_watcher", (Object)MANAGE_WATCHER).put((Object)"manage_index_templates", (Object)MANAGE_IDX_TEMPLATES).put((Object)"manage_ingest_pipelines", (Object)MANAGE_INGEST_PIPELINES).put((Object)"transport_client", (Object)TRANSPORT_CLIENT).put((Object)"manage_security", (Object)MANAGE_SECURITY).put((Object)"manage_saml", (Object)MANAGE_SAML).put((Object)"manage_pipeline", (Object)MANAGE_PIPELINE).immutableMap();
    private static final ConcurrentHashMap<Set<String>, ClusterPrivilege> CACHE = new ConcurrentHashMap();

    private ClusterPrivilege(String name, String ... patterns) {
        super(name, patterns);
    }

    private ClusterPrivilege(String name, Automaton automaton) {
        super(Collections.singleton(name), automaton);
    }

    private ClusterPrivilege(Set<String> name, Automaton automaton) {
        super(name, automaton);
    }

    public static ClusterPrivilege get(Set<String> name) {
        if (name == null || name.isEmpty()) {
            return NONE;
        }
        return CACHE.computeIfAbsent(name, ClusterPrivilege::resolve);
    }

    private static ClusterPrivilege resolve(Set<String> name) {
        int size = name.size();
        if (size == 0) {
            throw new IllegalArgumentException("empty set should not be used");
        }
        HashSet<String> actions = new HashSet<String>();
        HashSet<Automaton> automata = new HashSet<Automaton>();
        for (String part : name) {
            if (ACTION_MATCHER.test(part = part.toLowerCase(Locale.ROOT))) {
                actions.add(ClusterPrivilege.actionToPattern(part));
                continue;
            }
            ClusterPrivilege privilege = VALUES.get(part);
            if (privilege != null && size == 1) {
                return privilege;
            }
            if (privilege != null) {
                automata.add(privilege.automaton);
                continue;
            }
            throw new IllegalArgumentException("unknown cluster privilege [" + name + "]. a privilege must be either one of the predefined fixed cluster privileges [" + Strings.collectionToCommaDelimitedString(VALUES.entrySet()) + "] or a pattern over one of the available cluster actions");
        }
        if (!actions.isEmpty()) {
            automata.add(Automatons.patterns(actions));
        }
        return new ClusterPrivilege(name, Automatons.unionAndMinimize(automata));
    }
}

