/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.authz.permission;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.util.set.Sets;
import org.elasticsearch.xpack.core.security.authz.RoleDescriptor;
import org.elasticsearch.xpack.core.security.authz.accesscontrol.IndicesAccessControl;
import org.elasticsearch.xpack.core.security.authz.permission.ClusterPermission;
import org.elasticsearch.xpack.core.security.authz.permission.FieldPermissions;
import org.elasticsearch.xpack.core.security.authz.permission.FieldPermissionsCache;
import org.elasticsearch.xpack.core.security.authz.permission.FieldPermissionsDefinition;
import org.elasticsearch.xpack.core.security.authz.permission.IndicesPermission;
import org.elasticsearch.xpack.core.security.authz.permission.RunAsPermission;
import org.elasticsearch.xpack.core.security.authz.privilege.ClusterPrivilege;
import org.elasticsearch.xpack.core.security.authz.privilege.IndexPrivilege;
import org.elasticsearch.xpack.core.security.authz.privilege.Privilege;

public final class Role {
    public static final Role EMPTY = Role.builder("__empty").build();
    private final String[] names;
    private final ClusterPermission cluster;
    private final IndicesPermission indices;
    private final RunAsPermission runAs;

    Role(String[] names, ClusterPermission cluster, IndicesPermission indices, RunAsPermission runAs) {
        this.names = names;
        this.cluster = Objects.requireNonNull(cluster);
        this.indices = Objects.requireNonNull(indices);
        this.runAs = Objects.requireNonNull(runAs);
    }

    public String[] names() {
        return this.names;
    }

    public ClusterPermission cluster() {
        return this.cluster;
    }

    public IndicesPermission indices() {
        return this.indices;
    }

    public RunAsPermission runAs() {
        return this.runAs;
    }

    public static Builder builder(String ... names) {
        return new Builder(names, null);
    }

    public static Builder builder(String[] names, FieldPermissionsCache fieldPermissionsCache) {
        return new Builder(names, fieldPermissionsCache);
    }

    public static Builder builder(RoleDescriptor rd, FieldPermissionsCache fieldPermissionsCache) {
        return new Builder(rd, fieldPermissionsCache);
    }

    public IndicesAccessControl authorize(String action, Set<String> requestedIndicesOrAliases, MetaData metaData, FieldPermissionsCache fieldPermissionsCache) {
        Map<String, IndicesAccessControl.IndexAccessControl> indexPermissions = this.indices.authorize(action, requestedIndicesOrAliases, metaData, fieldPermissionsCache);
        boolean granted = true;
        for (Map.Entry<String, IndicesAccessControl.IndexAccessControl> entry : indexPermissions.entrySet()) {
            if (entry.getValue().isGranted()) continue;
            granted = false;
            break;
        }
        return new IndicesAccessControl(granted, indexPermissions);
    }

    public static class Builder {
        private final String[] names;
        private ClusterPermission cluster = ClusterPermission.NONE;
        private RunAsPermission runAs = RunAsPermission.NONE;
        private List<IndicesPermission.Group> groups = new ArrayList<IndicesPermission.Group>();
        private FieldPermissionsCache fieldPermissionsCache = null;

        private Builder(String[] names, FieldPermissionsCache fieldPermissionsCache) {
            this.names = names;
            this.fieldPermissionsCache = fieldPermissionsCache;
        }

        private Builder(RoleDescriptor rd, @Nullable FieldPermissionsCache fieldPermissionsCache) {
            this.names = new String[]{rd.getName()};
            this.fieldPermissionsCache = fieldPermissionsCache;
            if (rd.getClusterPrivileges().length == 0) {
                this.cluster = ClusterPermission.NONE;
            } else {
                this.cluster(ClusterPrivilege.get(Sets.newHashSet((Object[])rd.getClusterPrivileges())));
            }
            this.groups.addAll(Builder.convertFromIndicesPrivileges(rd.getIndicesPrivileges(), fieldPermissionsCache));
            Object[] rdRunAs = rd.getRunAs();
            if (rdRunAs != null && rdRunAs.length > 0) {
                this.runAs(new Privilege((Set<String>)Sets.newHashSet((Object[])rdRunAs), (String[])rdRunAs));
            }
        }

        public Builder cluster(ClusterPrivilege privilege) {
            this.cluster = new ClusterPermission(privilege);
            return this;
        }

        public Builder runAs(Privilege privilege) {
            this.runAs = new RunAsPermission(privilege);
            return this;
        }

        public Builder add(IndexPrivilege privilege, String ... indices) {
            this.groups.add(new IndicesPermission.Group(privilege, FieldPermissions.DEFAULT, null, indices));
            return this;
        }

        public Builder add(FieldPermissions fieldPermissions, Set<BytesReference> query, IndexPrivilege privilege, String ... indices) {
            this.groups.add(new IndicesPermission.Group(privilege, fieldPermissions, query, indices));
            return this;
        }

        public Role build() {
            IndicesPermission indices = this.groups.isEmpty() ? IndicesPermission.NONE : new IndicesPermission(this.groups.toArray(new IndicesPermission.Group[this.groups.size()]));
            return new Role(this.names, this.cluster, indices, this.runAs);
        }

        static List<IndicesPermission.Group> convertFromIndicesPrivileges(RoleDescriptor.IndicesPrivileges[] indicesPrivileges, @Nullable FieldPermissionsCache fieldPermissionsCache) {
            ArrayList<IndicesPermission.Group> list = new ArrayList<IndicesPermission.Group>(indicesPrivileges.length);
            for (RoleDescriptor.IndicesPrivileges privilege : indicesPrivileges) {
                FieldPermissions fieldPermissions = fieldPermissionsCache != null ? fieldPermissionsCache.getFieldPermissions(privilege.getGrantedFields(), privilege.getDeniedFields()) : new FieldPermissions(new FieldPermissionsDefinition(privilege.getGrantedFields(), privilege.getDeniedFields()));
                Set<BytesReference> query = privilege.getQuery() == null ? null : Collections.singleton(privilege.getQuery());
                list.add(new IndicesPermission.Group(IndexPrivilege.get(Sets.newHashSet((Object[])privilege.getPrivileges())), fieldPermissions, query, privilege.getIndices()));
            }
            return list;
        }
    }
}

