/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.authc.support.mapper.expressiondsl;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import org.elasticsearch.common.Numbers;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.security.authc.support.mapper.expressiondsl.ExpressionParser;
import org.elasticsearch.xpack.core.security.authc.support.mapper.expressiondsl.RoleMapperExpression;
import org.elasticsearch.xpack.core.security.support.Automatons;

public final class FieldExpression
implements RoleMapperExpression {
    public static final String NAME = "field";
    private final String field;
    private final List<FieldPredicate> values;

    public FieldExpression(String field, List<FieldPredicate> values) {
        if (field == null || field.isEmpty()) {
            throw new IllegalArgumentException("null or empty field name (" + field + ")");
        }
        if (values == null || values.isEmpty()) {
            throw new IllegalArgumentException("null or empty values (" + values + ")");
        }
        this.field = field;
        this.values = values;
    }

    public FieldExpression(StreamInput in) throws IOException {
        this(in.readString(), in.readList(FieldPredicate::readFrom));
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.field);
        out.writeList(this.values);
    }

    public String getWriteableName() {
        return NAME;
    }

    @Override
    public boolean match(Map<String, Object> object) {
        Object fieldValue = object.get(this.field);
        if (fieldValue instanceof Collection) {
            return ((Collection)fieldValue).stream().anyMatch(this::matchValue);
        }
        return this.matchValue(fieldValue);
    }

    private boolean matchValue(Object fieldValue) {
        return this.values.stream().anyMatch(predicate -> predicate.test(fieldValue));
    }

    public String getField() {
        return this.field;
    }

    public List<Predicate<Object>> getValues() {
        return Collections.unmodifiableList(this.values);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FieldExpression that = (FieldExpression)o;
        return this.field.equals(that.field) && this.values.equals(that.values);
    }

    public int hashCode() {
        int result = this.field.hashCode();
        result = 31 * result + this.values.hashCode();
        return result;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.startObject(ExpressionParser.Fields.FIELD.getPreferredName());
        if (this.values.size() == 1) {
            builder.field(this.field);
            this.values.get(0).toXContent(builder, params);
        } else {
            builder.startArray(this.field);
            for (FieldPredicate fp : this.values) {
                fp.toXContent(builder, params);
            }
            builder.endArray();
        }
        builder.endObject();
        return builder.endObject();
    }

    public static class FieldPredicate
    implements Predicate<Object>,
    ToXContent,
    Writeable {
        private final Object value;
        private final Predicate<Object> predicate;

        private FieldPredicate(Object value, Predicate<Object> predicate) {
            this.value = value;
            this.predicate = predicate;
        }

        @Override
        public boolean test(Object o) {
            return this.predicate.test(o);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            return builder.value(this.value);
        }

        public static FieldPredicate create(Object value) {
            Predicate<Object> predicate = FieldPredicate.buildPredicate(value);
            return new FieldPredicate(value, predicate);
        }

        public static FieldPredicate readFrom(StreamInput in) throws IOException {
            return FieldPredicate.create(in.readGenericValue());
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeGenericValue(this.value);
        }

        private static Predicate<Object> buildPredicate(Object object) {
            if (object == null) {
                return Objects::isNull;
            }
            if (object instanceof Boolean) {
                return object::equals;
            }
            if (object instanceof Number) {
                return other -> FieldPredicate.numberEquals((Number)object, other);
            }
            if (object instanceof String) {
                String str = (String)object;
                if (str.isEmpty()) {
                    return obj -> String.valueOf(obj).isEmpty();
                }
                Predicate<String> predicate = Automatons.predicate(str);
                return obj -> predicate.test(String.valueOf(obj));
            }
            throw new IllegalArgumentException("Unsupported value type " + object.getClass());
        }

        private static boolean numberEquals(Number left, Object other) {
            if (left.equals(other)) {
                return true;
            }
            if (!(other instanceof Number)) {
                return false;
            }
            Number right = (Number)other;
            if (left instanceof Double || left instanceof Float || right instanceof Double || right instanceof Float) {
                return Double.compare(left.doubleValue(), right.doubleValue()) == 0;
            }
            return Numbers.toLongExact((Number)left) == Numbers.toLongExact((Number)right);
        }
    }
}

