/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.authc.pki;

import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.xpack.core.security.authc.support.mapper.CompositeRoleMapperSettings;
import org.elasticsearch.xpack.core.ssl.SSLConfigurationSettings;

public final class PkiRealmSettings {
    public static final String TYPE = "pki";
    public static final String DEFAULT_USERNAME_PATTERN = "CN=(.*?)(?:,|$)";
    public static final Setting<Pattern> USERNAME_PATTERN_SETTING = new Setting("username_pattern", "CN=(.*?)(?:,|$)", s -> Pattern.compile(s, 2), new Setting.Property[]{Setting.Property.NodeScope});
    public static final SSLConfigurationSettings SSL_SETTINGS = SSLConfigurationSettings.withoutPrefix();

    private PkiRealmSettings() {
    }

    public static Set<Setting<?>> getSettings() {
        HashSet settings = new HashSet();
        settings.add(USERNAME_PATTERN_SETTING);
        settings.add(PkiRealmSettings.SSL_SETTINGS.truststorePath);
        settings.add(PkiRealmSettings.SSL_SETTINGS.truststorePassword);
        settings.add(PkiRealmSettings.SSL_SETTINGS.legacyTruststorePassword);
        settings.add(PkiRealmSettings.SSL_SETTINGS.truststoreAlgorithm);
        settings.add(PkiRealmSettings.SSL_SETTINGS.caPaths);
        settings.addAll(CompositeRoleMapperSettings.getSettings());
        return settings;
    }
}

