/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.authc.ldap;

import java.util.HashSet;
import java.util.Set;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.xpack.core.security.authc.ldap.PoolingSessionFactorySettings;
import org.elasticsearch.xpack.core.security.authc.ldap.support.SessionFactorySettings;

public final class ActiveDirectorySessionFactorySettings {
    public static final String AD_DOMAIN_NAME_SETTING = "domain_name";
    public static final String AD_GROUP_SEARCH_BASEDN_SETTING = "group_search.base_dn";
    public static final String AD_GROUP_SEARCH_SCOPE_SETTING = "group_search.scope";
    public static final String AD_USER_SEARCH_BASEDN_SETTING = "user_search.base_dn";
    public static final String AD_USER_SEARCH_FILTER_SETTING = "user_search.filter";
    public static final String AD_UPN_USER_SEARCH_FILTER_SETTING = "user_search.upn_filter";
    public static final String AD_DOWN_LEVEL_USER_SEARCH_FILTER_SETTING = "user_search.down_level_filter";
    public static final String AD_USER_SEARCH_SCOPE_SETTING = "user_search.scope";
    public static final Setting<Boolean> POOL_ENABLED = Setting.boolSetting((String)"user_search.pool.enabled", settings -> Boolean.toString(PoolingSessionFactorySettings.BIND_DN.exists(settings)), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});

    private ActiveDirectorySessionFactorySettings() {
    }

    public static Set<Setting<?>> getSettings() {
        HashSet settings = new HashSet();
        settings.addAll(SessionFactorySettings.getSettings());
        settings.add(Setting.simpleString((String)AD_DOMAIN_NAME_SETTING, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}));
        settings.add(Setting.simpleString((String)AD_GROUP_SEARCH_BASEDN_SETTING, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}));
        settings.add(Setting.simpleString((String)AD_GROUP_SEARCH_SCOPE_SETTING, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}));
        settings.add(Setting.simpleString((String)AD_USER_SEARCH_BASEDN_SETTING, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}));
        settings.add(Setting.simpleString((String)AD_USER_SEARCH_FILTER_SETTING, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}));
        settings.add(Setting.simpleString((String)AD_UPN_USER_SEARCH_FILTER_SETTING, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}));
        settings.add(Setting.simpleString((String)AD_DOWN_LEVEL_USER_SEARCH_FILTER_SETTING, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}));
        settings.add(Setting.simpleString((String)AD_USER_SEARCH_SCOPE_SETTING, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}));
        settings.add(POOL_ENABLED);
        settings.addAll(PoolingSessionFactorySettings.getSettings());
        return settings;
    }
}

