/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.persistent;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.elasticsearch.ResourceAlreadyExistsException;
import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.Version;
import org.elasticsearch.cluster.AbstractNamedDiffable;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.NamedDiff;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.xpack.core.persistent.PersistentTaskParams;

public final class PersistentTasksCustomMetaData
extends AbstractNamedDiffable<MetaData.Custom>
implements MetaData.Custom {
    public static final String TYPE = "persistent_tasks";
    private static final String API_CONTEXT = MetaData.XContentContext.API.toString();
    private final Map<String, PersistentTask<?>> tasks;
    private final long lastAllocationId;
    private static final ObjectParser<Builder, Void> PERSISTENT_TASKS_PARSER = new ObjectParser("persistent_tasks", () -> new Builder());
    private static final ObjectParser<TaskBuilder<PersistentTaskParams>, Void> PERSISTENT_TASK_PARSER = new ObjectParser("tasks", () -> new TaskBuilder());
    public static final ConstructingObjectParser<Assignment, Void> ASSIGNMENT_PARSER = new ConstructingObjectParser("assignment", objects -> new Assignment((String)objects[0], (String)objects[1]));
    private static final ObjectParser.NamedObjectParser<TaskDescriptionBuilder<PersistentTaskParams>, Void> TASK_DESCRIPTION_PARSER;
    public static final Assignment INITIAL_ASSIGNMENT;

    public PersistentTasksCustomMetaData(long lastAllocationId, Map<String, PersistentTask<?>> tasks) {
        this.lastAllocationId = lastAllocationId;
        this.tasks = tasks;
    }

    public Collection<PersistentTask<?>> tasks() {
        return this.tasks.values();
    }

    public Map<String, PersistentTask<?>> taskMap() {
        return this.tasks;
    }

    public PersistentTask<?> getTask(String id) {
        return this.tasks.get(id);
    }

    public Collection<PersistentTask<?>> findTasks(String taskName, Predicate<PersistentTask<?>> predicate) {
        return this.tasks().stream().filter(p -> taskName.equals(p.getTaskName())).filter(predicate).collect(Collectors.toList());
    }

    public boolean tasksExist(String taskName, Predicate<PersistentTask<?>> predicate) {
        return this.tasks().stream().filter(p -> taskName.equals(p.getTaskName())).anyMatch(predicate);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        PersistentTasksCustomMetaData that = (PersistentTasksCustomMetaData)((Object)o);
        return this.lastAllocationId == that.lastAllocationId && Objects.equals(this.tasks, that.tasks);
    }

    public int hashCode() {
        return Objects.hash(this.tasks, this.lastAllocationId);
    }

    public String toString() {
        return Strings.toString((ToXContent)this);
    }

    public long getNumberOfTasksOnNode(String nodeId, String taskName) {
        return this.tasks.values().stream().filter(task -> taskName.equals(((PersistentTask)task).taskName) && nodeId.equals(((PersistentTask)task).assignment.executorNode)).count();
    }

    public Version getMinimalSupportedVersion() {
        return Version.V_5_4_0;
    }

    public EnumSet<MetaData.XContentContext> context() {
        return MetaData.ALL_CONTEXTS;
    }

    public static PersistentTasksCustomMetaData fromXContent(XContentParser parser) throws IOException {
        return ((Builder)PERSISTENT_TASKS_PARSER.parse(parser, null)).build();
    }

    public static <Params extends PersistentTaskParams> PersistentTask<Params> getTaskWithId(ClusterState clusterState, String taskId) {
        PersistentTasksCustomMetaData tasks = (PersistentTasksCustomMetaData)clusterState.metaData().custom(TYPE);
        if (tasks != null) {
            return tasks.getTask(taskId);
        }
        return null;
    }

    public String getWriteableName() {
        return TYPE;
    }

    public PersistentTasksCustomMetaData(StreamInput in) throws IOException {
        this.lastAllocationId = in.readLong();
        this.tasks = in.readMap(StreamInput::readString, PersistentTask::new);
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeLong(this.lastAllocationId);
        out.writeMap(this.tasks, StreamOutput::writeString, (stream, value) -> value.writeTo(stream));
    }

    public static NamedDiff<MetaData.Custom> readDiffFrom(StreamInput in) throws IOException {
        return PersistentTasksCustomMetaData.readDiffFrom(MetaData.Custom.class, (String)TYPE, (StreamInput)in);
    }

    public long getLastAllocationId() {
        return this.lastAllocationId;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field("last_allocation_id", this.lastAllocationId);
        builder.startArray("tasks");
        for (PersistentTask<?> entry : this.tasks.values()) {
            entry.toXContent(builder, params);
        }
        builder.endArray();
        return builder;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(PersistentTasksCustomMetaData tasks) {
        return new Builder(tasks);
    }

    static {
        PERSISTENT_TASKS_PARSER.declareLong((rec$, x$0) -> ((Builder)rec$).setLastAllocationId(x$0), new ParseField("last_allocation_id", new String[0]));
        PERSISTENT_TASKS_PARSER.declareObjectArray((rec$, x$0) -> ((Builder)rec$).setTasks(x$0), PERSISTENT_TASK_PARSER, new ParseField("tasks", new String[0]));
        ObjectParser parser = new ObjectParser("named");
        parser.declareObject((rec$, x$0) -> ((TaskDescriptionBuilder)rec$).setParams(x$0), (p, c) -> (PersistentTaskParams)p.namedObject(PersistentTaskParams.class, c, null), new ParseField("params", new String[0]));
        parser.declareObject((rec$, x$0) -> ((TaskDescriptionBuilder)rec$).setStatus(x$0), (p, c) -> (Task.Status)p.namedObject(Task.Status.class, c, null), new ParseField("status", new String[0]));
        TASK_DESCRIPTION_PARSER = (p, c, name) -> (TaskDescriptionBuilder)parser.parse(p, new TaskDescriptionBuilder(name), (Object)name);
        ASSIGNMENT_PARSER.declareStringOrNull(ConstructingObjectParser.constructorArg(), new ParseField("executor_node", new String[0]));
        ASSIGNMENT_PARSER.declareStringOrNull(ConstructingObjectParser.constructorArg(), new ParseField("explanation", new String[0]));
        PERSISTENT_TASK_PARSER.declareString(TaskBuilder::setId, new ParseField("id", new String[0]));
        PERSISTENT_TASK_PARSER.declareString(TaskBuilder::setTaskName, new ParseField("name", new String[0]));
        PERSISTENT_TASK_PARSER.declareLong(TaskBuilder::setAllocationId, new ParseField("allocation_id", new String[0]));
        PERSISTENT_TASK_PARSER.declareNamedObjects((taskBuilder, objects) -> {
            if (objects.size() != 1) {
                throw new IllegalArgumentException("only one task description per task is allowed");
            }
            TaskDescriptionBuilder builder = (TaskDescriptionBuilder)objects.get(0);
            taskBuilder.setTaskName(builder.taskName);
            taskBuilder.setParams(builder.params);
            taskBuilder.setStatus(builder.status);
        }, TASK_DESCRIPTION_PARSER, new ParseField("task", new String[0]));
        PERSISTENT_TASK_PARSER.declareObject(TaskBuilder::setAssignment, ASSIGNMENT_PARSER, new ParseField("assignment", new String[0]));
        PERSISTENT_TASK_PARSER.declareLong(TaskBuilder::setAllocationIdOnLastStatusUpdate, new ParseField("allocation_id_on_last_status_update", new String[0]));
        INITIAL_ASSIGNMENT = new Assignment(null, "waiting for initial assignment");
    }

    public static class Builder {
        private final Map<String, PersistentTask<?>> tasks = new HashMap();
        private long lastAllocationId;
        private boolean changed;

        private Builder() {
        }

        private Builder(PersistentTasksCustomMetaData tasksInProgress) {
            if (tasksInProgress != null) {
                this.tasks.putAll(tasksInProgress.tasks);
                this.lastAllocationId = tasksInProgress.lastAllocationId;
            } else {
                this.lastAllocationId = 0L;
            }
        }

        public long getLastAllocationId() {
            return this.lastAllocationId;
        }

        private Builder setLastAllocationId(long currentId) {
            this.lastAllocationId = currentId;
            return this;
        }

        private <Params extends PersistentTaskParams> Builder setTasks(List<TaskBuilder<Params>> tasks) {
            for (TaskBuilder<Params> builder : tasks) {
                PersistentTask<Params> task = builder.build();
                this.tasks.put(task.getId(), task);
            }
            return this;
        }

        private long getNextAllocationId() {
            ++this.lastAllocationId;
            return this.lastAllocationId;
        }

        public <Params extends PersistentTaskParams> Builder addTask(String taskId, String taskName, Params params, Assignment assignment) {
            this.changed = true;
            PersistentTask<Params> previousTask = this.tasks.put(taskId, new PersistentTask<Params>(taskId, taskName, params, this.getNextAllocationId(), assignment));
            if (previousTask != null) {
                throw new ResourceAlreadyExistsException("Trying to override task with id {" + taskId + "}", new Object[0]);
            }
            return this;
        }

        public Builder reassignTask(String taskId, Assignment assignment) {
            PersistentTask<?> taskInProgress = this.tasks.get(taskId);
            if (taskInProgress == null) {
                throw new ResourceNotFoundException("cannot reassign task with id {" + taskId + "}, the task no longer exits", new Object[0]);
            }
            this.changed = true;
            this.tasks.put(taskId, new PersistentTask(taskInProgress, this.getNextAllocationId(), assignment));
            return this;
        }

        public Builder updateTaskStatus(String taskId, Task.Status status) {
            PersistentTask<?> taskInProgress = this.tasks.get(taskId);
            if (taskInProgress == null) {
                throw new ResourceNotFoundException("cannot update task with id {" + taskId + "}, the task no longer exits", new Object[0]);
            }
            this.changed = true;
            this.tasks.put(taskId, new PersistentTask(taskInProgress, status));
            return this;
        }

        public Builder removeTask(String taskId) {
            if (this.tasks.remove(taskId) == null) {
                throw new ResourceNotFoundException("cannot remove task with id {" + taskId + "}, the task no longer exits", new Object[0]);
            }
            this.changed = true;
            return this;
        }

        public Builder finishTask(String taskId) {
            PersistentTask<?> taskInProgress = this.tasks.get(taskId);
            if (taskInProgress == null) {
                throw new ResourceNotFoundException("cannot finish task with id {" + taskId + "}, the task no longer exits", new Object[0]);
            }
            this.changed = true;
            this.tasks.remove(taskId);
            return this;
        }

        public boolean hasTask(String taskId) {
            return this.tasks.containsKey(taskId);
        }

        public boolean hasTask(String taskId, long allocationId) {
            PersistentTask<?> taskInProgress = this.tasks.get(taskId);
            if (taskInProgress != null) {
                return taskInProgress.getAllocationId() == allocationId;
            }
            return false;
        }

        Set<String> getCurrentTaskIds() {
            return this.tasks.keySet();
        }

        public boolean isChanged() {
            return this.changed;
        }

        public PersistentTasksCustomMetaData build() {
            return new PersistentTasksCustomMetaData(this.lastAllocationId, Collections.unmodifiableMap(this.tasks));
        }
    }

    private static class TaskBuilder<Params extends PersistentTaskParams> {
        private String id;
        private long allocationId;
        private String taskName;
        private Params params;
        private Task.Status status;
        private Assignment assignment = INITIAL_ASSIGNMENT;
        private Long allocationIdOnLastStatusUpdate;

        private TaskBuilder() {
        }

        public TaskBuilder<Params> setId(String id) {
            this.id = id;
            return this;
        }

        public TaskBuilder<Params> setAllocationId(long allocationId) {
            this.allocationId = allocationId;
            return this;
        }

        public TaskBuilder<Params> setTaskName(String taskName) {
            this.taskName = taskName;
            return this;
        }

        public TaskBuilder<Params> setParams(Params params) {
            this.params = params;
            return this;
        }

        public TaskBuilder<Params> setStatus(Task.Status status) {
            this.status = status;
            return this;
        }

        public TaskBuilder<Params> setAssignment(Assignment assignment) {
            this.assignment = assignment;
            return this;
        }

        public TaskBuilder<Params> setAllocationIdOnLastStatusUpdate(Long allocationIdOnLastStatusUpdate) {
            this.allocationIdOnLastStatusUpdate = allocationIdOnLastStatusUpdate;
            return this;
        }

        public PersistentTask<Params> build() {
            return new PersistentTask(this.id, this.allocationId, this.taskName, (PersistentTaskParams)this.params, this.status, this.assignment, this.allocationIdOnLastStatusUpdate, null);
        }
    }

    public static class PersistentTask<P extends PersistentTaskParams>
    implements Writeable,
    ToXContentObject {
        private final String id;
        private final long allocationId;
        private final String taskName;
        @Nullable
        private final P params;
        @Nullable
        private final Task.Status status;
        private final Assignment assignment;
        @Nullable
        private final Long allocationIdOnLastStatusUpdate;

        public PersistentTask(String id, String taskName, P params, long allocationId, Assignment assignment) {
            this(id, allocationId, taskName, params, null, assignment, null);
        }

        public PersistentTask(PersistentTask<P> task, long allocationId, Assignment assignment) {
            this(task.id, allocationId, task.taskName, task.params, task.status, assignment, task.allocationId);
        }

        public PersistentTask(PersistentTask<P> task, Task.Status status) {
            this(task.id, task.allocationId, task.taskName, task.params, status, task.assignment, task.allocationId);
        }

        private PersistentTask(String id, long allocationId, String taskName, P params, Task.Status status, Assignment assignment, Long allocationIdOnLastStatusUpdate) {
            this.id = id;
            this.allocationId = allocationId;
            this.taskName = taskName;
            this.params = params;
            this.status = status;
            this.assignment = assignment;
            this.allocationIdOnLastStatusUpdate = allocationIdOnLastStatusUpdate;
            if (params != null && !params.getWriteableName().equals(taskName)) {
                throw new IllegalArgumentException("params have to have the same writeable name as task. params: " + params.getWriteableName() + " task: " + taskName);
            }
            if (status != null && !status.getWriteableName().equals(taskName)) {
                throw new IllegalArgumentException("status has to have the same writeable name as task. status: " + status.getWriteableName() + " task: " + taskName);
            }
        }

        public PersistentTask(StreamInput in) throws IOException {
            this.id = in.readString();
            this.allocationId = in.readLong();
            this.taskName = in.readString();
            this.params = (PersistentTaskParams)in.readOptionalNamedWriteable(PersistentTaskParams.class);
            this.status = (Task.Status)in.readOptionalNamedWriteable(Task.Status.class);
            this.assignment = new Assignment(in.readOptionalString(), in.readString());
            this.allocationIdOnLastStatusUpdate = in.readOptionalLong();
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.id);
            out.writeLong(this.allocationId);
            out.writeString(this.taskName);
            out.writeOptionalNamedWriteable(this.params);
            out.writeOptionalNamedWriteable((NamedWriteable)this.status);
            out.writeOptionalString(this.assignment.executorNode);
            out.writeString(this.assignment.explanation);
            out.writeOptionalLong(this.allocationIdOnLastStatusUpdate);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PersistentTask that = (PersistentTask)o;
            return Objects.equals(this.id, that.id) && this.allocationId == that.allocationId && Objects.equals(this.taskName, that.taskName) && Objects.equals(this.params, that.params) && Objects.equals(this.status, that.status) && Objects.equals(this.assignment, that.assignment) && Objects.equals(this.allocationIdOnLastStatusUpdate, that.allocationIdOnLastStatusUpdate);
        }

        public int hashCode() {
            return Objects.hash(this.id, this.allocationId, this.taskName, this.params, this.status, this.assignment, this.allocationIdOnLastStatusUpdate);
        }

        public String toString() {
            return Strings.toString((ToXContent)this);
        }

        public String getId() {
            return this.id;
        }

        public long getAllocationId() {
            return this.allocationId;
        }

        public String getTaskName() {
            return this.taskName;
        }

        @Nullable
        public P getParams() {
            return this.params;
        }

        @Nullable
        public String getExecutorNode() {
            return this.assignment.executorNode;
        }

        public Assignment getAssignment() {
            return this.assignment;
        }

        public boolean isAssigned() {
            return this.assignment.isAssigned();
        }

        public boolean needsReassignment(DiscoveryNodes nodes) {
            return !this.assignment.isAssigned() || !nodes.nodeExists(this.assignment.getExecutorNode());
        }

        @Nullable
        public Task.Status getStatus() {
            return this.status;
        }

        public boolean isCurrentStatus() {
            return this.allocationIdOnLastStatusUpdate != null && this.allocationIdOnLastStatusUpdate == this.allocationId;
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params xParams) throws IOException {
            builder.startObject();
            builder.field("id", this.id);
            builder.startObject("task");
            builder.startObject(this.taskName);
            if (this.params != null) {
                builder.field("params", this.params, xParams);
            }
            if (this.status != null) {
                builder.field("status", (ToXContent)this.status, xParams);
            }
            builder.endObject();
            builder.endObject();
            if (API_CONTEXT.equals(xParams.param("context_mode", API_CONTEXT))) {
                builder.field("allocation_id", this.allocationId);
                builder.startObject("assignment");
                builder.field("executor_node", this.assignment.executorNode);
                builder.field("explanation", this.assignment.explanation);
                builder.endObject();
                if (this.allocationIdOnLastStatusUpdate != null) {
                    builder.field("allocation_id_on_last_status_update", this.allocationIdOnLastStatusUpdate);
                }
            }
            builder.endObject();
            return builder;
        }

        public boolean isFragment() {
            return false;
        }

        /* synthetic */ PersistentTask(String x0, long x1, String x2, PersistentTaskParams x3, Task.Status x4, Assignment x5, Long x6, 1 x7) {
            this(x0, x1, x2, x3, x4, x5, x6);
        }
    }

    public static class Assignment {
        @Nullable
        private final String executorNode;
        private final String explanation;

        public Assignment(String executorNode, String explanation) {
            this.executorNode = executorNode;
            assert (explanation != null);
            this.explanation = explanation;
        }

        @Nullable
        public String getExecutorNode() {
            return this.executorNode;
        }

        public String getExplanation() {
            return this.explanation;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Assignment that = (Assignment)o;
            return Objects.equals(this.executorNode, that.executorNode) && Objects.equals(this.explanation, that.explanation);
        }

        public int hashCode() {
            return Objects.hash(this.executorNode, this.explanation);
        }

        public boolean isAssigned() {
            return this.executorNode != null;
        }

        public String toString() {
            return "node: [" + this.executorNode + "], explanation: [" + this.explanation + "]";
        }
    }

    private static class TaskDescriptionBuilder<Params extends PersistentTaskParams> {
        private final String taskName;
        private Params params;
        private Task.Status status;

        private TaskDescriptionBuilder(String taskName) {
            this.taskName = taskName;
        }

        private TaskDescriptionBuilder setParams(Params params) {
            this.params = params;
            return this;
        }

        private TaskDescriptionBuilder setStatus(Task.Status status) {
            this.status = status;
            return this;
        }
    }
}

