/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.notifications;

import java.io.IOException;
import java.util.Date;
import java.util.Objects;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.xpack.core.ml.job.config.Job;
import org.elasticsearch.xpack.core.ml.notifications.Level;
import org.elasticsearch.xpack.core.ml.utils.time.TimeUtils;

public class AuditMessage
implements ToXContentObject,
Writeable {
    public static final ParseField TYPE = new ParseField("audit_message", new String[0]);
    public static final ParseField MESSAGE = new ParseField("message", new String[0]);
    public static final ParseField LEVEL = new ParseField("level", new String[0]);
    public static final ParseField TIMESTAMP = new ParseField("timestamp", new String[0]);
    public static final ParseField NODE_NAME = new ParseField("node_name", new String[0]);
    public static final ObjectParser<AuditMessage, Void> PARSER = new ObjectParser(TYPE.getPreferredName(), AuditMessage::new);
    private String jobId;
    private String message;
    private Level level;
    private Date timestamp;
    private String nodeName;

    private AuditMessage() {
    }

    AuditMessage(String jobId, String message, Level level, String nodeName) {
        this.jobId = jobId;
        this.message = message;
        this.level = level;
        this.timestamp = new Date();
        this.nodeName = nodeName;
    }

    public AuditMessage(StreamInput in) throws IOException {
        this.jobId = in.readOptionalString();
        this.message = in.readOptionalString();
        if (in.readBoolean()) {
            this.level = Level.readFromStream(in);
        }
        if (in.readBoolean()) {
            this.timestamp = new Date(in.readLong());
        }
        this.nodeName = in.readOptionalString();
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeOptionalString(this.jobId);
        out.writeOptionalString(this.message);
        boolean hasLevel = this.level != null;
        out.writeBoolean(hasLevel);
        if (hasLevel) {
            this.level.writeTo(out);
        }
        boolean hasTimestamp = this.timestamp != null;
        out.writeBoolean(hasTimestamp);
        if (hasTimestamp) {
            out.writeLong(this.timestamp.getTime());
        }
        out.writeOptionalString(this.nodeName);
    }

    public String getJobId() {
        return this.jobId;
    }

    public void setJobId(String jobId) {
        this.jobId = jobId;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public Level getLevel() {
        return this.level;
    }

    public void setLevel(Level level) {
        this.level = level;
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(Date timestamp) {
        this.timestamp = timestamp;
    }

    public String getNodeName() {
        return this.nodeName;
    }

    public void setNodeName(String nodeName) {
        this.nodeName = nodeName;
    }

    public static AuditMessage newInfo(String jobId, String message, String nodeName) {
        return new AuditMessage(jobId, message, Level.INFO, nodeName);
    }

    public static AuditMessage newWarning(String jobId, String message, String nodeName) {
        return new AuditMessage(jobId, message, Level.WARNING, nodeName);
    }

    public static AuditMessage newActivity(String jobId, String message, String nodeName) {
        return new AuditMessage(jobId, message, Level.ACTIVITY, nodeName);
    }

    public static AuditMessage newError(String jobId, String message, String nodeName) {
        return new AuditMessage(jobId, message, Level.ERROR, nodeName);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.jobId != null) {
            builder.field(Job.ID.getPreferredName(), this.jobId);
        }
        if (this.message != null) {
            builder.field(MESSAGE.getPreferredName(), this.message);
        }
        if (this.level != null) {
            builder.field(LEVEL.getPreferredName(), (Object)this.level);
        }
        if (this.timestamp != null) {
            builder.field(TIMESTAMP.getPreferredName(), this.timestamp.getTime());
        }
        if (this.nodeName != null) {
            builder.field(NODE_NAME.getPreferredName(), this.nodeName);
        }
        builder.endObject();
        return builder;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.jobId, this.message, this.level, this.timestamp});
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AuditMessage other = (AuditMessage)obj;
        return Objects.equals(this.jobId, other.jobId) && Objects.equals(this.message, other.message) && Objects.equals((Object)this.level, (Object)other.level) && Objects.equals(this.timestamp, other.timestamp);
    }

    static {
        PARSER.declareString(AuditMessage::setJobId, Job.ID);
        PARSER.declareString(AuditMessage::setMessage, MESSAGE);
        PARSER.declareField(AuditMessage::setLevel, p -> {
            if (p.currentToken() == XContentParser.Token.VALUE_STRING) {
                return Level.fromString(p.text());
            }
            throw new IllegalArgumentException("Unsupported token [" + p.currentToken() + "]");
        }, LEVEL, ObjectParser.ValueType.STRING);
        PARSER.declareField(AuditMessage::setTimestamp, p -> {
            if (p.currentToken() == XContentParser.Token.VALUE_NUMBER) {
                return new Date(p.longValue());
            }
            if (p.currentToken() == XContentParser.Token.VALUE_STRING) {
                return new Date(TimeUtils.dateStringToEpoch(p.text()));
            }
            throw new IllegalArgumentException("unexpected token [" + p.currentToken() + "] for [" + TIMESTAMP.getPreferredName() + "]");
        }, TIMESTAMP, ObjectParser.ValueType.VALUE);
        PARSER.declareString(AuditMessage::setNodeName, NODE_NAME);
    }
}

