/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.job.results;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.ml.job.results.AnomalyRecord;

public class PartitionScore
implements ToXContentObject,
Writeable {
    public static final ParseField PARTITION_SCORE = new ParseField("partition_score", new String[0]);
    private final String partitionFieldValue;
    private final String partitionFieldName;
    private final double initialRecordScore;
    private double recordScore;
    private double probability;
    public static final ConstructingObjectParser<PartitionScore, Void> PARSER = new ConstructingObjectParser(PARTITION_SCORE.getPreferredName(), a -> new PartitionScore((String)a[0], (String)a[1], (Double)a[2], (Double)a[3], (Double)a[4]));

    public PartitionScore(String fieldName, String fieldValue, double initialRecordScore, double recordScore, double probability) {
        this.partitionFieldName = fieldName;
        this.partitionFieldValue = fieldValue;
        this.initialRecordScore = initialRecordScore;
        this.recordScore = recordScore;
        this.probability = probability;
    }

    public PartitionScore(StreamInput in) throws IOException {
        this.partitionFieldName = in.readString();
        this.partitionFieldValue = in.readString();
        this.initialRecordScore = in.readDouble();
        this.recordScore = in.readDouble();
        this.probability = in.readDouble();
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.partitionFieldName);
        out.writeString(this.partitionFieldValue);
        out.writeDouble(this.initialRecordScore);
        out.writeDouble(this.recordScore);
        out.writeDouble(this.probability);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(AnomalyRecord.PARTITION_FIELD_NAME.getPreferredName(), this.partitionFieldName);
        builder.field(AnomalyRecord.PARTITION_FIELD_VALUE.getPreferredName(), this.partitionFieldValue);
        builder.field(AnomalyRecord.INITIAL_RECORD_SCORE.getPreferredName(), this.initialRecordScore);
        builder.field(AnomalyRecord.RECORD_SCORE.getPreferredName(), this.recordScore);
        builder.field(AnomalyRecord.PROBABILITY.getPreferredName(), this.probability);
        builder.endObject();
        return builder;
    }

    public double getInitialRecordScore() {
        return this.initialRecordScore;
    }

    public double getRecordScore() {
        return this.recordScore;
    }

    public void setRecordScore(double recordScore) {
        this.recordScore = recordScore;
    }

    public String getPartitionFieldName() {
        return this.partitionFieldName;
    }

    public String getPartitionFieldValue() {
        return this.partitionFieldValue;
    }

    public double getProbability() {
        return this.probability;
    }

    public void setProbability(double probability) {
        this.probability = probability;
    }

    public int hashCode() {
        return Objects.hash(this.partitionFieldName, this.partitionFieldValue, this.probability, this.initialRecordScore, this.recordScore);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof PartitionScore)) {
            return false;
        }
        PartitionScore that = (PartitionScore)other;
        return Objects.equals(this.partitionFieldValue, that.partitionFieldValue) && Objects.equals(this.partitionFieldName, that.partitionFieldName) && this.probability == that.probability && this.initialRecordScore == that.initialRecordScore && this.recordScore == that.recordScore;
    }

    static {
        PARSER.declareString(ConstructingObjectParser.constructorArg(), AnomalyRecord.PARTITION_FIELD_NAME);
        PARSER.declareString(ConstructingObjectParser.constructorArg(), AnomalyRecord.PARTITION_FIELD_VALUE);
        PARSER.declareDouble(ConstructingObjectParser.constructorArg(), AnomalyRecord.INITIAL_RECORD_SCORE);
        PARSER.declareDouble(ConstructingObjectParser.constructorArg(), AnomalyRecord.RECORD_SCORE);
        PARSER.declareDouble(ConstructingObjectParser.constructorArg(), AnomalyRecord.PROBABILITY);
    }
}

