/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.job.results;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;

public class Influence
implements ToXContentObject,
Writeable {
    public static final ParseField INFLUENCER = new ParseField("influencer", new String[0]);
    public static final ParseField INFLUENCER_FIELD_NAME = new ParseField("influencer_field_name", new String[0]);
    public static final ParseField INFLUENCER_FIELD_VALUES = new ParseField("influencer_field_values", new String[0]);
    public static final ConstructingObjectParser<Influence, Void> PARSER = new ConstructingObjectParser(INFLUENCER.getPreferredName(), a -> new Influence((String)a[0], (List)a[1]));
    private String field;
    private List<String> fieldValues;

    public Influence(String field, List<String> fieldValues) {
        this.field = field;
        this.fieldValues = fieldValues;
    }

    public Influence(StreamInput in) throws IOException {
        this.field = in.readString();
        this.fieldValues = Arrays.asList(in.readStringArray());
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.field);
        out.writeStringArray(this.fieldValues.toArray(new String[this.fieldValues.size()]));
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(INFLUENCER_FIELD_NAME.getPreferredName(), this.field);
        builder.field(INFLUENCER_FIELD_VALUES.getPreferredName(), this.fieldValues);
        builder.endObject();
        return builder;
    }

    public String getInfluencerFieldName() {
        return this.field;
    }

    public List<String> getInfluencerFieldValues() {
        return this.fieldValues;
    }

    public int hashCode() {
        return Objects.hash(this.field, this.fieldValues);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Influence other = (Influence)obj;
        return Objects.equals(this.field, other.field) && Objects.equals(this.fieldValues, other.fieldValues);
    }

    static {
        PARSER.declareString(ConstructingObjectParser.constructorArg(), INFLUENCER_FIELD_NAME);
        PARSER.declareStringArray(ConstructingObjectParser.constructorArg(), INFLUENCER_FIELD_VALUES);
    }
}

