/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.job.process.autodetect.state;

import java.io.IOException;
import java.util.Date;
import java.util.Locale;
import java.util.Objects;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.xpack.core.ml.job.config.Job;
import org.elasticsearch.xpack.core.ml.job.results.Result;
import org.elasticsearch.xpack.core.ml.utils.time.TimeUtils;

public class ModelSizeStats
implements ToXContentObject,
Writeable {
    public static final String RESULT_TYPE_VALUE = "model_size_stats";
    public static final ParseField RESULT_TYPE_FIELD = new ParseField("model_size_stats", new String[0]);
    public static final ParseField MODEL_BYTES_FIELD = new ParseField("model_bytes", new String[0]);
    public static final ParseField TOTAL_BY_FIELD_COUNT_FIELD = new ParseField("total_by_field_count", new String[0]);
    public static final ParseField TOTAL_OVER_FIELD_COUNT_FIELD = new ParseField("total_over_field_count", new String[0]);
    public static final ParseField TOTAL_PARTITION_FIELD_COUNT_FIELD = new ParseField("total_partition_field_count", new String[0]);
    public static final ParseField BUCKET_ALLOCATION_FAILURES_COUNT_FIELD = new ParseField("bucket_allocation_failures_count", new String[0]);
    public static final ParseField MEMORY_STATUS_FIELD = new ParseField("memory_status", new String[0]);
    public static final ParseField LOG_TIME_FIELD = new ParseField("log_time", new String[0]);
    public static final ParseField TIMESTAMP_FIELD = new ParseField("timestamp", new String[0]);
    public static final ConstructingObjectParser<Builder, Void> PARSER = new ConstructingObjectParser(RESULT_TYPE_FIELD.getPreferredName(), a -> new Builder((String)a[0]));
    private final String jobId;
    private final long modelBytes;
    private final long totalByFieldCount;
    private final long totalOverFieldCount;
    private final long totalPartitionFieldCount;
    private final long bucketAllocationFailuresCount;
    private final MemoryStatus memoryStatus;
    private final Date timestamp;
    private final Date logTime;

    private ModelSizeStats(String jobId, long modelBytes, long totalByFieldCount, long totalOverFieldCount, long totalPartitionFieldCount, long bucketAllocationFailuresCount, MemoryStatus memoryStatus, Date timestamp, Date logTime) {
        this.jobId = jobId;
        this.modelBytes = modelBytes;
        this.totalByFieldCount = totalByFieldCount;
        this.totalOverFieldCount = totalOverFieldCount;
        this.totalPartitionFieldCount = totalPartitionFieldCount;
        this.bucketAllocationFailuresCount = bucketAllocationFailuresCount;
        this.memoryStatus = memoryStatus;
        this.timestamp = timestamp;
        this.logTime = logTime;
    }

    public ModelSizeStats(StreamInput in) throws IOException {
        this.jobId = in.readString();
        this.modelBytes = in.readVLong();
        this.totalByFieldCount = in.readVLong();
        this.totalOverFieldCount = in.readVLong();
        this.totalPartitionFieldCount = in.readVLong();
        this.bucketAllocationFailuresCount = in.readVLong();
        this.memoryStatus = MemoryStatus.readFromStream(in);
        this.logTime = new Date(in.readVLong());
        this.timestamp = in.readBoolean() ? new Date(in.readVLong()) : null;
    }

    public String getId() {
        return ModelSizeStats.documentIdPrefix(this.jobId) + this.logTime.getTime();
    }

    public static String documentIdPrefix(String jobId) {
        return jobId + "_model_size_stats_";
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.jobId);
        out.writeVLong(this.modelBytes);
        out.writeVLong(this.totalByFieldCount);
        out.writeVLong(this.totalOverFieldCount);
        out.writeVLong(this.totalPartitionFieldCount);
        out.writeVLong(this.bucketAllocationFailuresCount);
        this.memoryStatus.writeTo(out);
        out.writeVLong(this.logTime.getTime());
        boolean hasTimestamp = this.timestamp != null;
        out.writeBoolean(hasTimestamp);
        if (hasTimestamp) {
            out.writeVLong(this.timestamp.getTime());
        }
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        this.doXContentBody(builder);
        builder.endObject();
        return builder;
    }

    public XContentBuilder doXContentBody(XContentBuilder builder) throws IOException {
        builder.field(Job.ID.getPreferredName(), this.jobId);
        builder.field(Result.RESULT_TYPE.getPreferredName(), RESULT_TYPE_VALUE);
        builder.field(MODEL_BYTES_FIELD.getPreferredName(), this.modelBytes);
        builder.field(TOTAL_BY_FIELD_COUNT_FIELD.getPreferredName(), this.totalByFieldCount);
        builder.field(TOTAL_OVER_FIELD_COUNT_FIELD.getPreferredName(), this.totalOverFieldCount);
        builder.field(TOTAL_PARTITION_FIELD_COUNT_FIELD.getPreferredName(), this.totalPartitionFieldCount);
        builder.field(BUCKET_ALLOCATION_FAILURES_COUNT_FIELD.getPreferredName(), this.bucketAllocationFailuresCount);
        builder.field(MEMORY_STATUS_FIELD.getPreferredName(), (Object)this.memoryStatus);
        builder.dateField(LOG_TIME_FIELD.getPreferredName(), LOG_TIME_FIELD.getPreferredName() + "_string", this.logTime.getTime());
        if (this.timestamp != null) {
            builder.dateField(TIMESTAMP_FIELD.getPreferredName(), TIMESTAMP_FIELD.getPreferredName() + "_string", this.timestamp.getTime());
        }
        return builder;
    }

    public String getJobId() {
        return this.jobId;
    }

    public long getModelBytes() {
        return this.modelBytes;
    }

    public long getTotalByFieldCount() {
        return this.totalByFieldCount;
    }

    public long getTotalPartitionFieldCount() {
        return this.totalPartitionFieldCount;
    }

    public long getTotalOverFieldCount() {
        return this.totalOverFieldCount;
    }

    public long getBucketAllocationFailuresCount() {
        return this.bucketAllocationFailuresCount;
    }

    public MemoryStatus getMemoryStatus() {
        return this.memoryStatus;
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public Date getLogTime() {
        return this.logTime;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.jobId, this.modelBytes, this.totalByFieldCount, this.totalOverFieldCount, this.totalPartitionFieldCount, this.bucketAllocationFailuresCount, this.memoryStatus, this.timestamp, this.logTime});
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ModelSizeStats)) {
            return false;
        }
        ModelSizeStats that = (ModelSizeStats)other;
        return this.modelBytes == that.modelBytes && this.totalByFieldCount == that.totalByFieldCount && this.totalOverFieldCount == that.totalOverFieldCount && this.totalPartitionFieldCount == that.totalPartitionFieldCount && this.bucketAllocationFailuresCount == that.bucketAllocationFailuresCount && Objects.equals((Object)this.memoryStatus, (Object)that.memoryStatus) && Objects.equals(this.timestamp, that.timestamp) && Objects.equals(this.logTime, that.logTime) && Objects.equals(this.jobId, that.jobId);
    }

    static {
        PARSER.declareString(ConstructingObjectParser.constructorArg(), Job.ID);
        PARSER.declareString((modelSizeStat, s) -> {}, Result.RESULT_TYPE);
        PARSER.declareLong(Builder::setModelBytes, MODEL_BYTES_FIELD);
        PARSER.declareLong(Builder::setBucketAllocationFailuresCount, BUCKET_ALLOCATION_FAILURES_COUNT_FIELD);
        PARSER.declareLong(Builder::setTotalByFieldCount, TOTAL_BY_FIELD_COUNT_FIELD);
        PARSER.declareLong(Builder::setTotalOverFieldCount, TOTAL_OVER_FIELD_COUNT_FIELD);
        PARSER.declareLong(Builder::setTotalPartitionFieldCount, TOTAL_PARTITION_FIELD_COUNT_FIELD);
        PARSER.declareField(Builder::setLogTime, p -> {
            if (p.currentToken() == XContentParser.Token.VALUE_NUMBER) {
                return new Date(p.longValue());
            }
            if (p.currentToken() == XContentParser.Token.VALUE_STRING) {
                return new Date(TimeUtils.dateStringToEpoch(p.text()));
            }
            throw new IllegalArgumentException("unexpected token [" + p.currentToken() + "] for [" + LOG_TIME_FIELD.getPreferredName() + "]");
        }, LOG_TIME_FIELD, ObjectParser.ValueType.VALUE);
        PARSER.declareField(Builder::setTimestamp, p -> {
            if (p.currentToken() == XContentParser.Token.VALUE_NUMBER) {
                return new Date(p.longValue());
            }
            if (p.currentToken() == XContentParser.Token.VALUE_STRING) {
                return new Date(TimeUtils.dateStringToEpoch(p.text()));
            }
            throw new IllegalArgumentException("unexpected token [" + p.currentToken() + "] for [" + TIMESTAMP_FIELD.getPreferredName() + "]");
        }, TIMESTAMP_FIELD, ObjectParser.ValueType.VALUE);
        PARSER.declareField(Builder::setMemoryStatus, p -> MemoryStatus.fromString(p.text()), MEMORY_STATUS_FIELD, ObjectParser.ValueType.STRING);
    }

    public static class Builder {
        private final String jobId;
        private long modelBytes;
        private long totalByFieldCount;
        private long totalOverFieldCount;
        private long totalPartitionFieldCount;
        private long bucketAllocationFailuresCount;
        private MemoryStatus memoryStatus;
        private Date timestamp;
        private Date logTime;

        public Builder(String jobId) {
            this.jobId = jobId;
            this.memoryStatus = MemoryStatus.OK;
            this.logTime = new Date();
        }

        public Builder(ModelSizeStats modelSizeStats) {
            this.jobId = modelSizeStats.jobId;
            this.modelBytes = modelSizeStats.modelBytes;
            this.totalByFieldCount = modelSizeStats.totalByFieldCount;
            this.totalOverFieldCount = modelSizeStats.totalOverFieldCount;
            this.totalPartitionFieldCount = modelSizeStats.totalPartitionFieldCount;
            this.bucketAllocationFailuresCount = modelSizeStats.bucketAllocationFailuresCount;
            this.memoryStatus = modelSizeStats.memoryStatus;
            this.timestamp = modelSizeStats.timestamp;
            this.logTime = modelSizeStats.logTime;
        }

        public Builder setModelBytes(long modelBytes) {
            this.modelBytes = modelBytes;
            return this;
        }

        public Builder setTotalByFieldCount(long totalByFieldCount) {
            this.totalByFieldCount = totalByFieldCount;
            return this;
        }

        public Builder setTotalPartitionFieldCount(long totalPartitionFieldCount) {
            this.totalPartitionFieldCount = totalPartitionFieldCount;
            return this;
        }

        public Builder setTotalOverFieldCount(long totalOverFieldCount) {
            this.totalOverFieldCount = totalOverFieldCount;
            return this;
        }

        public Builder setBucketAllocationFailuresCount(long bucketAllocationFailuresCount) {
            this.bucketAllocationFailuresCount = bucketAllocationFailuresCount;
            return this;
        }

        public Builder setMemoryStatus(MemoryStatus memoryStatus) {
            Objects.requireNonNull(memoryStatus, "[" + MEMORY_STATUS_FIELD.getPreferredName() + "] must not be null");
            this.memoryStatus = memoryStatus;
            return this;
        }

        public Builder setTimestamp(Date timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public Builder setLogTime(Date logTime) {
            this.logTime = logTime;
            return this;
        }

        public ModelSizeStats build() {
            return new ModelSizeStats(this.jobId, this.modelBytes, this.totalByFieldCount, this.totalOverFieldCount, this.totalPartitionFieldCount, this.bucketAllocationFailuresCount, this.memoryStatus, this.timestamp, this.logTime);
        }
    }

    public static enum MemoryStatus implements Writeable
    {
        OK,
        SOFT_LIMIT,
        HARD_LIMIT;


        public static MemoryStatus fromString(String statusName) {
            return MemoryStatus.valueOf(statusName.trim().toUpperCase(Locale.ROOT));
        }

        public static MemoryStatus readFromStream(StreamInput in) throws IOException {
            return (MemoryStatus)in.readEnum(MemoryStatus.class);
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeEnum((Enum)this);
        }

        public String toString() {
            return this.name().toLowerCase(Locale.ROOT);
        }
    }
}

