/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.job.persistence;

import java.util.ArrayList;
import java.util.List;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.RangeQueryBuilder;
import org.elasticsearch.index.query.TermsQueryBuilder;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.xpack.core.ml.calendars.Calendar;
import org.elasticsearch.xpack.core.ml.calendars.ScheduledEvent;

public class ScheduledEventsQueryBuilder {
    public static final int DEFAULT_SIZE = 1000;
    private Integer from = 0;
    private Integer size = 1000;
    private List<String> calendarIds;
    private String start;
    private String end;

    public ScheduledEventsQueryBuilder calendarIds(List<String> calendarIds) {
        this.calendarIds = calendarIds;
        return this;
    }

    public ScheduledEventsQueryBuilder start(String start) {
        this.start = start;
        return this;
    }

    public ScheduledEventsQueryBuilder start(long start) {
        this.start = Long.toString(start);
        return this;
    }

    public ScheduledEventsQueryBuilder end(String end) {
        this.end = end;
        return this;
    }

    public ScheduledEventsQueryBuilder from(Integer from) {
        this.from = from;
        return this;
    }

    public ScheduledEventsQueryBuilder size(Integer size) {
        this.size = size;
        return this;
    }

    public SearchSourceBuilder build() {
        ArrayList<Object> queries = new ArrayList<Object>();
        if (this.start != null) {
            RangeQueryBuilder startQuery = QueryBuilders.rangeQuery((String)ScheduledEvent.END_TIME.getPreferredName());
            startQuery.gt((Object)this.start);
            queries.add(startQuery);
        }
        if (this.end != null) {
            RangeQueryBuilder endQuery = QueryBuilders.rangeQuery((String)ScheduledEvent.START_TIME.getPreferredName());
            endQuery.lt((Object)this.end);
            queries.add(endQuery);
        }
        if (this.calendarIds != null && !this.calendarIds.isEmpty()) {
            queries.add(new TermsQueryBuilder(Calendar.ID.getPreferredName(), this.calendarIds));
        }
        TermsQueryBuilder typeQuery = new TermsQueryBuilder(ScheduledEvent.TYPE.getPreferredName(), new String[]{"scheduled_event"});
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        searchSourceBuilder.sort(ScheduledEvent.START_TIME.getPreferredName());
        if (this.from != null) {
            searchSourceBuilder.from(this.from.intValue());
        }
        if (this.size != null) {
            searchSourceBuilder.size(this.size.intValue());
        }
        if (queries.isEmpty()) {
            searchSourceBuilder.query((QueryBuilder)typeQuery);
        } else {
            BoolQueryBuilder boolQueryBuilder = new BoolQueryBuilder();
            boolQueryBuilder.filter((QueryBuilder)typeQuery);
            for (QueryBuilder queryBuilder : queries) {
                boolQueryBuilder.filter(queryBuilder);
            }
            searchSourceBuilder.query((QueryBuilder)boolQueryBuilder);
        }
        return searchSourceBuilder;
    }
}

