/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.job.persistence;

import java.util.ArrayList;
import java.util.List;
import org.elasticsearch.common.Strings;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.RangeQueryBuilder;
import org.elasticsearch.index.query.TermQueryBuilder;
import org.elasticsearch.xpack.core.ml.job.results.Result;

public class ResultsFilterBuilder {
    private final List<QueryBuilder> queries = new ArrayList<QueryBuilder>();

    public ResultsFilterBuilder() {
    }

    public ResultsFilterBuilder(QueryBuilder queryBuilder) {
        this();
        this.queries.add(queryBuilder);
    }

    public ResultsFilterBuilder timeRange(String field, Object start, Object end) {
        if (start != null || end != null) {
            RangeQueryBuilder timeRange = QueryBuilders.rangeQuery((String)field);
            if (start != null) {
                timeRange.gte(start);
            }
            if (end != null) {
                timeRange.lt(end);
            }
            this.addQuery((QueryBuilder)timeRange);
        }
        return this;
    }

    public ResultsFilterBuilder timeRange(String field, String timestamp) {
        this.addQuery((QueryBuilder)QueryBuilders.matchQuery((String)field, (Object)timestamp));
        return this;
    }

    public ResultsFilterBuilder score(String fieldName, double threshold) {
        if (threshold > 0.0) {
            RangeQueryBuilder scoreFilter = QueryBuilders.rangeQuery((String)fieldName);
            scoreFilter.gte((Object)threshold);
            this.addQuery((QueryBuilder)scoreFilter);
        }
        return this;
    }

    public ResultsFilterBuilder interim(boolean includeInterim) {
        if (includeInterim) {
            return this;
        }
        TermQueryBuilder interimFilter = QueryBuilders.termQuery((String)Result.IS_INTERIM.getPreferredName(), (boolean)true);
        BoolQueryBuilder notInterimFilter = QueryBuilders.boolQuery().mustNot((QueryBuilder)interimFilter);
        this.addQuery((QueryBuilder)notInterimFilter);
        return this;
    }

    public ResultsFilterBuilder term(String fieldName, String fieldValue) {
        if (Strings.isNullOrEmpty((String)fieldName) || Strings.isNullOrEmpty((String)fieldValue)) {
            return this;
        }
        TermQueryBuilder termQueryBuilder = QueryBuilders.termQuery((String)fieldName, (String)fieldValue);
        this.addQuery((QueryBuilder)termQueryBuilder);
        return this;
    }

    public ResultsFilterBuilder resultType(String resultType) {
        return this.term(Result.RESULT_TYPE.getPreferredName(), resultType);
    }

    private void addQuery(QueryBuilder fb) {
        this.queries.add(fb);
    }

    public QueryBuilder build() {
        if (this.queries.isEmpty()) {
            return QueryBuilders.matchAllQuery();
        }
        if (this.queries.size() == 1) {
            return this.queries.get(0);
        }
        BoolQueryBuilder boolQueryBuilder = new BoolQueryBuilder();
        for (QueryBuilder query : this.queries) {
            boolQueryBuilder.filter(query);
        }
        return boolQueryBuilder;
    }
}

