/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.job.persistence;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.TermsQueryBuilder;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.xpack.core.ml.action.util.PageParams;
import org.elasticsearch.xpack.core.ml.calendars.Calendar;

public class CalendarQueryBuilder {
    private PageParams pageParams = new PageParams(0, 10000);
    private String jobId;
    private List<String> jobGroups = Collections.emptyList();
    private boolean sort = false;

    public CalendarQueryBuilder pageParams(PageParams params) {
        this.pageParams = params;
        return this;
    }

    public CalendarQueryBuilder jobId(String jobId) {
        this.jobId = jobId;
        return this;
    }

    public CalendarQueryBuilder jobGroups(List<String> jobGroups) {
        this.jobGroups = jobGroups;
        return this;
    }

    public CalendarQueryBuilder sort(boolean sort) {
        this.sort = sort;
        return this;
    }

    public SearchSourceBuilder build() {
        ArrayList<String> jobIdAndGroups = new ArrayList<String>(this.jobGroups);
        if (this.jobId != null) {
            jobIdAndGroups.add(this.jobId);
        }
        Object qb = !jobIdAndGroups.isEmpty() ? new BoolQueryBuilder().filter((QueryBuilder)new TermsQueryBuilder(Calendar.TYPE.getPreferredName(), new String[]{"calendar"})).filter((QueryBuilder)new TermsQueryBuilder(Calendar.JOB_IDS.getPreferredName(), jobIdAndGroups)) : new TermsQueryBuilder(Calendar.TYPE.getPreferredName(), new String[]{"calendar"});
        SearchSourceBuilder sourceBuilder = new SearchSourceBuilder().query((QueryBuilder)qb);
        if (this.sort) {
            sourceBuilder.sort(Calendar.ID.getPreferredName());
        }
        sourceBuilder.from(this.pageParams.getFrom()).size(this.pageParams.getSize());
        return sourceBuilder;
    }
}

