/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.job.persistence;

import org.elasticsearch.client.Client;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.TermsQueryBuilder;
import org.elasticsearch.xpack.core.ml.job.persistence.AnomalyDetectorsIndex;
import org.elasticsearch.xpack.core.ml.job.persistence.BatchedDocumentsIterator;
import org.elasticsearch.xpack.core.ml.job.persistence.ResultsFilterBuilder;
import org.elasticsearch.xpack.core.ml.job.results.Result;

public abstract class BatchedResultsIterator<T>
extends BatchedDocumentsIterator<Result<T>> {
    private final ResultsFilterBuilder filterBuilder;

    public BatchedResultsIterator(Client client, String jobId, String resultType) {
        super(client, AnomalyDetectorsIndex.jobResultsAliasedName(jobId));
        this.filterBuilder = new ResultsFilterBuilder((QueryBuilder)new TermsQueryBuilder(Result.RESULT_TYPE.getPreferredName(), new String[]{resultType}));
    }

    public BatchedResultsIterator<T> timeRange(long startEpochMs, long endEpochMs) {
        this.filterBuilder.timeRange(Result.TIMESTAMP.getPreferredName(), startEpochMs, endEpochMs);
        return this;
    }

    public BatchedResultsIterator<T> includeInterim(boolean includeInterim) {
        this.filterBuilder.interim(includeInterim);
        return this;
    }

    @Override
    protected final QueryBuilder getQuery() {
        return this.filterBuilder.build();
    }
}

