/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.job.config;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;

public class MlFilter
implements ToXContentObject,
Writeable {
    public static final String DOCUMENT_ID_PREFIX = "filter_";
    public static final String FILTER_TYPE = "filter";
    public static final ParseField TYPE = new ParseField("type", new String[0]);
    public static final ParseField ID = new ParseField("filter_id", new String[0]);
    public static final ParseField ITEMS = new ParseField("items", new String[0]);
    public static final ParseField RESULTS_FIELD = new ParseField("filters", new String[0]);
    public static final ObjectParser<Builder, Void> PARSER = new ObjectParser(TYPE.getPreferredName(), () -> new Builder());
    private final String id;
    private final List<String> items;

    public MlFilter(String id, List<String> items) {
        this.id = Objects.requireNonNull(id, ID.getPreferredName() + " must not be null");
        this.items = Objects.requireNonNull(items, ITEMS.getPreferredName() + " must not be null");
    }

    public MlFilter(StreamInput in) throws IOException {
        this.id = in.readString();
        this.items = Arrays.asList(in.readStringArray());
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.id);
        out.writeStringArray(this.items.toArray(new String[this.items.size()]));
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(ID.getPreferredName(), this.id);
        builder.field(ITEMS.getPreferredName(), this.items);
        if (params.paramAsBoolean("include_type", false)) {
            builder.field(TYPE.getPreferredName(), FILTER_TYPE);
        }
        builder.endObject();
        return builder;
    }

    public String getId() {
        return this.id;
    }

    public List<String> getItems() {
        return new ArrayList<String>(this.items);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof MlFilter)) {
            return false;
        }
        MlFilter other = (MlFilter)obj;
        return this.id.equals(other.id) && this.items.equals(other.items);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.items);
    }

    public String documentId() {
        return MlFilter.documentId(this.id);
    }

    public static String documentId(String filterId) {
        return DOCUMENT_ID_PREFIX + filterId;
    }

    static {
        PARSER.declareString((builder, s) -> {}, TYPE);
        PARSER.declareString(Builder::setId, ID);
        PARSER.declareStringArray(Builder::setItems, ITEMS);
    }

    public static class Builder {
        private String id;
        private List<String> items = Collections.emptyList();

        public Builder setId(String id) {
            this.id = id;
            return this;
        }

        private Builder() {
        }

        @Nullable
        public String getId() {
            return this.id;
        }

        public Builder setItems(List<String> items) {
            this.items = items;
            return this;
        }

        public MlFilter build() {
            return new MlFilter(this.id, this.items);
        }
    }
}

