/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.job.config;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.xpack.core.ml.job.config.JobState;
import org.elasticsearch.xpack.core.persistent.PersistentTasksCustomMetaData;

public class JobTaskStatus
implements Task.Status {
    public static final String NAME = "xpack/ml/job";
    private static ParseField STATE = new ParseField("state", new String[0]);
    private static ParseField ALLOCATION_ID = new ParseField("allocation_id", new String[0]);
    private static final ConstructingObjectParser<JobTaskStatus, Void> PARSER = new ConstructingObjectParser("xpack/ml/job", args -> new JobTaskStatus((JobState)((Object)((Object)args[0])), (Long)args[1]));
    private final JobState state;
    private final long allocationId;

    public static JobTaskStatus fromXContent(XContentParser parser) {
        try {
            return (JobTaskStatus)PARSER.parse(parser, null);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public JobTaskStatus(JobState state, long allocationId) {
        this.state = Objects.requireNonNull(state);
        this.allocationId = allocationId;
    }

    public JobTaskStatus(StreamInput in) throws IOException {
        this.state = JobState.fromStream(in);
        this.allocationId = in.readLong();
    }

    public JobState getState() {
        return this.state;
    }

    public boolean isStatusStale(PersistentTasksCustomMetaData.PersistentTask<?> task) {
        return this.allocationId != task.getAllocationId();
    }

    public String getWriteableName() {
        return NAME;
    }

    public void writeTo(StreamOutput out) throws IOException {
        this.state.writeTo(out);
        out.writeLong(this.allocationId);
    }

    public boolean isFragment() {
        return false;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(STATE.getPreferredName(), this.state.value());
        builder.field(ALLOCATION_ID.getPreferredName(), this.allocationId);
        builder.endObject();
        return builder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JobTaskStatus that = (JobTaskStatus)o;
        return this.state == that.state && Objects.equals(this.allocationId, that.allocationId);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.state, this.allocationId});
    }

    static {
        PARSER.declareField(ConstructingObjectParser.constructorArg(), p -> {
            if (p.currentToken() == XContentParser.Token.VALUE_STRING) {
                return JobState.fromString(p.text());
            }
            throw new IllegalArgumentException("Unsupported token [" + p.currentToken() + "]");
        }, STATE, ObjectParser.ValueType.STRING);
        PARSER.declareLong(ConstructingObjectParser.constructorArg(), ALLOCATION_ID);
    }
}

