/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.job.config;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.elasticsearch.Version;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.xpack.core.ml.MlParserType;
import org.elasticsearch.xpack.core.ml.job.config.Connective;
import org.elasticsearch.xpack.core.ml.job.config.RuleAction;
import org.elasticsearch.xpack.core.ml.job.config.RuleCondition;
import org.elasticsearch.xpack.core.ml.job.config.RuleConditionType;
import org.elasticsearch.xpack.core.ml.job.messages.Messages;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;

public class DetectionRule
implements ToXContentObject,
Writeable {
    public static final ParseField DETECTION_RULE_FIELD = new ParseField("detection_rule", new String[0]);
    public static final ParseField ACTIONS_FIELD = new ParseField("actions", new String[]{"rule_action"});
    public static final ParseField TARGET_FIELD_NAME_FIELD = new ParseField("target_field_name", new String[0]);
    public static final ParseField TARGET_FIELD_VALUE_FIELD = new ParseField("target_field_value", new String[0]);
    public static final ParseField CONDITIONS_CONNECTIVE_FIELD = new ParseField("conditions_connective", new String[0]);
    public static final ParseField CONDITIONS_FIELD = new ParseField("conditions", new String[]{"rule_conditions"});
    public static final ObjectParser<Builder, Void> METADATA_PARSER = new ObjectParser(DETECTION_RULE_FIELD.getPreferredName(), true, () -> new Builder());
    public static final ObjectParser<Builder, Void> CONFIG_PARSER = new ObjectParser(DETECTION_RULE_FIELD.getPreferredName(), false, () -> new Builder());
    public static final Map<MlParserType, ObjectParser<Builder, Void>> PARSERS = new EnumMap<MlParserType, ObjectParser<Builder, Void>>(MlParserType.class);
    private final EnumSet<RuleAction> actions;
    private final String targetFieldName;
    private final String targetFieldValue;
    private final Connective conditionsConnective;
    private final List<RuleCondition> conditions;

    private DetectionRule(EnumSet<RuleAction> actions, @Nullable String targetFieldName, @Nullable String targetFieldValue, Connective conditionsConnective, List<RuleCondition> conditions) {
        this.actions = Objects.requireNonNull(actions);
        this.targetFieldName = targetFieldName;
        this.targetFieldValue = targetFieldValue;
        this.conditionsConnective = Objects.requireNonNull(conditionsConnective);
        this.conditions = Collections.unmodifiableList(conditions);
    }

    public DetectionRule(StreamInput in) throws IOException {
        int i;
        this.actions = EnumSet.noneOf(RuleAction.class);
        if (in.getVersion().before(Version.V_6_2_0)) {
            this.actions.add(RuleAction.readFromStream(in));
        } else {
            int actionsCount = in.readVInt();
            for (i = 0; i < actionsCount; ++i) {
                this.actions.add(RuleAction.readFromStream(in));
            }
        }
        this.conditionsConnective = Connective.readFromStream(in);
        int size = in.readVInt();
        this.conditions = new ArrayList<RuleCondition>(size);
        for (i = 0; i < size; ++i) {
            this.conditions.add(new RuleCondition(in));
        }
        this.targetFieldName = in.readOptionalString();
        this.targetFieldValue = in.readOptionalString();
    }

    public void writeTo(StreamOutput out) throws IOException {
        if (out.getVersion().before(Version.V_6_2_0)) {
            RuleAction.FILTER_RESULTS.writeTo(out);
        } else {
            out.writeVInt(this.actions.size());
            for (RuleAction action : this.actions) {
                action.writeTo(out);
            }
        }
        this.conditionsConnective.writeTo(out);
        out.writeVInt(this.conditions.size());
        for (RuleCondition condition : this.conditions) {
            condition.writeTo(out);
        }
        out.writeOptionalString(this.targetFieldName);
        out.writeOptionalString(this.targetFieldValue);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(ACTIONS_FIELD.getPreferredName(), this.actions);
        builder.field(CONDITIONS_CONNECTIVE_FIELD.getPreferredName(), (Object)this.conditionsConnective);
        builder.field(CONDITIONS_FIELD.getPreferredName(), this.conditions);
        if (this.targetFieldName != null) {
            builder.field(TARGET_FIELD_NAME_FIELD.getPreferredName(), this.targetFieldName);
        }
        if (this.targetFieldValue != null) {
            builder.field(TARGET_FIELD_VALUE_FIELD.getPreferredName(), this.targetFieldValue);
        }
        builder.endObject();
        return builder;
    }

    public EnumSet<RuleAction> getActions() {
        return this.actions;
    }

    @Nullable
    public String getTargetFieldName() {
        return this.targetFieldName;
    }

    @Nullable
    public String getTargetFieldValue() {
        return this.targetFieldValue;
    }

    public Connective getConditionsConnective() {
        return this.conditionsConnective;
    }

    public List<RuleCondition> getConditions() {
        return this.conditions;
    }

    public Set<String> extractReferencedFilters() {
        return this.conditions.stream().map(RuleCondition::getFilterId).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof DetectionRule)) {
            return false;
        }
        DetectionRule other = (DetectionRule)obj;
        return Objects.equals(this.actions, other.actions) && Objects.equals(this.targetFieldName, other.targetFieldName) && Objects.equals(this.targetFieldValue, other.targetFieldValue) && Objects.equals((Object)this.conditionsConnective, (Object)other.conditionsConnective) && Objects.equals(this.conditions, other.conditions);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.actions, this.targetFieldName, this.targetFieldValue, this.conditionsConnective, this.conditions});
    }

    static {
        PARSERS.put(MlParserType.METADATA, METADATA_PARSER);
        PARSERS.put(MlParserType.CONFIG, CONFIG_PARSER);
        for (MlParserType parserType : MlParserType.values()) {
            ObjectParser<Builder, Void> parser = PARSERS.get((Object)parserType);
            assert (parser != null);
            parser.declareStringArray(Builder::setActions, ACTIONS_FIELD);
            parser.declareString(Builder::setTargetFieldName, TARGET_FIELD_NAME_FIELD);
            parser.declareString(Builder::setTargetFieldValue, TARGET_FIELD_VALUE_FIELD);
            parser.declareField(Builder::setConditionsConnective, p -> {
                if (p.currentToken() == XContentParser.Token.VALUE_STRING) {
                    return Connective.fromString(p.text());
                }
                throw new IllegalArgumentException("Unsupported token [" + p.currentToken() + "]");
            }, CONDITIONS_CONNECTIVE_FIELD, ObjectParser.ValueType.STRING);
            parser.declareObjectArray(Builder::setConditions, (p, c) -> (RuleCondition)RuleCondition.PARSERS.get((Object)parserType).apply(p, c), CONDITIONS_FIELD);
        }
    }

    public static class Builder {
        private EnumSet<RuleAction> actions = EnumSet.of(RuleAction.FILTER_RESULTS);
        private String targetFieldName;
        private String targetFieldValue;
        private Connective conditionsConnective = Connective.OR;
        private List<RuleCondition> conditions = Collections.emptyList();

        public Builder(List<RuleCondition> conditions) {
            this.conditions = ExceptionsHelper.requireNonNull(conditions, CONDITIONS_FIELD.getPreferredName());
        }

        private Builder() {
        }

        public Builder setActions(List<String> actions) {
            this.actions.clear();
            actions.stream().map(RuleAction::fromString).forEach(this.actions::add);
            return this;
        }

        public Builder setActions(EnumSet<RuleAction> actions) {
            this.actions = Objects.requireNonNull(actions, ACTIONS_FIELD.getPreferredName());
            return this;
        }

        public Builder setActions(RuleAction ... actions) {
            this.actions.clear();
            Arrays.stream(actions).forEach(this.actions::add);
            return this;
        }

        public Builder setTargetFieldName(String targetFieldName) {
            this.targetFieldName = targetFieldName;
            return this;
        }

        public Builder setTargetFieldValue(String targetFieldValue) {
            this.targetFieldValue = targetFieldValue;
            return this;
        }

        public Builder setConditionsConnective(Connective connective) {
            this.conditionsConnective = ExceptionsHelper.requireNonNull(connective, CONDITIONS_CONNECTIVE_FIELD.getPreferredName());
            return this;
        }

        public Builder setConditions(List<RuleCondition> conditions) {
            this.conditions = ExceptionsHelper.requireNonNull(conditions, CONDITIONS_FIELD.getPreferredName());
            return this;
        }

        public DetectionRule build() {
            if (this.targetFieldValue != null && this.targetFieldName == null) {
                String msg = Messages.getMessage("Invalid detector rule: missing target_field_name where target_field_value ''{0}'' is set", this.targetFieldValue);
                throw ExceptionsHelper.badRequestException(msg, new Object[0]);
            }
            if (this.conditions == null || this.conditions.isEmpty()) {
                String msg = Messages.getMessage("Invalid detector rule: at least one rule_condition is required");
                throw ExceptionsHelper.badRequestException(msg, new Object[0]);
            }
            for (RuleCondition condition : this.conditions) {
                if (condition.getType() != RuleConditionType.CATEGORICAL || this.targetFieldName == null) continue;
                String msg = Messages.getMessage("Invalid detector rule: a categorical rule_condition does not support {0}", TARGET_FIELD_NAME_FIELD.getPreferredName());
                throw ExceptionsHelper.badRequestException(msg, new Object[0]);
            }
            return new DetectionRule(this.actions, this.targetFieldName, this.targetFieldValue, this.conditionsConnective, this.conditions);
        }
    }
}

