/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.job.config;

import org.elasticsearch.common.Strings;
import org.elasticsearch.xpack.core.ml.job.config.Detector;
import org.elasticsearch.xpack.core.ml.utils.MlStrings;

public final class DefaultDetectorDescription {
    private static final String BY_TOKEN = " by ";
    private static final String OVER_TOKEN = " over ";
    private static final String USE_NULL_OPTION = " usenull=";
    private static final String PARTITION_FIELD_OPTION = " partitionfield=";
    private static final String EXCLUDE_FREQUENT_OPTION = " excludefrequent=";

    private DefaultDetectorDescription() {
    }

    public static String of(Detector detector) {
        StringBuilder sb = new StringBuilder();
        DefaultDetectorDescription.appendOn(detector, sb);
        return sb.toString();
    }

    public static void appendOn(Detector detector, StringBuilder sb) {
        if (DefaultDetectorDescription.isNotNullOrEmpty(detector.getFunction())) {
            sb.append(detector.getFunction());
            if (DefaultDetectorDescription.isNotNullOrEmpty(detector.getFieldName())) {
                sb.append('(').append(DefaultDetectorDescription.quoteField(detector.getFieldName())).append(')');
            }
        } else if (DefaultDetectorDescription.isNotNullOrEmpty(detector.getFieldName())) {
            sb.append(DefaultDetectorDescription.quoteField(detector.getFieldName()));
        }
        if (DefaultDetectorDescription.isNotNullOrEmpty(detector.getByFieldName())) {
            sb.append(BY_TOKEN).append(DefaultDetectorDescription.quoteField(detector.getByFieldName()));
        }
        if (DefaultDetectorDescription.isNotNullOrEmpty(detector.getOverFieldName())) {
            sb.append(OVER_TOKEN).append(DefaultDetectorDescription.quoteField(detector.getOverFieldName()));
        }
        if (detector.isUseNull()) {
            sb.append(USE_NULL_OPTION).append(detector.isUseNull());
        }
        if (DefaultDetectorDescription.isNotNullOrEmpty(detector.getPartitionFieldName())) {
            sb.append(PARTITION_FIELD_OPTION).append(DefaultDetectorDescription.quoteField(detector.getPartitionFieldName()));
        }
        if (detector.getExcludeFrequent() != null) {
            sb.append(EXCLUDE_FREQUENT_OPTION).append((Object)detector.getExcludeFrequent());
        }
    }

    private static String quoteField(String field) {
        return MlStrings.doubleQuoteIfNotAlphaNumeric(field);
    }

    private static boolean isNotNullOrEmpty(String arg) {
        return !Strings.isNullOrEmpty((String)arg);
    }
}

