/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.action.util;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;

public class PageParams
implements ToXContentObject,
Writeable {
    public static final ParseField PAGE = new ParseField("page", new String[0]);
    public static final ParseField FROM = new ParseField("from", new String[0]);
    public static final ParseField SIZE = new ParseField("size", new String[0]);
    public static final int DEFAULT_FROM = 0;
    public static final int DEFAULT_SIZE = 100;
    public static final ConstructingObjectParser<PageParams, Void> PARSER = new ConstructingObjectParser(PAGE.getPreferredName(), a -> new PageParams(a[0] == null ? 0 : (Integer)a[0], a[1] == null ? 100 : (Integer)a[1]));
    public static final int MAX_FROM_SIZE_SUM = 10000;
    private final int from;
    private final int size;

    public static PageParams defaultParams() {
        return new PageParams(0, 100);
    }

    public PageParams(StreamInput in) throws IOException {
        this(in.readVInt(), in.readVInt());
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeVInt(this.from);
        out.writeVInt(this.size);
    }

    public PageParams() {
        this.from = 0;
        this.size = 100;
    }

    public PageParams(int from, int size) {
        if (from < 0) {
            throw new IllegalArgumentException("Parameter [" + FROM.getPreferredName() + "] cannot be < 0");
        }
        if (size < 0) {
            throw new IllegalArgumentException("Parameter [" + SIZE.getPreferredName() + "] cannot be < 0");
        }
        if (from + size > 10000) {
            throw new IllegalArgumentException("The sum of parameters [" + FROM.getPreferredName() + "] and [" + SIZE.getPreferredName() + "] cannot be higher than " + 10000 + ".");
        }
        this.from = from;
        this.size = size;
    }

    public int getFrom() {
        return this.from;
    }

    public int getSize() {
        return this.size;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(FROM.getPreferredName(), this.from);
        builder.field(SIZE.getPreferredName(), this.size);
        builder.endObject();
        return builder;
    }

    public int hashCode() {
        return Objects.hash(this.from, this.size);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PageParams other = (PageParams)obj;
        return Objects.equals(this.from, other.from) && Objects.equals(this.size, other.size);
    }

    static {
        PARSER.declareInt(ConstructingObjectParser.optionalConstructorArg(), FROM);
        PARSER.declareInt(ConstructingObjectParser.optionalConstructorArg(), SIZE);
    }
}

