/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.action;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.action.Action;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.support.master.AcknowledgedRequest;
import org.elasticsearch.action.support.master.MasterNodeOperationRequestBuilder;
import org.elasticsearch.action.support.master.MasterNodeRequest;
import org.elasticsearch.client.ElasticsearchClient;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.xpack.core.ml.action.PutJobAction;
import org.elasticsearch.xpack.core.ml.job.config.JobUpdate;

public class UpdateJobAction
extends Action<Request, PutJobAction.Response, RequestBuilder> {
    public static final UpdateJobAction INSTANCE = new UpdateJobAction();
    public static final String NAME = "cluster:admin/xpack/ml/job/update";

    private UpdateJobAction() {
        super(NAME);
    }

    public RequestBuilder newRequestBuilder(ElasticsearchClient client) {
        return new RequestBuilder(client, this);
    }

    public PutJobAction.Response newResponse() {
        return new PutJobAction.Response();
    }

    public static class RequestBuilder
    extends MasterNodeOperationRequestBuilder<Request, PutJobAction.Response, RequestBuilder> {
        public RequestBuilder(ElasticsearchClient client, UpdateJobAction action) {
            super(client, (Action)action, (MasterNodeRequest)new Request());
        }
    }

    public static class Request
    extends AcknowledgedRequest<Request>
    implements ToXContentObject {
        private String jobId;
        private JobUpdate update;

        public static Request parseRequest(String jobId, XContentParser parser) {
            JobUpdate update = ((JobUpdate.Builder)JobUpdate.PARSER.apply(parser, null)).setJobId(jobId).build();
            return new Request(jobId, update);
        }

        public Request(String jobId, JobUpdate update) {
            this.jobId = jobId;
            this.update = update;
        }

        public Request() {
        }

        public String getJobId() {
            return this.jobId;
        }

        public JobUpdate getJobUpdate() {
            return this.update;
        }

        public ActionRequestValidationException validate() {
            return null;
        }

        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            this.jobId = in.readString();
            this.update = new JobUpdate(in);
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeString(this.jobId);
            this.update.writeTo(out);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            this.update.toXContent(builder, params);
            return builder;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            Request request = (Request)((Object)o);
            return Objects.equals(this.jobId, request.jobId) && Objects.equals(this.update, request.update);
        }

        public int hashCode() {
            return Objects.hash(this.jobId, this.update);
        }

        public final String toString() {
            return Strings.toString((ToXContent)this);
        }
    }
}

