/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.action;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.action.Action;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestBuilder;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.client.ElasticsearchClient;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xpack.core.ml.action.PutCalendarAction;
import org.elasticsearch.xpack.core.ml.calendars.Calendar;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;

public class UpdateCalendarJobAction
extends Action<Request, PutCalendarAction.Response, RequestBuilder> {
    public static final UpdateCalendarJobAction INSTANCE = new UpdateCalendarJobAction();
    public static final String NAME = "cluster:admin/xpack/ml/calendars/jobs/update";

    private UpdateCalendarJobAction() {
        super(NAME);
    }

    public RequestBuilder newRequestBuilder(ElasticsearchClient client) {
        return new RequestBuilder(client);
    }

    public PutCalendarAction.Response newResponse() {
        return new PutCalendarAction.Response();
    }

    public static class RequestBuilder
    extends ActionRequestBuilder<Request, PutCalendarAction.Response, RequestBuilder> {
        public RequestBuilder(ElasticsearchClient client) {
            super(client, (Action)INSTANCE, (ActionRequest)new Request());
        }
    }

    public static class Request
    extends ActionRequest {
        private String calendarId;
        private String jobIdToAdd;
        private String jobIdToRemove;

        public Request() {
        }

        public Request(String calendarId, String jobIdToAdd, String jobIdToRemove) {
            this.calendarId = ExceptionsHelper.requireNonNull(calendarId, Calendar.ID.getPreferredName());
            this.jobIdToAdd = jobIdToAdd;
            this.jobIdToRemove = jobIdToRemove;
        }

        public String getCalendarId() {
            return this.calendarId;
        }

        public String getJobIdToAdd() {
            return this.jobIdToAdd;
        }

        public String getJobIdToRemove() {
            return this.jobIdToRemove;
        }

        public ActionRequestValidationException validate() {
            return null;
        }

        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            this.calendarId = in.readString();
            this.jobIdToAdd = in.readOptionalString();
            this.jobIdToRemove = in.readOptionalString();
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeString(this.calendarId);
            out.writeOptionalString(this.jobIdToAdd);
            out.writeOptionalString(this.jobIdToRemove);
        }

        public int hashCode() {
            return Objects.hash(this.calendarId, this.jobIdToAdd, this.jobIdToRemove);
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (((Object)((Object)this)).getClass() != obj.getClass()) {
                return false;
            }
            Request other = (Request)((Object)obj);
            return Objects.equals(this.calendarId, other.calendarId) && Objects.equals(this.jobIdToAdd, other.jobIdToAdd) && Objects.equals(this.jobIdToRemove, other.jobIdToRemove);
        }
    }
}

