/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.extensions;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.security.AccessController;
import java.security.NoSuchAlgorithmException;
import java.security.Permission;
import java.security.Policy;
import java.security.URIParameter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.elasticsearch.SpecialPermission;
import org.elasticsearch.common.SuppressForbidden;
import org.elasticsearch.common.io.PathUtils;
import org.elasticsearch.xpack.core.extensions.XPackExtensionPolicy;

final class XPackExtensionSecurity {
    private XPackExtensionSecurity() {
    }

    static void configure(Path extsDirectory) throws IOException {
        Map<String, Policy> map = XPackExtensionSecurity.getExtensionsPermissions(extsDirectory);
        if (map.size() > 0) {
            SecurityManager sm = System.getSecurityManager();
            if (sm != null) {
                sm.checkPermission((Permission)new SpecialPermission());
            }
            AccessController.doPrivileged(() -> {
                XPackExtensionPolicy newPolicy = new XPackExtensionPolicy(Policy.getPolicy(), map);
                Policy.setPolicy(newPolicy);
                return null;
            });
        }
    }

    @SuppressForbidden(reason="proper use of URL")
    static Map<String, Policy> getExtensionsPermissions(Path extsDirectory) throws IOException {
        HashMap<String, Policy> map = new HashMap<String, Policy>();
        ArrayList<Path> extensionPaths = new ArrayList<Path>();
        if (Files.exists(extsDirectory, new LinkOption[0])) {
            try (DirectoryStream<Path> stream = Files.newDirectoryStream(extsDirectory);){
                for (Path extension : stream) {
                    extensionPaths.add(extension);
                }
            }
        }
        for (Path extension : extensionPaths) {
            Path policyFile = extension.resolve("x-pack-extension-security.policy");
            if (!Files.exists(policyFile, new LinkOption[0])) continue;
            ArrayList<URL> codebases = new ArrayList<URL>();
            DirectoryStream<Path> jarStream = Files.newDirectoryStream(extension, "*.jar");
            Object object = null;
            try {
                for (Path jar : jarStream) {
                    codebases.add(jar.toRealPath(new LinkOption[0]).toUri().toURL());
                }
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (jarStream != null) {
                    XPackExtensionSecurity.$closeResource((Throwable)object, jarStream);
                }
            }
            Policy policy = XPackExtensionSecurity.readPolicy(policyFile.toUri().toURL(), codebases.toArray(new URL[codebases.size()]));
            for (URL url : codebases) {
                if (map.put(url.getFile(), policy) == null) continue;
                throw new IllegalStateException("per-extension permissions already granted for jar file: " + url);
            }
        }
        return Collections.unmodifiableMap(map);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressForbidden(reason="accesses fully qualified URLs to configure security")
    static Policy readPolicy(URL policyFile, URL[] codebases) throws IOException {
        Policy policy;
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission((Permission)new SpecialPermission());
        }
        try {
            for (URL url : codebases) {
                String shortName = PathUtils.get((URI)url.toURI()).getFileName().toString();
                AccessController.doPrivileged(() -> {
                    System.setProperty("codebase." + shortName, url.toString());
                    return null;
                });
            }
            URIParameter uri = new URIParameter(policyFile.toURI());
            policy = AccessController.doPrivileged(() -> {
                try {
                    return Policy.getInstance("JavaPolicy", uri);
                }
                catch (NoSuchAlgorithmException e) {
                    throw new RuntimeException(e);
                }
            });
        }
        catch (Throwable throwable) {
            try {
                for (URL url : codebases) {
                    String shortName = PathUtils.get((URI)url.toURI()).getFileName().toString();
                    AccessController.doPrivileged(() -> {
                        System.clearProperty("codebase." + shortName);
                        return null;
                    });
                }
                throw throwable;
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException("unable to parse policy file `" + policyFile + "`", e);
            }
        }
        for (URL url : codebases) {
            String shortName = PathUtils.get((URI)url.toURI()).getFileName().toString();
            AccessController.doPrivileged(() -> {
                System.clearProperty("codebase." + shortName);
                return null;
            });
        }
        return policy;
    }
}

