/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.extensions;

import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import joptsimple.OptionSet;
import org.elasticsearch.cli.EnvironmentAwareCommand;
import org.elasticsearch.cli.Terminal;
import org.elasticsearch.env.Environment;
import org.elasticsearch.xpack.core.XPackPlugin;
import org.elasticsearch.xpack.core.extensions.XPackExtensionInfo;

class ListXPackExtensionCommand
extends EnvironmentAwareCommand {
    ListXPackExtensionCommand() {
        super("Lists installed x-pack extensions");
    }

    protected void execute(Terminal terminal, OptionSet options, Environment env) throws Exception {
        if (!Files.exists(XPackPlugin.resolveXPackExtensionsFile(env), new LinkOption[0])) {
            throw new IOException("Extensions directory missing: " + XPackPlugin.resolveXPackExtensionsFile(env));
        }
        terminal.println(Terminal.Verbosity.VERBOSE, "XPack Extensions directory: " + XPackPlugin.resolveXPackExtensionsFile(env));
        ArrayList<Path> extensions = new ArrayList<Path>();
        try (DirectoryStream<Path> paths = Files.newDirectoryStream(XPackPlugin.resolveXPackExtensionsFile(env));){
            for (Path extension : paths) {
                extensions.add(extension);
            }
        }
        Collections.sort(extensions);
        for (Path extension : extensions) {
            terminal.println(extension.getFileName().toString());
            XPackExtensionInfo info = XPackExtensionInfo.readFromProperties(extension);
            terminal.println(Terminal.Verbosity.VERBOSE, info.toString());
        }
    }
}

