/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core;

import java.io.IOException;
import java.nio.file.Path;
import java.security.AccessController;
import java.security.GeneralSecurityException;
import java.security.Permission;
import java.security.PrivilegedAction;
import java.time.Clock;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import javax.security.auth.DestroyFailedException;
import org.apache.lucene.util.SetOnce;
import org.bouncycastle.operator.OperatorCreationException;
import org.elasticsearch.SpecialPermission;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.GenericAction;
import org.elasticsearch.action.support.ActionFilter;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Binder;
import org.elasticsearch.common.inject.Module;
import org.elasticsearch.common.inject.multibindings.Multibinder;
import org.elasticsearch.common.inject.util.Providers;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.IndexScopedSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.settings.SettingsFilter;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.env.Environment;
import org.elasticsearch.env.NodeEnvironment;
import org.elasticsearch.license.LicenseService;
import org.elasticsearch.license.Licensing;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.plugins.ActionPlugin;
import org.elasticsearch.plugins.ExtensiblePlugin;
import org.elasticsearch.plugins.ScriptPlugin;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.watcher.ResourceWatcherService;
import org.elasticsearch.xpack.core.EmptyXPackFeatureSet;
import org.elasticsearch.xpack.core.XPackClientPlugin;
import org.elasticsearch.xpack.core.XPackFeatureSet;
import org.elasticsearch.xpack.core.action.TransportXPackInfoAction;
import org.elasticsearch.xpack.core.action.TransportXPackUsageAction;
import org.elasticsearch.xpack.core.action.XPackInfoAction;
import org.elasticsearch.xpack.core.action.XPackUsageAction;
import org.elasticsearch.xpack.core.extensions.XPackExtension;
import org.elasticsearch.xpack.core.rest.action.RestXPackInfoAction;
import org.elasticsearch.xpack.core.rest.action.RestXPackUsageAction;
import org.elasticsearch.xpack.core.ssl.SSLConfigurationReloader;
import org.elasticsearch.xpack.core.ssl.SSLService;

public class XPackPlugin
extends XPackClientPlugin
implements ScriptPlugin,
ExtensiblePlugin {
    protected final Settings settings;
    protected boolean transportClientMode;
    protected final Licensing licensing;
    private static final SetOnce<XPackLicenseState> licenseState;
    private static final SetOnce<SSLService> sslService;
    private static final SetOnce<LicenseService> licenseService;

    public XPackPlugin(Settings settings, Path configPath) throws IOException, DestroyFailedException, OperatorCreationException, GeneralSecurityException {
        super(settings);
        this.settings = settings;
        this.transportClientMode = XPackPlugin.transportClientMode(settings);
        Environment env = this.transportClientMode ? null : new Environment(settings, configPath);
        this.setSslService(new SSLService(settings, env));
        this.setLicenseState(new XPackLicenseState());
        this.licensing = new Licensing(settings);
    }

    public Collection<Class<? extends XPackExtension>> getExtensions() {
        return Collections.emptyList();
    }

    protected Clock getClock() {
        return Clock.systemUTC();
    }

    protected SSLService getSslService() {
        return XPackPlugin.getSharedSslService();
    }

    protected LicenseService getLicenseService() {
        return XPackPlugin.getSharedLicenseService();
    }

    protected XPackLicenseState getLicenseState() {
        return XPackPlugin.getSharedLicenseState();
    }

    protected void setSslService(SSLService sslService) {
        XPackPlugin.sslService.set((Object)sslService);
    }

    protected void setLicenseService(LicenseService licenseService) {
        XPackPlugin.licenseService.set((Object)licenseService);
    }

    protected void setLicenseState(XPackLicenseState licenseState) {
        XPackPlugin.licenseState.set((Object)licenseState);
    }

    public static SSLService getSharedSslService() {
        return (SSLService)((Object)sslService.get());
    }

    public static LicenseService getSharedLicenseService() {
        return (LicenseService)licenseService.get();
    }

    public static XPackLicenseState getSharedLicenseState() {
        return (XPackLicenseState)licenseState.get();
    }

    public Collection<Module> createGuiceModules() {
        ArrayList<Module> modules = new ArrayList<Module>();
        modules.add(b -> XPackPlugin.createFeatureSetMultiBinder(b, EmptyXPackFeatureSet.class));
        if (this.transportClientMode) {
            modules.add(b -> b.bind(XPackLicenseState.class).toProvider(Providers.of(null)));
        }
        return modules;
    }

    public Collection<Object> createComponents(Client client, ClusterService clusterService, ThreadPool threadPool, ResourceWatcherService resourceWatcherService, ScriptService scriptService, NamedXContentRegistry xContentRegistry, Environment environment, NodeEnvironment nodeEnvironment, NamedWriteableRegistry namedWriteableRegistry) {
        ArrayList<Object> components = new ArrayList<Object>();
        new SSLConfigurationReloader(this.settings, environment, this.getSslService(), resourceWatcherService);
        this.setLicenseService(new LicenseService(this.settings, clusterService, this.getClock(), environment, resourceWatcherService, this.getLicenseState()));
        components.add((Object)this.getSslService());
        components.add(this.getLicenseService());
        components.add(this.getLicenseState());
        return components;
    }

    public List<ActionPlugin.ActionHandler<? extends ActionRequest, ? extends ActionResponse>> getActions() {
        ArrayList<ActionPlugin.ActionHandler<? extends ActionRequest, ? extends ActionResponse>> actions = new ArrayList<ActionPlugin.ActionHandler<? extends ActionRequest, ? extends ActionResponse>>();
        actions.add(new ActionPlugin.ActionHandler((GenericAction)XPackInfoAction.INSTANCE, TransportXPackInfoAction.class, new Class[0]));
        actions.add(new ActionPlugin.ActionHandler((GenericAction)XPackUsageAction.INSTANCE, TransportXPackUsageAction.class, new Class[0]));
        actions.addAll(this.licensing.getActions());
        return actions;
    }

    @Override
    public List<GenericAction> getClientActions() {
        ArrayList<GenericAction> actions = new ArrayList<GenericAction>();
        actions.addAll(this.licensing.getClientActions());
        actions.addAll(super.getClientActions());
        return actions;
    }

    public List<ActionFilter> getActionFilters() {
        ArrayList<ActionFilter> filters = new ArrayList<ActionFilter>();
        filters.addAll(this.licensing.getActionFilters());
        return filters;
    }

    public List<RestHandler> getRestHandlers(Settings settings, RestController restController, ClusterSettings clusterSettings, IndexScopedSettings indexScopedSettings, SettingsFilter settingsFilter, IndexNameExpressionResolver indexNameExpressionResolver, Supplier<DiscoveryNodes> nodesInCluster) {
        ArrayList<RestHandler> handlers = new ArrayList<RestHandler>();
        handlers.add((RestHandler)new RestXPackInfoAction(settings, restController));
        handlers.add((RestHandler)new RestXPackUsageAction(settings, restController));
        handlers.addAll(this.licensing.getRestHandlers(settings, restController, clusterSettings, indexScopedSettings, settingsFilter, indexNameExpressionResolver, nodesInCluster));
        return handlers;
    }

    public static void bindFeatureSet(Binder binder, Class<? extends XPackFeatureSet> featureSet) {
        Multibinder<XPackFeatureSet> featureSetBinder = XPackPlugin.createFeatureSetMultiBinder(binder, featureSet);
        featureSetBinder.addBinding().to(featureSet);
    }

    public static Multibinder<XPackFeatureSet> createFeatureSetMultiBinder(Binder binder, Class<? extends XPackFeatureSet> featureSet) {
        binder.bind(featureSet).asEagerSingleton();
        return Multibinder.newSetBinder((Binder)binder, XPackFeatureSet.class);
    }

    public static boolean transportClientMode(Settings settings) {
        return "transport".equals(settings.get(Client.CLIENT_TYPE_SETTING_S.getKey()));
    }

    public static Path resolveConfigFile(Environment env, String name) {
        return env.configFile().resolve("x-pack").resolve(name);
    }

    public static Path resolveXPackExtensionsFile(Environment env) {
        return env.pluginsFile().resolve("x-pack").resolve("x-pack-security").resolve("extensions");
    }

    static {
        block3: {
            SecurityManager sm = System.getSecurityManager();
            if (sm != null) {
                sm.checkPermission((Permission)new SpecialPermission());
            }
            try {
                AccessController.doPrivileged(new PrivilegedAction<Void>(){

                    @Override
                    public Void run() {
                        try {
                            Class.forName("com.unboundid.util.Debug");
                        }
                        catch (ClassNotFoundException e) {
                            throw new RuntimeException(e);
                        }
                        return null;
                    }
                });
            }
            catch (ExceptionInInitializerError bogus) {
                if (bogus.getCause() instanceof SecurityException) break block3;
                throw bogus;
            }
        }
        licenseState = new SetOnce();
        sslService = new SetOnce();
        licenseService = new SetOnce();
    }
}

