/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.elasticsearch.action.GenericAction;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.NamedDiff;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.network.NetworkService;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.PageCacheRecycler;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.indices.breaker.CircuitBreakerService;
import org.elasticsearch.license.DeleteLicenseAction;
import org.elasticsearch.license.GetLicenseAction;
import org.elasticsearch.license.GetTrialStatusAction;
import org.elasticsearch.license.LicenseService;
import org.elasticsearch.license.LicensesMetaData;
import org.elasticsearch.license.PostStartTrialAction;
import org.elasticsearch.license.PutLicenseAction;
import org.elasticsearch.plugins.ActionPlugin;
import org.elasticsearch.plugins.NetworkPlugin;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.Transport;
import org.elasticsearch.xpack.core.XPackFeatureSet;
import org.elasticsearch.xpack.core.XPackPlugin;
import org.elasticsearch.xpack.core.XPackSettings;
import org.elasticsearch.xpack.core.action.XPackInfoAction;
import org.elasticsearch.xpack.core.action.XPackUsageAction;
import org.elasticsearch.xpack.core.deprecation.DeprecationInfoAction;
import org.elasticsearch.xpack.core.graph.GraphFeatureSetUsage;
import org.elasticsearch.xpack.core.graph.action.GraphExploreAction;
import org.elasticsearch.xpack.core.ml.MachineLearningFeatureSetUsage;
import org.elasticsearch.xpack.core.ml.MlMetadata;
import org.elasticsearch.xpack.core.ml.action.CloseJobAction;
import org.elasticsearch.xpack.core.ml.action.DeleteCalendarAction;
import org.elasticsearch.xpack.core.ml.action.DeleteCalendarEventAction;
import org.elasticsearch.xpack.core.ml.action.DeleteDatafeedAction;
import org.elasticsearch.xpack.core.ml.action.DeleteExpiredDataAction;
import org.elasticsearch.xpack.core.ml.action.DeleteFilterAction;
import org.elasticsearch.xpack.core.ml.action.DeleteJobAction;
import org.elasticsearch.xpack.core.ml.action.DeleteModelSnapshotAction;
import org.elasticsearch.xpack.core.ml.action.FinalizeJobExecutionAction;
import org.elasticsearch.xpack.core.ml.action.FlushJobAction;
import org.elasticsearch.xpack.core.ml.action.ForecastJobAction;
import org.elasticsearch.xpack.core.ml.action.GetBucketsAction;
import org.elasticsearch.xpack.core.ml.action.GetCalendarEventsAction;
import org.elasticsearch.xpack.core.ml.action.GetCalendarsAction;
import org.elasticsearch.xpack.core.ml.action.GetCategoriesAction;
import org.elasticsearch.xpack.core.ml.action.GetDatafeedsAction;
import org.elasticsearch.xpack.core.ml.action.GetDatafeedsStatsAction;
import org.elasticsearch.xpack.core.ml.action.GetFiltersAction;
import org.elasticsearch.xpack.core.ml.action.GetInfluencersAction;
import org.elasticsearch.xpack.core.ml.action.GetJobsAction;
import org.elasticsearch.xpack.core.ml.action.GetJobsStatsAction;
import org.elasticsearch.xpack.core.ml.action.GetModelSnapshotsAction;
import org.elasticsearch.xpack.core.ml.action.GetOverallBucketsAction;
import org.elasticsearch.xpack.core.ml.action.GetRecordsAction;
import org.elasticsearch.xpack.core.ml.action.IsolateDatafeedAction;
import org.elasticsearch.xpack.core.ml.action.KillProcessAction;
import org.elasticsearch.xpack.core.ml.action.OpenJobAction;
import org.elasticsearch.xpack.core.ml.action.PostCalendarEventsAction;
import org.elasticsearch.xpack.core.ml.action.PostDataAction;
import org.elasticsearch.xpack.core.ml.action.PreviewDatafeedAction;
import org.elasticsearch.xpack.core.ml.action.PutCalendarAction;
import org.elasticsearch.xpack.core.ml.action.PutDatafeedAction;
import org.elasticsearch.xpack.core.ml.action.PutFilterAction;
import org.elasticsearch.xpack.core.ml.action.PutJobAction;
import org.elasticsearch.xpack.core.ml.action.RevertModelSnapshotAction;
import org.elasticsearch.xpack.core.ml.action.StartDatafeedAction;
import org.elasticsearch.xpack.core.ml.action.StopDatafeedAction;
import org.elasticsearch.xpack.core.ml.action.UpdateCalendarJobAction;
import org.elasticsearch.xpack.core.ml.action.UpdateDatafeedAction;
import org.elasticsearch.xpack.core.ml.action.UpdateJobAction;
import org.elasticsearch.xpack.core.ml.action.UpdateModelSnapshotAction;
import org.elasticsearch.xpack.core.ml.action.UpdateProcessAction;
import org.elasticsearch.xpack.core.ml.action.ValidateDetectorAction;
import org.elasticsearch.xpack.core.ml.action.ValidateJobConfigAction;
import org.elasticsearch.xpack.core.ml.datafeed.DatafeedState;
import org.elasticsearch.xpack.core.ml.job.config.JobTaskStatus;
import org.elasticsearch.xpack.core.monitoring.MonitoringFeatureSetUsage;
import org.elasticsearch.xpack.core.persistent.CompletionPersistentTaskAction;
import org.elasticsearch.xpack.core.persistent.PersistentTaskParams;
import org.elasticsearch.xpack.core.persistent.PersistentTasksCustomMetaData;
import org.elasticsearch.xpack.core.persistent.PersistentTasksNodeService;
import org.elasticsearch.xpack.core.persistent.RemovePersistentTaskAction;
import org.elasticsearch.xpack.core.persistent.StartPersistentTaskAction;
import org.elasticsearch.xpack.core.persistent.UpdatePersistentTaskStatusAction;
import org.elasticsearch.xpack.core.security.SecurityFeatureSetUsage;
import org.elasticsearch.xpack.core.security.SecuritySettings;
import org.elasticsearch.xpack.core.security.action.realm.ClearRealmCacheAction;
import org.elasticsearch.xpack.core.security.action.role.ClearRolesCacheAction;
import org.elasticsearch.xpack.core.security.action.role.DeleteRoleAction;
import org.elasticsearch.xpack.core.security.action.role.GetRolesAction;
import org.elasticsearch.xpack.core.security.action.role.PutRoleAction;
import org.elasticsearch.xpack.core.security.action.rolemapping.DeleteRoleMappingAction;
import org.elasticsearch.xpack.core.security.action.rolemapping.GetRoleMappingsAction;
import org.elasticsearch.xpack.core.security.action.rolemapping.PutRoleMappingAction;
import org.elasticsearch.xpack.core.security.action.token.CreateTokenAction;
import org.elasticsearch.xpack.core.security.action.token.InvalidateTokenAction;
import org.elasticsearch.xpack.core.security.action.token.RefreshTokenAction;
import org.elasticsearch.xpack.core.security.action.user.AuthenticateAction;
import org.elasticsearch.xpack.core.security.action.user.ChangePasswordAction;
import org.elasticsearch.xpack.core.security.action.user.DeleteUserAction;
import org.elasticsearch.xpack.core.security.action.user.GetUsersAction;
import org.elasticsearch.xpack.core.security.action.user.HasPrivilegesAction;
import org.elasticsearch.xpack.core.security.action.user.PutUserAction;
import org.elasticsearch.xpack.core.security.action.user.SetEnabledAction;
import org.elasticsearch.xpack.core.security.authc.TokenMetaData;
import org.elasticsearch.xpack.core.security.authc.support.mapper.expressiondsl.AllExpression;
import org.elasticsearch.xpack.core.security.authc.support.mapper.expressiondsl.AnyExpression;
import org.elasticsearch.xpack.core.security.authc.support.mapper.expressiondsl.ExceptExpression;
import org.elasticsearch.xpack.core.security.authc.support.mapper.expressiondsl.FieldExpression;
import org.elasticsearch.xpack.core.security.authc.support.mapper.expressiondsl.RoleMapperExpression;
import org.elasticsearch.xpack.core.security.transport.netty4.SecurityNetty4Transport;
import org.elasticsearch.xpack.core.ssl.SSLService;
import org.elasticsearch.xpack.core.ssl.action.GetCertificateInfoAction;
import org.elasticsearch.xpack.core.upgrade.actions.IndexUpgradeAction;
import org.elasticsearch.xpack.core.upgrade.actions.IndexUpgradeInfoAction;
import org.elasticsearch.xpack.core.watcher.WatcherFeatureSetUsage;
import org.elasticsearch.xpack.core.watcher.WatcherMetaData;
import org.elasticsearch.xpack.core.watcher.transport.actions.ack.AckWatchAction;
import org.elasticsearch.xpack.core.watcher.transport.actions.activate.ActivateWatchAction;
import org.elasticsearch.xpack.core.watcher.transport.actions.delete.DeleteWatchAction;
import org.elasticsearch.xpack.core.watcher.transport.actions.execute.ExecuteWatchAction;
import org.elasticsearch.xpack.core.watcher.transport.actions.get.GetWatchAction;
import org.elasticsearch.xpack.core.watcher.transport.actions.put.PutWatchAction;
import org.elasticsearch.xpack.core.watcher.transport.actions.service.WatcherServiceAction;
import org.elasticsearch.xpack.core.watcher.transport.actions.stats.WatcherStatsAction;

public class XPackClientPlugin
extends Plugin
implements ActionPlugin,
NetworkPlugin {
    private final Settings settings;

    public XPackClientPlugin(Settings settings) {
        this.settings = settings;
    }

    public List<Setting<?>> getSettings() {
        ArrayList settings = new ArrayList();
        settings.add(Setting.groupSetting((String)"license.", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}));
        settings.addAll(XPackSettings.getAllSettings());
        settings.add(LicenseService.SELF_GENERATED_LICENSE_TYPE);
        settings.add(Setting.simpleString((String)"index.xpack.version", (Setting.Property[])new Setting.Property[]{Setting.Property.IndexScope}));
        return settings;
    }

    public Settings additionalSettings() {
        return XPackClientPlugin.additionalSettings(this.settings, (Boolean)XPackSettings.SECURITY_ENABLED.get(this.settings), XPackPlugin.transportClientMode(this.settings));
    }

    static Settings additionalSettings(Settings settings, boolean enabled, boolean transportClientMode) {
        if (enabled && transportClientMode) {
            Settings.Builder builder = Settings.builder();
            builder.put(SecuritySettings.addTransportSettings(settings));
            builder.put(SecuritySettings.addUserSettings(settings));
            return builder.build();
        }
        return Settings.EMPTY;
    }

    public List<GenericAction> getClientActions() {
        return Arrays.asList(new GenericAction[]{DeprecationInfoAction.INSTANCE, GraphExploreAction.INSTANCE, GetJobsAction.INSTANCE, GetJobsStatsAction.INSTANCE, PutJobAction.INSTANCE, UpdateJobAction.INSTANCE, DeleteJobAction.INSTANCE, OpenJobAction.INSTANCE, GetFiltersAction.INSTANCE, PutFilterAction.INSTANCE, DeleteFilterAction.INSTANCE, KillProcessAction.INSTANCE, GetBucketsAction.INSTANCE, GetInfluencersAction.INSTANCE, GetOverallBucketsAction.INSTANCE, GetRecordsAction.INSTANCE, PostDataAction.INSTANCE, CloseJobAction.INSTANCE, FinalizeJobExecutionAction.INSTANCE, FlushJobAction.INSTANCE, ValidateDetectorAction.INSTANCE, ValidateJobConfigAction.INSTANCE, GetCategoriesAction.INSTANCE, GetModelSnapshotsAction.INSTANCE, RevertModelSnapshotAction.INSTANCE, UpdateModelSnapshotAction.INSTANCE, GetDatafeedsAction.INSTANCE, GetDatafeedsStatsAction.INSTANCE, PutDatafeedAction.INSTANCE, UpdateDatafeedAction.INSTANCE, DeleteDatafeedAction.INSTANCE, PreviewDatafeedAction.INSTANCE, StartDatafeedAction.INSTANCE, StopDatafeedAction.INSTANCE, IsolateDatafeedAction.INSTANCE, DeleteModelSnapshotAction.INSTANCE, UpdateProcessAction.INSTANCE, DeleteExpiredDataAction.INSTANCE, ForecastJobAction.INSTANCE, GetCalendarsAction.INSTANCE, PutCalendarAction.INSTANCE, DeleteCalendarAction.INSTANCE, DeleteCalendarEventAction.INSTANCE, UpdateCalendarJobAction.INSTANCE, GetCalendarEventsAction.INSTANCE, PostCalendarEventsAction.INSTANCE, StartPersistentTaskAction.INSTANCE, UpdatePersistentTaskStatusAction.INSTANCE, RemovePersistentTaskAction.INSTANCE, CompletionPersistentTaskAction.INSTANCE, ClearRealmCacheAction.INSTANCE, ClearRolesCacheAction.INSTANCE, GetUsersAction.INSTANCE, PutUserAction.INSTANCE, DeleteUserAction.INSTANCE, GetRolesAction.INSTANCE, PutRoleAction.INSTANCE, DeleteRoleAction.INSTANCE, ChangePasswordAction.INSTANCE, AuthenticateAction.INSTANCE, SetEnabledAction.INSTANCE, HasPrivilegesAction.INSTANCE, GetRoleMappingsAction.INSTANCE, PutRoleMappingAction.INSTANCE, DeleteRoleMappingAction.INSTANCE, CreateTokenAction.INSTANCE, InvalidateTokenAction.INSTANCE, GetCertificateInfoAction.INSTANCE, RefreshTokenAction.INSTANCE, IndexUpgradeInfoAction.INSTANCE, IndexUpgradeAction.INSTANCE, PutWatchAction.INSTANCE, DeleteWatchAction.INSTANCE, GetWatchAction.INSTANCE, WatcherStatsAction.INSTANCE, AckWatchAction.INSTANCE, ActivateWatchAction.INSTANCE, WatcherServiceAction.INSTANCE, ExecuteWatchAction.INSTANCE, PutLicenseAction.INSTANCE, GetLicenseAction.INSTANCE, DeleteLicenseAction.INSTANCE, PostStartTrialAction.INSTANCE, GetTrialStatusAction.INSTANCE, XPackInfoAction.INSTANCE, XPackUsageAction.INSTANCE});
    }

    public List<NamedWriteableRegistry.Entry> getNamedWriteables() {
        return Arrays.asList(new NamedWriteableRegistry.Entry(XPackFeatureSet.Usage.class, "graph", GraphFeatureSetUsage::new), new NamedWriteableRegistry.Entry(MetaData.Custom.class, "ml", MlMetadata::new), new NamedWriteableRegistry.Entry(NamedDiff.class, "ml", MlMetadata.MlMetadataDiff::new), new NamedWriteableRegistry.Entry(MetaData.Custom.class, "persistent_tasks", PersistentTasksCustomMetaData::new), new NamedWriteableRegistry.Entry(NamedDiff.class, "persistent_tasks", PersistentTasksCustomMetaData::readDiffFrom), new NamedWriteableRegistry.Entry(PersistentTaskParams.class, "xpack/ml/datafeed", StartDatafeedAction.DatafeedParams::new), new NamedWriteableRegistry.Entry(PersistentTaskParams.class, "xpack/ml/job", OpenJobAction.JobParams::new), new NamedWriteableRegistry.Entry(Task.Status.class, "persistent_executor", PersistentTasksNodeService.Status::new), new NamedWriteableRegistry.Entry(Task.Status.class, "xpack/ml/job", JobTaskStatus::new), new NamedWriteableRegistry.Entry(Task.Status.class, "xpack/ml/datafeed", DatafeedState::fromStream), new NamedWriteableRegistry.Entry(XPackFeatureSet.Usage.class, "ml", MachineLearningFeatureSetUsage::new), new NamedWriteableRegistry.Entry(XPackFeatureSet.Usage.class, "monitoring", MonitoringFeatureSetUsage::new), new NamedWriteableRegistry.Entry(ClusterState.Custom.class, "security_tokens", TokenMetaData::new), new NamedWriteableRegistry.Entry(NamedDiff.class, "security_tokens", TokenMetaData::readDiffFrom), new NamedWriteableRegistry.Entry(XPackFeatureSet.Usage.class, "security", SecurityFeatureSetUsage::new), new NamedWriteableRegistry.Entry(RoleMapperExpression.class, "all", AllExpression::new), new NamedWriteableRegistry.Entry(RoleMapperExpression.class, "any", AnyExpression::new), new NamedWriteableRegistry.Entry(RoleMapperExpression.class, "field", FieldExpression::new), new NamedWriteableRegistry.Entry(RoleMapperExpression.class, "except", ExceptExpression::new), new NamedWriteableRegistry.Entry(MetaData.Custom.class, "watcher", WatcherMetaData::new), new NamedWriteableRegistry.Entry(NamedDiff.class, "watcher", WatcherMetaData::readDiffFrom), new NamedWriteableRegistry.Entry(XPackFeatureSet.Usage.class, "watcher", WatcherFeatureSetUsage::new), new NamedWriteableRegistry.Entry(MetaData.Custom.class, "licenses", LicensesMetaData::new), new NamedWriteableRegistry.Entry(NamedDiff.class, "licenses", LicensesMetaData::readDiffFrom));
    }

    public List<NamedXContentRegistry.Entry> getNamedXContent() {
        return Arrays.asList(new NamedXContentRegistry.Entry(MetaData.Custom.class, new ParseField("ml", new String[0]), parser -> ((MlMetadata.Builder)MlMetadata.METADATA_PARSER.parse(parser, null)).build()), new NamedXContentRegistry.Entry(MetaData.Custom.class, new ParseField("persistent_tasks", new String[0]), PersistentTasksCustomMetaData::fromXContent), new NamedXContentRegistry.Entry(PersistentTaskParams.class, new ParseField("xpack/ml/datafeed", new String[0]), StartDatafeedAction.DatafeedParams::fromXContent), new NamedXContentRegistry.Entry(PersistentTaskParams.class, new ParseField("xpack/ml/job", new String[0]), OpenJobAction.JobParams::fromXContent), new NamedXContentRegistry.Entry(Task.Status.class, new ParseField("xpack/ml/datafeed", new String[0]), DatafeedState::fromXContent), new NamedXContentRegistry.Entry(Task.Status.class, new ParseField("xpack/ml/job", new String[0]), JobTaskStatus::fromXContent), new NamedXContentRegistry.Entry(MetaData.Custom.class, new ParseField("watcher", new String[0]), WatcherMetaData::fromXContent), new NamedXContentRegistry.Entry(MetaData.Custom.class, new ParseField("licenses", new String[0]), LicensesMetaData::fromXContent));
    }

    public Map<String, Supplier<Transport>> getTransports(Settings settings, ThreadPool threadPool, BigArrays bigArrays, PageCacheRecycler pageCacheRecycler, CircuitBreakerService circuitBreakerService, NamedWriteableRegistry namedWriteableRegistry, NetworkService networkService) {
        SSLService sslService;
        if (!XPackPlugin.transportClientMode(settings) || !((Boolean)XPackSettings.SECURITY_ENABLED.get(settings)).booleanValue()) {
            return Collections.emptyMap();
        }
        try {
            sslService = new SSLService(settings, null);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return Collections.singletonMap("security4", () -> new SecurityNetty4Transport(settings, threadPool, networkService, bigArrays, namedWriteableRegistry, circuitBreakerService, sslService));
    }
}

