/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.license;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.BiFunction;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.logging.LoggerMessageFormat;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.license.License;
import org.elasticsearch.xpack.core.monitoring.MonitoringField;

public class XPackLicenseState {
    static final Map<String, String[]> EXPIRATION_MESSAGES;
    static final Map<String, BiFunction<License.OperationMode, License.OperationMode, String[]>> ACKNOWLEDGMENT_MESSAGES;
    private volatile Status status = new Status(License.OperationMode.TRIAL, true);
    private final List<Runnable> listeners = new CopyOnWriteArrayList<Runnable>();

    private static String[] securityAcknowledgementMessages(License.OperationMode currentMode, License.OperationMode newMode) {
        switch (newMode) {
            case BASIC: {
                switch (currentMode) {
                    case TRIAL: 
                    case STANDARD: 
                    case GOLD: 
                    case PLATINUM: {
                        return new String[]{"The following X-Pack security functionality will be disabled: authentication, authorization, ip filtering, and auditing. Please restart your node after applying the license.", "ThrottlerField and document level access control will be disabled.", "Custom realms will be ignored."};
                    }
                }
                break;
            }
            case GOLD: {
                switch (currentMode) {
                    case TRIAL: 
                    case STANDARD: 
                    case PLATINUM: 
                    case BASIC: {
                        return new String[]{"ThrottlerField and document level access control will be disabled.", "Custom realms will be ignored."};
                    }
                }
                break;
            }
            case STANDARD: {
                switch (currentMode) {
                    case TRIAL: 
                    case GOLD: 
                    case PLATINUM: 
                    case BASIC: {
                        return new String[]{"Authentication will be limited to the native realms.", "IP filtering and auditing will be disabled.", "ThrottlerField and document level access control will be disabled.", "Custom realms will be ignored."};
                    }
                }
            }
        }
        return Strings.EMPTY_ARRAY;
    }

    private static String[] watcherAcknowledgementMessages(License.OperationMode currentMode, License.OperationMode newMode) {
        switch (newMode) {
            case BASIC: {
                switch (currentMode) {
                    case TRIAL: 
                    case STANDARD: 
                    case GOLD: 
                    case PLATINUM: {
                        return new String[]{"Watcher will be disabled"};
                    }
                }
            }
        }
        return Strings.EMPTY_ARRAY;
    }

    private static String[] monitoringAcknowledgementMessages(License.OperationMode currentMode, License.OperationMode newMode) {
        switch (newMode) {
            case BASIC: {
                switch (currentMode) {
                    case TRIAL: 
                    case STANDARD: 
                    case GOLD: 
                    case PLATINUM: {
                        return new String[]{LoggerMessageFormat.format((String)"Multi-cluster support is disabled for clusters with [{}] license. If you are\nrunning multiple clusters, users won't be able to access the clusters with\n[{}] licenses from within a single X-Pack Kibana instance. You will have to deploy a\nseparate and dedicated X-pack Kibana instance for each [{}] cluster you wish to monitor.", (Object[])new Object[]{newMode, newMode, newMode}), LoggerMessageFormat.format((String)"Automatic index cleanup is locked to {} days for clusters with [{}] license.", (Object[])new Object[]{((TimeValue)MonitoringField.HISTORY_DURATION.getDefault(Settings.EMPTY)).days(), newMode})};
                    }
                }
            }
        }
        return Strings.EMPTY_ARRAY;
    }

    private static String[] graphAcknowledgementMessages(License.OperationMode currentMode, License.OperationMode newMode) {
        switch (newMode) {
            case STANDARD: 
            case GOLD: 
            case BASIC: {
                switch (currentMode) {
                    case TRIAL: 
                    case PLATINUM: {
                        return new String[]{"Graph will be disabled"};
                    }
                }
            }
        }
        return Strings.EMPTY_ARRAY;
    }

    private static String[] machineLearningAcknowledgementMessages(License.OperationMode currentMode, License.OperationMode newMode) {
        switch (newMode) {
            case STANDARD: 
            case GOLD: 
            case BASIC: {
                switch (currentMode) {
                    case TRIAL: 
                    case PLATINUM: {
                        return new String[]{"Machine learning will be disabled"};
                    }
                }
            }
        }
        return Strings.EMPTY_ARRAY;
    }

    private static String[] logstashAcknowledgementMessages(License.OperationMode currentMode, License.OperationMode newMode) {
        switch (newMode) {
            case BASIC: {
                switch (currentMode) {
                    case TRIAL: 
                    case STANDARD: 
                    case GOLD: 
                    case PLATINUM: {
                        return new String[]{"Logstash will no longer poll for centrally-managed pipelines"};
                    }
                }
            }
        }
        return Strings.EMPTY_ARRAY;
    }

    void update(License.OperationMode mode, boolean active) {
        this.status = new Status(mode, active);
        this.listeners.forEach(Runnable::run);
    }

    public void addListener(Runnable runnable) {
        this.listeners.add(Objects.requireNonNull(runnable));
    }

    public void removeListener(Runnable runnable) {
        this.listeners.remove(runnable);
    }

    public License.OperationMode getOperationMode() {
        return this.status.mode;
    }

    public boolean isActive() {
        return this.status.active;
    }

    public boolean isAuthAllowed() {
        License.OperationMode mode = this.status.mode;
        return mode == License.OperationMode.STANDARD || mode == License.OperationMode.GOLD || mode == License.OperationMode.PLATINUM || mode == License.OperationMode.TRIAL;
    }

    public boolean isIpFilteringAllowed() {
        License.OperationMode mode = this.status.mode;
        return mode == License.OperationMode.GOLD || mode == License.OperationMode.PLATINUM || mode == License.OperationMode.TRIAL;
    }

    public boolean isAuditingAllowed() {
        License.OperationMode mode = this.status.mode;
        return mode == License.OperationMode.GOLD || mode == License.OperationMode.PLATINUM || mode == License.OperationMode.TRIAL;
    }

    public boolean isStatsAndHealthAllowed() {
        return this.status.active;
    }

    public boolean isDocumentAndFieldLevelSecurityAllowed() {
        License.OperationMode mode = this.status.mode;
        return mode == License.OperationMode.TRIAL || mode == License.OperationMode.PLATINUM;
    }

    public AllowedRealmType allowedRealmType() {
        switch (this.status.mode) {
            case TRIAL: 
            case PLATINUM: {
                return AllowedRealmType.ALL;
            }
            case GOLD: {
                return AllowedRealmType.DEFAULT;
            }
            case STANDARD: {
                return AllowedRealmType.NATIVE;
            }
        }
        return AllowedRealmType.NONE;
    }

    public boolean isCustomRoleProvidersAllowed() {
        Status localStatus = this.status;
        return (localStatus.mode == License.OperationMode.PLATINUM || localStatus.mode == License.OperationMode.TRIAL) && localStatus.active;
    }

    public boolean isWatcherAllowed() {
        Status localStatus = this.status;
        if (!localStatus.active) {
            return false;
        }
        switch (localStatus.mode) {
            case TRIAL: 
            case STANDARD: 
            case GOLD: 
            case PLATINUM: {
                return true;
            }
        }
        return false;
    }

    public boolean isMonitoringAllowed() {
        return this.status.active;
    }

    public boolean isMonitoringClusterAlertsAllowed() {
        return this.isWatcherAllowed();
    }

    public boolean isUpdateRetentionAllowed() {
        License.OperationMode mode = this.status.mode;
        return mode != License.OperationMode.BASIC && mode != License.OperationMode.MISSING;
    }

    public boolean isGraphAllowed() {
        Status localStatus = this.status;
        License.OperationMode operationMode = localStatus.mode;
        boolean licensed = operationMode == License.OperationMode.TRIAL || operationMode == License.OperationMode.PLATINUM;
        return licensed && localStatus.active;
    }

    public boolean isMachineLearningAllowed() {
        Status localStatus = this.status;
        License.OperationMode operationMode = localStatus.mode;
        boolean licensed = operationMode == License.OperationMode.TRIAL || operationMode == License.OperationMode.PLATINUM;
        return licensed && localStatus.active;
    }

    public boolean isLogstashAllowed() {
        Status localStatus = this.status;
        if (!localStatus.active) {
            return false;
        }
        switch (localStatus.mode) {
            case TRIAL: 
            case STANDARD: 
            case GOLD: 
            case PLATINUM: {
                return true;
            }
        }
        return false;
    }

    public boolean isDeprecationAllowed() {
        return this.status.active;
    }

    public boolean isUpgradeAllowed() {
        Status localStatus = this.status;
        return localStatus.active;
    }

    static {
        LinkedHashMap<String, Object> messages = new LinkedHashMap<String, Object>();
        messages.put("security", new String[]{"Cluster health, cluster stats and indices stats operations are blocked", "All data operations (read and write) continue to work"});
        messages.put("watcher", new String[]{"PUT / GET watch APIs are disabled, DELETE watch API continues to work", "Watches execute and write to the history", "The actions of the watches don't execute"});
        messages.put("monitoring", new String[]{"The agent will stop collecting cluster and indices metrics", "The agent will stop automatically cleaning indices older than [xpack.monitoring.history.duration]"});
        messages.put("graph", new String[]{"Graph explore APIs are disabled"});
        messages.put("ml", new String[]{"Machine learning APIs are disabled"});
        messages.put("logstash", new String[]{"Logstash will continue to poll centrally-managed pipelines"});
        messages.put("deprecation", new String[]{"Deprecation APIs are disabled"});
        messages.put("upgrade", new String[]{"Upgrade API is disabled"});
        EXPIRATION_MESSAGES = Collections.unmodifiableMap(messages);
        messages = new LinkedHashMap();
        messages.put("security", XPackLicenseState::securityAcknowledgementMessages);
        messages.put("watcher", XPackLicenseState::watcherAcknowledgementMessages);
        messages.put("monitoring", XPackLicenseState::monitoringAcknowledgementMessages);
        messages.put("graph", XPackLicenseState::graphAcknowledgementMessages);
        messages.put("ml", XPackLicenseState::machineLearningAcknowledgementMessages);
        messages.put("logstash", XPackLicenseState::logstashAcknowledgementMessages);
        ACKNOWLEDGMENT_MESSAGES = Collections.unmodifiableMap(messages);
    }

    public static enum AllowedRealmType {
        NONE,
        NATIVE,
        DEFAULT,
        ALL;

    }

    private static class Status {
        final License.OperationMode mode;
        final boolean active;

        Status(License.OperationMode mode, boolean active) {
            this.mode = mode;
            this.active = active;
        }
    }
}

