/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.license;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.license.License;
import org.elasticsearch.xpack.core.XPackBuild;

public class XPackInfoResponse
extends ActionResponse {
    @Nullable
    private BuildInfo buildInfo;
    @Nullable
    private LicenseInfo licenseInfo;
    @Nullable
    private FeatureSetsInfo featureSetsInfo;

    public XPackInfoResponse() {
    }

    public XPackInfoResponse(@Nullable BuildInfo buildInfo, @Nullable LicenseInfo licenseInfo, @Nullable FeatureSetsInfo featureSetsInfo) {
        this.buildInfo = buildInfo;
        this.licenseInfo = licenseInfo;
        this.featureSetsInfo = featureSetsInfo;
    }

    public BuildInfo getBuildInfo() {
        return this.buildInfo;
    }

    public LicenseInfo getLicenseInfo() {
        return this.licenseInfo;
    }

    public FeatureSetsInfo getFeatureSetsInfo() {
        return this.featureSetsInfo;
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeOptionalWriteable((Writeable)this.buildInfo);
        out.writeOptionalWriteable((Writeable)this.licenseInfo);
        out.writeOptionalWriteable((Writeable)this.featureSetsInfo);
    }

    public void readFrom(StreamInput in) throws IOException {
        this.buildInfo = (BuildInfo)in.readOptionalWriteable(BuildInfo::new);
        this.licenseInfo = (LicenseInfo)in.readOptionalWriteable(LicenseInfo::new);
        this.featureSetsInfo = (FeatureSetsInfo)in.readOptionalWriteable(FeatureSetsInfo::new);
    }

    public static class FeatureSetsInfo
    implements ToXContentObject,
    Writeable {
        private final Map<String, FeatureSet> featureSets;

        public FeatureSetsInfo(StreamInput in) throws IOException {
            int size = in.readVInt();
            HashMap<String, FeatureSet> featureSets = new HashMap<String, FeatureSet>(size);
            for (int i = 0; i < size; ++i) {
                FeatureSet featureSet = new FeatureSet(in);
                featureSets.put(featureSet.name, featureSet);
            }
            this.featureSets = Collections.unmodifiableMap(featureSets);
        }

        public FeatureSetsInfo(Set<FeatureSet> featureSets) {
            HashMap<String, FeatureSet> map = new HashMap<String, FeatureSet>(featureSets.size());
            for (FeatureSet featureSet : featureSets) {
                map.put(featureSet.name, featureSet);
            }
            this.featureSets = Collections.unmodifiableMap(map);
        }

        public Map<String, FeatureSet> getFeatureSets() {
            return this.featureSets;
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            List names = new ArrayList<String>(this.featureSets.keySet()).stream().sorted().collect(Collectors.toList());
            for (String name : names) {
                builder.field(name, (ToXContent)this.featureSets.get(name), params);
            }
            return builder.endObject();
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeVInt(this.featureSets.size());
            for (FeatureSet featureSet : this.featureSets.values()) {
                featureSet.writeTo(out);
            }
        }

        public static class FeatureSet
        implements ToXContentObject,
        Writeable {
            private final String name;
            @Nullable
            private final String description;
            private final boolean available;
            private final boolean enabled;
            @Nullable
            private final Map<String, Object> nativeCodeInfo;

            public FeatureSet(StreamInput in) throws IOException {
                this(in.readString(), in.readOptionalString(), in.readBoolean(), in.readBoolean(), in.getVersion().onOrAfter(Version.V_5_4_0) ? in.readMap() : null);
            }

            public FeatureSet(String name, @Nullable String description, boolean available, boolean enabled, @Nullable Map<String, Object> nativeCodeInfo) {
                this.name = name;
                this.description = description;
                this.available = available;
                this.enabled = enabled;
                this.nativeCodeInfo = nativeCodeInfo;
            }

            public String name() {
                return this.name;
            }

            @Nullable
            public String description() {
                return this.description;
            }

            public boolean available() {
                return this.available;
            }

            public boolean enabled() {
                return this.enabled;
            }

            @Nullable
            public Map<String, Object> nativeCodeInfo() {
                return this.nativeCodeInfo;
            }

            public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
                builder.startObject();
                if (this.description != null) {
                    builder.field("description", this.description);
                }
                builder.field("available", this.available);
                builder.field("enabled", this.enabled);
                if (this.nativeCodeInfo != null) {
                    builder.field("native_code_info", this.nativeCodeInfo);
                }
                return builder.endObject();
            }

            public void writeTo(StreamOutput out) throws IOException {
                out.writeString(this.name);
                out.writeOptionalString(this.description);
                out.writeBoolean(this.available);
                out.writeBoolean(this.enabled);
                if (out.getVersion().onOrAfter(Version.V_5_4_0)) {
                    out.writeMap(this.nativeCodeInfo);
                }
            }
        }
    }

    public static class BuildInfo
    implements ToXContentObject,
    Writeable {
        private final String hash;
        private final String timestamp;

        public BuildInfo(XPackBuild build) {
            this(build.shortHash(), build.date());
        }

        public BuildInfo(StreamInput input) throws IOException {
            this(input.readString(), input.readString());
        }

        public BuildInfo(String hash, String timestamp) {
            this.hash = hash;
            this.timestamp = timestamp;
        }

        public String getHash() {
            return this.hash;
        }

        public String getTimestamp() {
            return this.timestamp;
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            return builder.startObject().field("hash", this.hash).field("date", this.timestamp).endObject();
        }

        public void writeTo(StreamOutput output) throws IOException {
            output.writeString(this.hash);
            output.writeString(this.timestamp);
        }
    }

    public static class LicenseInfo
    implements ToXContentObject,
    Writeable {
        private final String uid;
        private final String type;
        private final String mode;
        private final long expiryDate;
        private final License.Status status;

        public LicenseInfo(License license) {
            this(license.uid(), license.type(), license.operationMode().name().toLowerCase(Locale.ROOT), license.status(), license.expiryDate());
        }

        public LicenseInfo(StreamInput in) throws IOException {
            this(in.readString(), in.readString(), in.readString(), License.Status.readFrom(in), in.readLong());
        }

        public LicenseInfo(String uid, String type, String mode, License.Status status, long expiryDate) {
            this.uid = uid;
            this.type = type;
            this.mode = mode;
            this.status = status;
            this.expiryDate = expiryDate;
        }

        public String getUid() {
            return this.uid;
        }

        public String getType() {
            return this.type;
        }

        public String getMode() {
            return this.mode;
        }

        public long getExpiryDate() {
            return this.expiryDate;
        }

        public License.Status getStatus() {
            return this.status;
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            return builder.startObject().field("uid", this.uid).field("type", this.type).field("mode", this.mode).field("status", this.status.label()).dateField("expiry_date_in_millis", "expiry_date", this.expiryDate).endObject();
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.uid);
            out.writeString(this.type);
            out.writeString(this.mode);
            this.status.writeTo(out);
            out.writeLong(this.expiryDate);
        }
    }
}

