/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.watcher.trigger.schedule;

import java.io.IOException;
import java.time.Clock;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.xpack.watcher.support.Exceptions;
import org.elasticsearch.xpack.watcher.support.WatcherDateTimeUtils;
import org.elasticsearch.xpack.watcher.trigger.TriggerEngine;
import org.elasticsearch.xpack.watcher.trigger.TriggerEvent;
import org.elasticsearch.xpack.watcher.trigger.TriggerService;
import org.elasticsearch.xpack.watcher.trigger.schedule.Schedule;
import org.elasticsearch.xpack.watcher.trigger.schedule.ScheduleRegistry;
import org.elasticsearch.xpack.watcher.trigger.schedule.ScheduleTrigger;
import org.elasticsearch.xpack.watcher.trigger.schedule.ScheduleTriggerEvent;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

public abstract class ScheduleTriggerEngine
extends AbstractComponent
implements TriggerEngine<ScheduleTrigger, ScheduleTriggerEvent> {
    public static final String TYPE = "schedule";
    protected final List<Consumer<Iterable<TriggerEvent>>> consumers = new CopyOnWriteArrayList<Consumer<Iterable<TriggerEvent>>>();
    protected final ScheduleRegistry scheduleRegistry;
    protected final Clock clock;

    public ScheduleTriggerEngine(Settings settings, ScheduleRegistry scheduleRegistry, Clock clock) {
        super(settings);
        this.scheduleRegistry = scheduleRegistry;
        this.clock = clock;
    }

    @Override
    public String type() {
        return TYPE;
    }

    @Override
    public void register(Consumer<Iterable<TriggerEvent>> consumer) {
        this.consumers.add(consumer);
    }

    @Override
    public ScheduleTriggerEvent simulateEvent(String jobId, @Nullable Map<String, Object> data, TriggerService service) {
        DateTime scheduledTime;
        DateTime triggeredTime;
        DateTime now = new DateTime(this.clock.millis(), DateTimeZone.UTC);
        if (data == null) {
            return new ScheduleTriggerEvent(jobId, now, now);
        }
        Object value = data.get(ScheduleTriggerEvent.Field.TRIGGERED_TIME.getPreferredName());
        DateTime dateTime = triggeredTime = value != null ? WatcherDateTimeUtils.convertToDate(value, this.clock) : now;
        if (triggeredTime == null) {
            throw Exceptions.illegalArgument("could not simulate schedule event. could not convert provided triggered time [{}] to date/time", value);
        }
        value = data.get(ScheduleTriggerEvent.Field.SCHEDULED_TIME.getPreferredName());
        DateTime dateTime2 = scheduledTime = value != null ? WatcherDateTimeUtils.convertToDate(value, this.clock) : triggeredTime;
        if (scheduledTime == null) {
            throw Exceptions.illegalArgument("could not simulate schedule event. could not convert provided scheduled time [{}] to date/time", value);
        }
        return new ScheduleTriggerEvent(jobId, triggeredTime, scheduledTime);
    }

    @Override
    public ScheduleTrigger parseTrigger(String context, XContentParser parser) throws IOException {
        Schedule schedule = this.scheduleRegistry.parse(context, parser);
        return new ScheduleTrigger(schedule);
    }

    @Override
    public ScheduleTriggerEvent parseTriggerEvent(TriggerService service, String watchId, String context, XContentParser parser) throws IOException {
        return ScheduleTriggerEvent.parse(parser, watchId, context, this.clock);
    }
}

