/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.watcher.trigger.schedule;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.xpack.watcher.trigger.schedule.CronnableSchedule;
import org.elasticsearch.xpack.watcher.trigger.schedule.Schedule;
import org.elasticsearch.xpack.watcher.trigger.schedule.support.MonthTimes;

public class MonthlySchedule
extends CronnableSchedule {
    public static final String TYPE = "monthly";
    public static final MonthTimes[] DEFAULT_TIMES = new MonthTimes[]{new MonthTimes()};
    private final MonthTimes[] times;

    MonthlySchedule() {
        this(DEFAULT_TIMES);
    }

    MonthlySchedule(MonthTimes ... times) {
        super(MonthlySchedule.crons(times));
        this.times = times;
    }

    @Override
    public String type() {
        return TYPE;
    }

    public MonthTimes[] times() {
        return this.times;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (params.paramAsBoolean("normalize", false) && this.times.length == 1) {
            return this.times[0].toXContent(builder, params);
        }
        builder.startArray();
        for (MonthTimes monthTimes : this.times) {
            monthTimes.toXContent(builder, params);
        }
        return builder.endArray();
    }

    public static Builder builder() {
        return new Builder();
    }

    static String[] crons(MonthTimes[] times) {
        assert (times.length > 0) : "at least one time must be defined";
        HashSet<String> crons = new HashSet<String>(times.length);
        for (MonthTimes time : times) {
            crons.addAll(time.crons());
        }
        return crons.toArray(new String[crons.size()]);
    }

    public static class Builder {
        private final Set<MonthTimes> times = new HashSet<MonthTimes>();

        private Builder() {
        }

        public Builder time(MonthTimes time) {
            this.times.add(time);
            return this;
        }

        public Builder time(MonthTimes.Builder builder) {
            return this.time(builder.build());
        }

        public MonthlySchedule build() {
            return this.times.isEmpty() ? new MonthlySchedule() : new MonthlySchedule(this.times.toArray(new MonthTimes[this.times.size()]));
        }
    }

    public static class Parser
    implements Schedule.Parser<MonthlySchedule> {
        @Override
        public String type() {
            return MonthlySchedule.TYPE;
        }

        @Override
        public MonthlySchedule parse(XContentParser parser) throws IOException {
            if (parser.currentToken() == XContentParser.Token.START_OBJECT) {
                try {
                    return new MonthlySchedule(MonthTimes.parse(parser, parser.currentToken()));
                }
                catch (ElasticsearchParseException pe) {
                    throw new ElasticsearchParseException("could not parse [{}] schedule. invalid month times", (Throwable)pe, new Object[]{MonthlySchedule.TYPE});
                }
            }
            if (parser.currentToken() == XContentParser.Token.START_ARRAY) {
                XContentParser.Token token;
                ArrayList<MonthTimes> times = new ArrayList<MonthTimes>();
                while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                    try {
                        times.add(MonthTimes.parse(parser, token));
                    }
                    catch (ElasticsearchParseException pe) {
                        throw new ElasticsearchParseException("could not parse [{}] schedule. invalid month times", (Throwable)pe, new Object[]{MonthlySchedule.TYPE});
                    }
                }
                return times.isEmpty() ? new MonthlySchedule() : new MonthlySchedule(times.toArray(new MonthTimes[times.size()]));
            }
            throw new ElasticsearchParseException("could not parse [{}] schedule. expected either an object or an array of objects representing month times, but found [{}] instead", new Object[]{MonthlySchedule.TYPE, parser.currentToken()});
        }
    }
}

