/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.watcher.trigger;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.xpack.watcher.support.Exceptions;
import org.elasticsearch.xpack.watcher.trigger.Trigger;
import org.elasticsearch.xpack.watcher.trigger.TriggerEngine;
import org.elasticsearch.xpack.watcher.trigger.TriggerEvent;
import org.elasticsearch.xpack.watcher.watch.Watch;

public class TriggerService
extends AbstractComponent {
    private final GroupedConsumer consumer = new GroupedConsumer();
    private final Map<String, TriggerEngine> engines;

    public TriggerService(Settings settings, Set<TriggerEngine> engines) {
        super(settings);
        HashMap<String, TriggerEngine> builder = new HashMap<String, TriggerEngine>();
        for (TriggerEngine engine : engines) {
            builder.put(engine.type(), engine);
            engine.register(this.consumer);
        }
        this.engines = Collections.unmodifiableMap(builder);
    }

    public synchronized void start(Collection<Watch> watches) throws Exception {
        for (TriggerEngine engine : this.engines.values()) {
            engine.start(watches);
        }
    }

    public synchronized void stop() {
        for (TriggerEngine engine : this.engines.values()) {
            engine.stop();
        }
    }

    public synchronized void pauseExecution() {
        this.engines.values().forEach(TriggerEngine::pauseExecution);
    }

    public long count() {
        return this.engines.values().stream().mapToInt(TriggerEngine::getJobCount).sum();
    }

    public void add(Watch watch) {
        this.engines.get(watch.trigger().type()).add(watch);
    }

    public boolean remove(String jobName) {
        for (TriggerEngine engine : this.engines.values()) {
            if (!engine.remove(jobName)) continue;
            return true;
        }
        return false;
    }

    public void register(Consumer<Iterable<TriggerEvent>> consumer) {
        this.consumer.add(consumer);
    }

    public TriggerEvent simulateEvent(String type, String jobId, Map<String, Object> data) {
        TriggerEngine engine = this.engines.get(type);
        if (engine == null) {
            throw Exceptions.illegalArgument("could not simulate trigger event. unknown trigger type [{}]", type);
        }
        return engine.simulateEvent(jobId, data, this);
    }

    public Trigger parseTrigger(String jobName, XContentParser parser) throws IOException {
        XContentParser.Token token = parser.currentToken();
        assert (token == XContentParser.Token.START_OBJECT);
        token = parser.nextToken();
        if (token != XContentParser.Token.FIELD_NAME) {
            throw new ElasticsearchParseException("could not parse trigger for [{}]. expected trigger type string field, but found [{}]", new Object[]{jobName, token});
        }
        String type = parser.currentName();
        token = parser.nextToken();
        if (token != XContentParser.Token.START_OBJECT) {
            throw new ElasticsearchParseException("could not parse trigger [{}] for [{}]. expected trigger an object as the trigger body, but found [{}]", new Object[]{type, jobName, token});
        }
        Trigger trigger = this.parseTrigger(jobName, type, parser);
        token = parser.nextToken();
        if (token != XContentParser.Token.END_OBJECT) {
            throw new ElasticsearchParseException("could not parse trigger [{}] for [{}]. expected [END_OBJECT] token, but found [{}]", new Object[]{type, jobName, token});
        }
        return trigger;
    }

    public Trigger parseTrigger(String jobName, String type, XContentParser parser) throws IOException {
        TriggerEngine engine = this.engines.get(type);
        if (engine == null) {
            throw new ElasticsearchParseException("could not parse trigger [{}] for [{}]. unknown trigger type [{}]", new Object[]{type, jobName, type});
        }
        return engine.parseTrigger(jobName, parser);
    }

    public TriggerEvent parseTriggerEvent(String watchId, String context, XContentParser parser) throws IOException {
        XContentParser.Token token = parser.currentToken();
        assert (token == XContentParser.Token.START_OBJECT);
        token = parser.nextToken();
        if (token != XContentParser.Token.FIELD_NAME) {
            throw new ElasticsearchParseException("could not parse trigger event for [{}] for watch [{}]. expected trigger type string field, but found [{}]", new Object[]{context, watchId, token});
        }
        String type = parser.currentName();
        token = parser.nextToken();
        if (token != XContentParser.Token.START_OBJECT) {
            throw new ElasticsearchParseException("could not parse trigger event for [{}] for watch [{}]. expected trigger an object as the trigger body, but found [{}]", new Object[]{context, watchId, token});
        }
        TriggerEvent trigger = this.parseTriggerEvent(watchId, context, type, parser);
        token = parser.nextToken();
        if (token != XContentParser.Token.END_OBJECT) {
            throw new ElasticsearchParseException("could not parse trigger [{}] for [{}]. expected [END_OBJECT] token, but found [{}]", new Object[]{type, context, token});
        }
        return trigger;
    }

    public TriggerEvent parseTriggerEvent(String watchId, String context, String type, XContentParser parser) throws IOException {
        TriggerEngine engine = this.engines.get(type);
        if (engine == null) {
            throw new ElasticsearchParseException("Unknown trigger type [{}]", new Object[]{type});
        }
        return engine.parseTriggerEvent(this, watchId, context, parser);
    }

    static class GroupedConsumer
    implements Consumer<Iterable<TriggerEvent>> {
        private List<Consumer<Iterable<TriggerEvent>>> consumers = new CopyOnWriteArrayList<Consumer<Iterable<TriggerEvent>>>();

        GroupedConsumer() {
        }

        public void add(Consumer<Iterable<TriggerEvent>> consumer) {
            this.consumers.add(consumer);
        }

        @Override
        public void accept(Iterable<TriggerEvent> events) {
            this.consumers.forEach(c -> c.accept(events));
        }
    }
}

