/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.watcher.transport.actions.stats;

import java.io.IOException;
import java.util.List;
import java.util.Locale;
import org.elasticsearch.action.FailedNodeException;
import org.elasticsearch.action.support.nodes.BaseNodeResponse;
import org.elasticsearch.action.support.nodes.BaseNodesResponse;
import org.elasticsearch.cluster.ClusterName;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.xpack.watcher.WatcherMetaData;
import org.elasticsearch.xpack.watcher.WatcherState;
import org.elasticsearch.xpack.watcher.execution.QueuedWatch;
import org.elasticsearch.xpack.watcher.execution.WatchExecutionSnapshot;

public class WatcherStatsResponse
extends BaseNodesResponse<Node>
implements ToXContentObject {
    private WatcherMetaData watcherMetaData;

    public WatcherStatsResponse() {
    }

    public WatcherStatsResponse(ClusterName clusterName, WatcherMetaData watcherMetaData, List<Node> nodes, List<FailedNodeException> failures) {
        super(clusterName, nodes, failures);
        this.watcherMetaData = watcherMetaData;
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeBoolean(this.watcherMetaData.manuallyStopped());
    }

    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.watcherMetaData = new WatcherMetaData(in.readBoolean());
    }

    protected List<Node> readNodesFrom(StreamInput in) throws IOException {
        return in.readList(Node::readNodeResponse);
    }

    protected void writeNodesTo(StreamOutput out, List<Node> nodes) throws IOException {
        out.writeStreamableList(nodes);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        this.watcherMetaData.toXContent(builder, params);
        builder.startArray("stats");
        for (Node node : this.getNodes()) {
            node.toXContent(builder, params);
        }
        builder.endArray();
        return builder;
    }

    public long getWatchesCount() {
        return this.getNodes().stream().mapToLong(Node::getWatchesCount).sum();
    }

    public WatcherMetaData watcherMetaData() {
        return this.watcherMetaData;
    }

    public static class Node
    extends BaseNodeResponse
    implements ToXContentObject {
        private long watchesCount;
        private WatcherState watcherState;
        private long threadPoolQueueSize;
        private long threadPoolMaxSize;
        private List<WatchExecutionSnapshot> snapshots;
        private List<QueuedWatch> queuedWatches;

        Node() {
        }

        Node(DiscoveryNode node) {
            super(node);
        }

        public long getThreadPoolQueueSize() {
            return this.threadPoolQueueSize;
        }

        void setThreadPoolQueueSize(long threadPoolQueueSize) {
            this.threadPoolQueueSize = threadPoolQueueSize;
        }

        public long getThreadPoolMaxSize() {
            return this.threadPoolMaxSize;
        }

        void setThreadPoolMaxSize(long threadPoolMaxSize) {
            this.threadPoolMaxSize = threadPoolMaxSize;
        }

        public long getWatchesCount() {
            return this.watchesCount;
        }

        void setWatchesCount(long watchesCount) {
            this.watchesCount = watchesCount;
        }

        public WatcherState getWatcherState() {
            return this.watcherState;
        }

        void setWatcherState(WatcherState watcherServiceState) {
            this.watcherState = watcherServiceState;
        }

        @Nullable
        public List<WatchExecutionSnapshot> getSnapshots() {
            return this.snapshots;
        }

        void setSnapshots(List<WatchExecutionSnapshot> snapshots) {
            this.snapshots = snapshots;
        }

        @Nullable
        public List<QueuedWatch> getQueuedWatches() {
            return this.queuedWatches;
        }

        public void setQueuedWatches(List<QueuedWatch> queuedWatches) {
            this.queuedWatches = queuedWatches;
        }

        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            this.watchesCount = in.readLong();
            this.threadPoolQueueSize = in.readLong();
            this.threadPoolMaxSize = in.readLong();
            this.watcherState = WatcherState.fromId(in.readByte());
            if (in.readBoolean()) {
                this.snapshots = in.readStreamableList(WatchExecutionSnapshot::new);
            }
            if (in.readBoolean()) {
                this.queuedWatches = in.readStreamableList(QueuedWatch::new);
            }
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeLong(this.watchesCount);
            out.writeLong(this.threadPoolQueueSize);
            out.writeLong(this.threadPoolMaxSize);
            out.writeByte(this.watcherState.getId());
            if (this.snapshots != null) {
                out.writeBoolean(true);
                out.writeStreamableList(this.snapshots);
            } else {
                out.writeBoolean(false);
            }
            if (this.queuedWatches != null) {
                out.writeBoolean(true);
                out.writeStreamableList(this.queuedWatches);
            } else {
                out.writeBoolean(false);
            }
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field("node_id", this.getNode().getId());
            builder.field("watcher_state", this.watcherState.toString().toLowerCase(Locale.ROOT));
            builder.field("watch_count", this.watchesCount);
            builder.startObject("execution_thread_pool");
            builder.field("queue_size", this.threadPoolQueueSize);
            builder.field("max_size", this.threadPoolMaxSize);
            builder.endObject();
            if (this.snapshots != null) {
                builder.startArray("current_watches");
                for (WatchExecutionSnapshot snapshot : this.snapshots) {
                    snapshot.toXContent(builder, params);
                }
                builder.endArray();
            }
            if (this.queuedWatches != null) {
                builder.startArray("queued_watches");
                for (QueuedWatch queuedWatch : this.queuedWatches) {
                    queuedWatch.toXContent(builder, params);
                }
                builder.endArray();
            }
            builder.endObject();
            return builder;
        }

        public static Node readNodeResponse(StreamInput in) throws IOException {
            Node node = new Node();
            node.readFrom(in);
            return node;
        }
    }
}

