/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.watcher.transport.actions.stats;

import java.util.List;
import org.elasticsearch.action.FailedNodeException;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.nodes.TransportNodesAction;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.watcher.WatcherLifeCycleService;
import org.elasticsearch.xpack.watcher.WatcherService;
import org.elasticsearch.xpack.watcher.execution.ExecutionService;
import org.elasticsearch.xpack.watcher.transport.actions.stats.WatcherStatsRequest;
import org.elasticsearch.xpack.watcher.transport.actions.stats.WatcherStatsResponse;
import org.elasticsearch.xpack.watcher.trigger.TriggerService;

public class TransportWatcherStatsAction
extends TransportNodesAction<WatcherStatsRequest, WatcherStatsResponse, WatcherStatsRequest.Node, WatcherStatsResponse.Node> {
    private final WatcherService watcherService;
    private final ExecutionService executionService;
    private final TriggerService triggerService;
    private final WatcherLifeCycleService lifeCycleService;

    @Inject
    public TransportWatcherStatsAction(Settings settings, TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, WatcherService watcherService, ExecutionService executionService, TriggerService triggerService, WatcherLifeCycleService lifeCycleService) {
        super(settings, "cluster:monitor/xpack/watcher/stats/dist", threadPool, clusterService, transportService, actionFilters, indexNameExpressionResolver, WatcherStatsRequest::new, WatcherStatsRequest.Node::new, "management", WatcherStatsResponse.Node.class);
        this.watcherService = watcherService;
        this.executionService = executionService;
        this.triggerService = triggerService;
        this.lifeCycleService = lifeCycleService;
    }

    protected WatcherStatsResponse newResponse(WatcherStatsRequest request, List<WatcherStatsResponse.Node> nodes, List<FailedNodeException> failures) {
        return new WatcherStatsResponse(this.clusterService.getClusterName(), this.lifeCycleService.watcherMetaData(), nodes, failures);
    }

    protected WatcherStatsRequest.Node newNodeRequest(String nodeId, WatcherStatsRequest request) {
        return new WatcherStatsRequest.Node(request, nodeId);
    }

    protected WatcherStatsResponse.Node newNodeResponse() {
        return new WatcherStatsResponse.Node();
    }

    protected WatcherStatsResponse.Node nodeOperation(WatcherStatsRequest.Node request) {
        WatcherStatsResponse.Node statsResponse = new WatcherStatsResponse.Node(this.clusterService.localNode());
        statsResponse.setWatcherState(this.watcherService.state());
        statsResponse.setThreadPoolQueueSize(this.executionService.executionThreadPoolQueueSize());
        statsResponse.setThreadPoolMaxSize(this.executionService.executionThreadPoolMaxSize());
        if (request.includeCurrentWatches()) {
            statsResponse.setSnapshots(this.executionService.currentExecutions());
        }
        if (request.includeQueuedWatches()) {
            statsResponse.setQueuedWatches(this.executionService.queuedWatches());
        }
        statsResponse.setWatchesCount(this.triggerService.count());
        return statsResponse;
    }
}

